/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition.field;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.definition.field.DefaultFieldDefinition;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.MapUtils;

public class MapFieldDefinition
extends DefaultFieldDefinition {
    public MapFieldDefinition(Field field, boolean required) {
        super(field, (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1], required);
    }

    @Override
    protected Object extractInjectionObject(IocMaking making, Class<?> klass, Field field) {
        List<DefaultBeanDefinition> allImpl = making.findAllImpl(this.fieldClass);
        if (allImpl.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = MapUtils.newHashMap(allImpl.size());
        Class<?> keyClass = FieldUtils.getMapFieldKeyClass(field);
        if (Integer.class.equals(keyClass)) {
            allImpl.forEach(v -> Arrays.stream(v.getIds()).forEach(n -> result.put(n, v.getSingle())));
        } else {
            allImpl.forEach(v -> Arrays.stream(v.getNames()).forEach(n -> result.put(n, v.getSingle())));
        }
        return result;
    }
}

