/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.ModuleController;
import xyz.noark.core.annotation.controller.CommandMapping;
import xyz.noark.core.annotation.controller.EventListener;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.annotation.controller.GetMapping;
import xyz.noark.core.annotation.controller.PacketMapping;
import xyz.noark.core.annotation.controller.PostMapping;
import xyz.noark.core.annotation.controller.RequestMapping;
import xyz.noark.core.annotation.controller.Scheduled;
import xyz.noark.core.ioc.NoarkIoc;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.definition.method.EventMethodDefinition;
import xyz.noark.core.ioc.definition.method.HttpMethodDefinition;
import xyz.noark.core.ioc.definition.method.PacketMethodDefinition;
import xyz.noark.core.ioc.definition.method.ScheduledMethodDefinition;
import xyz.noark.core.ioc.manager.EventMethodManager;
import xyz.noark.core.ioc.manager.HttpMethodManager;
import xyz.noark.core.ioc.manager.PacketMethodManager;
import xyz.noark.core.ioc.manager.ScheduledMethodManager;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;
import xyz.noark.core.ioc.wrap.method.HttpMethodWrapper;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.core.ioc.wrap.method.ScheduledMethodWrapper;

public class ControllerBeanDefinition
extends DefaultBeanDefinition {
    private final ExecThreadGroup threadGroup;
    private final Class<?> controllerMasterClass;
    private final String queueId;
    private final ArrayList<PacketMethodDefinition> pmds = new ArrayList();
    private final ArrayList<EventMethodDefinition> emds = new ArrayList();
    private final ArrayList<HttpMethodDefinition> hmds = new ArrayList();
    private final ArrayList<ScheduledMethodDefinition> smds = new ArrayList();

    public ControllerBeanDefinition(Class<?> klass, Controller controller) {
        this(klass, controller.threadGroup(), controller.value(), klass);
    }

    public ControllerBeanDefinition(Class<?> klass, ModuleController controller) {
        this(klass, ExecThreadGroup.ModuleThreadGroup, "", controller.master());
    }

    private ControllerBeanDefinition(Class<?> klass, ExecThreadGroup threadGroup, String queueId, Class<?> controllerMasterClass) {
        super(klass);
        this.queueId = queueId;
        this.threadGroup = threadGroup;
        this.controllerMasterClass = controllerMasterClass;
    }

    @Override
    protected void analysisMethodByAnnotation(Class<? extends Annotation> annotationType, Annotation annotation, Method method) {
        if (annotationType == PacketMapping.class) {
            this.pmds.add(new PacketMethodDefinition(this.methodAccess, method, (PacketMapping)PacketMapping.class.cast(annotation)));
        } else if (annotationType == CommandMapping.class) {
            this.pmds.add(new PacketMethodDefinition(this.methodAccess, method, (CommandMapping)CommandMapping.class.cast(annotation)));
        } else if (annotationType == EventListener.class) {
            this.emds.add(new EventMethodDefinition(this.methodAccess, method, (EventListener)EventListener.class.cast(annotation), this));
        } else if (annotationType == RequestMapping.class) {
            this.hmds.add(new HttpMethodDefinition(this.methodAccess, method, (RequestMapping)RequestMapping.class.cast(annotation)));
        } else if (annotationType == GetMapping.class) {
            this.hmds.add(new HttpMethodDefinition(this.methodAccess, method, (GetMapping)GetMapping.class.cast(annotation)));
        } else if (annotationType == PostMapping.class) {
            this.hmds.add(new HttpMethodDefinition(this.methodAccess, method, (PostMapping)PostMapping.class.cast(annotation)));
        } else if (annotationType == Scheduled.class) {
            this.smds.add(new ScheduledMethodDefinition(this.methodAccess, method, (Scheduled)Scheduled.class.cast(annotation)));
        } else {
            super.analysisMethodByAnnotation(annotationType, annotation, method);
        }
    }

    @Override
    public void doAnalysisFunction(NoarkIoc noarkIoc) {
        super.doAnalysisFunction(noarkIoc);
        this.doAnalysisPacketHandler(noarkIoc);
        this.doAnalysisEventHandler(noarkIoc);
        this.doAnalysisHttpHandler(noarkIoc);
        this.doAnalysisScheduledHandler(noarkIoc);
    }

    private void doAnalysisScheduledHandler(NoarkIoc noarkIoc) {
        ScheduledMethodManager manager = ScheduledMethodManager.getInstance();
        this.smds.forEach(smd -> manager.resetScheduledHandler(new ScheduledMethodWrapper(this.methodAccess, this.single, (ScheduledMethodDefinition)smd, this.threadGroup, this.controllerMasterClass)));
    }

    private void doAnalysisHttpHandler(NoarkIoc noarkIoc) {
        this.hmds.forEach(hmd -> HttpMethodManager.registerHandler(new HttpMethodWrapper(this.methodAccess, this.single, (HttpMethodDefinition)hmd, this.threadGroup, this.controllerMasterClass)));
    }

    private void doAnalysisEventHandler(NoarkIoc ioc) {
        EventMethodManager manager = EventMethodManager.getInstance();
        this.emds.forEach(emd -> manager.resetEventHandler(new EventMethodWrapper(this.methodAccess, this.single, (EventMethodDefinition)emd, this.threadGroup, this.controllerMasterClass)));
    }

    private void doAnalysisPacketHandler(NoarkIoc noarkIoc) {
        PacketMethodManager manager = PacketMethodManager.getInstance();
        this.pmds.forEach(pmd -> manager.resetPacketHandler(new PacketMethodWrapper(this.methodAccess, this.single, (PacketMethodDefinition)pmd, this.threadGroup, this.controllerMasterClass, this.queueId)));
    }
}

