/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.Ioc;
import xyz.noark.core.ioc.IocHolder;
import xyz.noark.core.ioc.IocLoader;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.manager.EventMethodManager;
import xyz.noark.core.ioc.wrap.MethodWrapper;
import xyz.noark.log.LogHelper;

public class NoarkIoc
implements Ioc {
    private final ConcurrentHashMap<Class<?>, Object> singletons = new ConcurrentHashMap(512);
    private final ConcurrentHashMap<Class<? extends Annotation>, List<MethodWrapper>> customMethods = new ConcurrentHashMap();

    public NoarkIoc(String packager) {
        String[] packages = Arrays.asList(packager, "xyz.noark").toArray(new String[0]);
        LogHelper.logger.debug("init ioc, packages={}", new Object[]{packager});
        IocLoader loader = new IocLoader(packages);
        try (IocMaking making = new IocMaking(loader);){
            this.finishBeanInitialization(loader, making, loader.getConfigurations());
            this.finishBeanInitialization(loader, making, loader.getBeans().values());
            this.finishBeanInitialization(loader, making, loader.getStaticComponents());
        }
        this.finishBeanAnalysis(loader);
        IocHolder.setIoc(this);
    }

    private void finishBeanAnalysis(IocLoader loader) {
        loader.getBeans().forEach((k, v) -> v.doAnalysisFunction(this));
        EventMethodManager.getInstance().listenerExtend().sort();
        this.customMethods.values().forEach(v -> v.sort((m1, m2) -> Integer.compare(m1.getOrder(), m2.getOrder())));
        this.singletons.putAll(loader.getBeans().values().stream().collect(Collectors.toMap(DefaultBeanDefinition::getBeanClass, v -> v.getSingle())));
    }

    private void finishBeanInitialization(IocLoader loader, IocMaking making, Collection<? extends BeanDefinition> beans) {
        beans.forEach(bean -> bean.injection(making));
    }

    @Override
    public <T> T get(Class<T> klass) {
        return klass.cast(this.singletons.get(klass));
    }

    public void invokeCustomAnnotationMethod(Class<? extends Annotation> klass) {
        this.customMethods.getOrDefault(klass, Collections.emptyList()).forEach(v -> v.invoke(new Object[0]));
    }

    public <T> List<T> findImpl(Class<T> klass) {
        return this.singletons.values().stream().filter(v -> klass.isInstance(v)).collect(Collectors.toList());
    }

    public void addCustomMethod(Class<? extends Annotation> klass, MethodWrapper mw) {
        this.customMethods.computeIfAbsent(klass, key -> new ArrayList()).add(mw);
    }

    public void destroy() {
        this.invokeCustomAnnotationMethod(PreDestroy.class);
    }
}

