/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import xyz.noark.core.annotation.Component;
import xyz.noark.core.annotation.Configuration;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.ModuleController;
import xyz.noark.core.annotation.StaticComponent;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.definition.ConfigurationBeanDefinition;
import xyz.noark.core.ioc.definition.ControllerBeanDefinition;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.definition.StaticComponentBeanDefinition;
import xyz.noark.core.ioc.scan.Resource;
import xyz.noark.core.ioc.scan.ResourceScanning;
import xyz.noark.core.util.AnnotationUtils;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.MapUtils;

public class IocLoader {
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private static final String CLASS_SUFFIX = ".class";
    private final HashMap<Class<?>, DefaultBeanDefinition> beans = MapUtils.newHashMap(1024);
    private final List<BeanDefinition> configurations = new ArrayList<BeanDefinition>();
    private final List<StaticComponentBeanDefinition> staticComponents = new ArrayList<StaticComponentBeanDefinition>();

    IocLoader(String ... packages) {
        ResourceScanning.scanPackage(packages, this::analysisResource);
    }

    protected List<DefaultBeanDefinition> findImpl(Class<?> klass) {
        return this.beans.values().stream().filter(v -> klass.isInstance(v.getSingle())).collect(Collectors.toList());
    }

    private void analysisResource(Resource resource) {
        String resourceName = resource.getName();
        if (PACKAGE_INFO_CLASS.equals(resourceName)) {
            return;
        }
        if (!resourceName.endsWith(CLASS_SUFFIX)) {
            return;
        }
        this.analysisClass(ClassUtils.loadClass(resourceName.substring(0, resourceName.length() - 6).replaceAll("[/\\\\]", ".")));
    }

    private void analysisClass(Class<?> klass) {
        if (klass.isInterface() || klass.isMemberClass() || klass.isEnum() || klass.isAnnotation() || klass.isAnonymousClass()) {
            return;
        }
        int modify = klass.getModifiers();
        if (Modifier.isAbstract(modify) || !Modifier.isPublic(modify)) {
            return;
        }
        Annotation annotation = AnnotationUtils.getAnnotation(klass, Component.class);
        if (annotation == null) {
            return;
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType == Configuration.class) {
            this.configurations.add(new ConfigurationBeanDefinition(klass).init());
        } else if (annotationType == TemplateConverter.class) {
            ConvertManager.getInstance().register(klass, (TemplateConverter)annotation);
        } else if (annotationType == Controller.class) {
            this.analytical(klass, (Controller)annotation);
        } else if (annotationType == ModuleController.class) {
            this.analytical(klass, (ModuleController)annotation);
        } else if (annotationType == StaticComponent.class) {
            this.staticComponents.add(new StaticComponentBeanDefinition(klass).init());
        } else {
            this.beans.put(klass, new DefaultBeanDefinition(klass, annotation, annotationType).init());
        }
    }

    private void analytical(Class<?> klass, ModuleController controller) {
        this.beans.put(klass, new ControllerBeanDefinition(klass, controller).init());
    }

    private void analytical(Class<?> klass, Controller controller) {
        this.beans.put(klass, new ControllerBeanDefinition(klass, controller).init());
    }

    public HashMap<Class<?>, DefaultBeanDefinition> getBeans() {
        return this.beans;
    }

    public List<BeanDefinition> getConfigurations() {
        return this.configurations;
    }

    public List<StaticComponentBeanDefinition> getStaticComponents() {
        return this.staticComponents;
    }
}

