/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.lang.StringList;
import xyz.noark.core.util.StringUtils;

@TemplateConverter(value={StringList.class})
public class StringListConverter
extends AbstractConverter<StringList> {
    @Override
    public StringList convert(String value) {
        if (StringUtils.isEmpty(value)) {
            return new StringList();
        }
        return new StringList((Collection<String>)Arrays.asList(StringUtils.split(value, ",")));
    }

    @Override
    public StringList convert(Field field, Map<String, String> data) {
        if (data.isEmpty()) {
            return new StringList();
        }
        return new StringList(data.values());
    }

    @Override
    public String buildErrorMsg() {
        return "\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u6570\u7ec4\u5e94\u8be5\u662f\u4ee5\u82f1\u6587\u9017\u53f7\u5206\u9694\u7684\uff0c\u5982\uff1aaaa,bbb,ccc,ddd";
    }
}

