/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.time.LocalTime;
import java.util.ArrayList;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.lang.LocalTimeArray;
import xyz.noark.core.util.StringUtils;

@TemplateConverter(value={LocalTimeArray.class})
public class LocalTimeArrayConverter
extends AbstractConverter<LocalTimeArray> {
    @Override
    public String buildErrorMsg() {
        return "\u683c\u5f0f\t08:00,16:00,22:00";
    }

    @Override
    public LocalTimeArray convert(String value) throws Exception {
        String[] array = StringUtils.split(value, ",");
        ArrayList<LocalTime> result = new ArrayList<LocalTime>(array.length);
        for (String time : array) {
            String[] ts = StringUtils.split(time, ":");
            if (ts.length == 2) {
                result.add(LocalTime.of(Integer.parseInt(ts[0]), Integer.parseInt(ts[1])));
                continue;
            }
            if (ts.length == 3) {
                result.add(LocalTime.of(Integer.parseInt(ts[0]), Integer.parseInt(ts[1]), Integer.parseInt(ts[2])));
                continue;
            }
            throw new ConvertException("\u65f6\u95f4\u914d\u7f6e2\u4f4d'08:00,12:00,22:00'\u62163\u4f4d'08:00:00,12:00:00,22:00:00'");
        }
        return new LocalTimeArray(result.toArray(new LocalTime[0]));
    }
}

