/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import xyz.noark.core.annotation.DateTimeFormat;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;

@TemplateConverter(value={LocalDateTime.class})
public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    @Override
    public String buildErrorMsg() {
        return "\u4e0d\u662f\u4e00\u4e2aLocalDateTime\u7c7b\u578b\u7684\u5b57\u7b26\u4e32";
    }

    @Override
    public LocalDateTime convert(Field field, String value) throws Exception {
        return this.convert(field.getAnnotation(DateTimeFormat.class), value);
    }

    @Override
    public LocalDateTime convert(Parameter parameter, String value) throws Exception {
        if (value == null) {
            return null;
        }
        return this.convert(parameter.getAnnotation(DateTimeFormat.class), value);
    }

    private LocalDateTime convert(DateTimeFormat format, String value) throws ParseException {
        if (format == null) {
            return LocalDateTime.parse(value);
        }
        return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(format.pattern()));
    }

    @Override
    public LocalDateTime convert(Field field, Map<String, String> data) throws Exception {
        throw new ConvertException("LocalDateTime\u65e0\u6cd5\u8f6c\u5316Map\u7c7b\u578b\u7684\u914d\u7f6e...");
    }
}

