/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import xyz.noark.core.annotation.DateTimeFormat;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;

@TemplateConverter(value={LocalDate.class})
public class LocalDateConverter
implements Converter<LocalDate> {
    @Override
    public String buildErrorMsg() {
        return "\u4e0d\u662f\u4e00\u4e2aLocalDate\u7c7b\u578b\u7684\u5b57\u7b26\u4e32";
    }

    @Override
    public LocalDate convert(Field field, String value) throws Exception {
        return this.convert(field.getAnnotation(DateTimeFormat.class), value);
    }

    @Override
    public LocalDate convert(Parameter parameter, String value) throws Exception {
        if (value == null) {
            return null;
        }
        return this.convert(parameter.getAnnotation(DateTimeFormat.class), value);
    }

    private LocalDate convert(DateTimeFormat format, String value) throws ParseException {
        if (format == null) {
            return LocalDate.parse(value);
        }
        return LocalDate.parse(value, DateTimeFormatter.ofPattern(format.pattern()));
    }

    @Override
    public LocalDate convert(Field field, Map<String, String> data) throws Exception {
        throw new ConvertException("LocalDateConverter\u65e0\u6cd5\u8f6c\u5316Map\u7c7b\u578b\u7684\u914d\u7f6e...");
    }
}

