/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter;

import java.util.HashMap;
import java.util.Map;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.converter.impl.BooleanConverter;
import xyz.noark.core.converter.impl.FloatConverter;
import xyz.noark.core.converter.impl.FloatListConverter;
import xyz.noark.core.converter.impl.IntListConverter;
import xyz.noark.core.converter.impl.IntegerConverter;
import xyz.noark.core.converter.impl.LongConverter;
import xyz.noark.core.converter.impl.StringConverter;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.util.ClassUtils;

public class ConvertManager {
    private static final ConvertManager INSTANCE = new ConvertManager();
    private static final Map<Class<?>, Converter<?>> CONVERTERS = new HashMap(128);

    private ConvertManager() {
    }

    public static ConvertManager getInstance() {
        return INSTANCE;
    }

    public <T> Converter<T> getConverter(Class<T> type) {
        return CONVERTERS.get(type);
    }

    public void register(Class<?> klass, TemplateConverter templateConverter) {
        Object object = ClassUtils.newInstance(klass);
        if (!(object instanceof Converter)) {
            throw new ServerBootstrapException("\u975e\u6cd5\u7684\u8f6c\u5316\u5668." + klass.getName());
        }
        this.putConvert((Converter)object, templateConverter);
    }

    public void register(Class<? extends Converter<?>> klass) {
        this.putConvert(ClassUtils.newInstance(klass), klass.getAnnotation(TemplateConverter.class));
    }

    private void putConvert(Converter<?> converter, TemplateConverter annotation) {
        for (Class<?> targetClass : annotation.value()) {
            CONVERTERS.put(targetClass, converter);
        }
    }

    static {
        INSTANCE.register(BooleanConverter.class);
        INSTANCE.register(IntegerConverter.class);
        INSTANCE.register(LongConverter.class);
        INSTANCE.register(StringConverter.class);
        INSTANCE.register(FloatConverter.class);
        INSTANCE.register(IntListConverter.class);
        INSTANCE.register(FloatListConverter.class);
    }
}

