/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class Utilities {
    private static final int BUFFER_SIZE = 4096;
    private static char[] charBuffer = null;
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
    public static final Pattern SPACE_NEWLINE_SPACE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*");
    public static final Pattern COMMENT_NEWLINE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*\\**[ \t\f]*");
    public static final int ESCAPE_BELL_VT = 1;
    public static final int ESCAPE_DOUBLE = 2;
    public static final int ESCAPE_REGEX = 4;
    public static final int ESCAPE_UNICODE = 8;
    public static final int ESCAPE_HTML = 16;
    public static final int C_ESCAPES = 9;
    public static final int JAVA_ESCAPES = 8;
    public static final int JAVA_HTML_ESCAPES = 24;
    public static final int FULL_ESCAPES = 12;
    public static final int FULL_HTML_ESCAPES = 28;

    private Utilities() {
    }

    public static boolean isQualified(String name) {
        int length = name.length();
        boolean opaque = false;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (opaque) {
                if (')' != c) continue;
                opaque = false;
                continue;
            }
            if ('.' == c) {
                return true;
            }
            if ('(' != c) continue;
            opaque = true;
        }
        return false;
    }

    public static String getQualifier(String qname) {
        boolean opaque = false;
        for (int i = qname.length() - 1; i >= 0; --i) {
            char c = qname.charAt(i);
            if (opaque) {
                if ('(' != c) continue;
                opaque = false;
                continue;
            }
            if ('.' == c) {
                return qname.substring(0, i);
            }
            if (')' != c) continue;
            opaque = true;
        }
        return null;
    }

    public static String getName(String qname) {
        boolean opaque = false;
        for (int i = qname.length() - 1; i >= 0; --i) {
            char c = qname.charAt(i);
            if (opaque) {
                if ('(' != c) continue;
                opaque = false;
                continue;
            }
            if ('.' == c) {
                return qname.substring(i + 1);
            }
            if (')' != c) continue;
            opaque = true;
        }
        return qname;
    }

    public static String unqualify(String name) {
        return Utilities.isQualified(name) ? Utilities.getName(name) : name;
    }

    public static String qualify(String qualifier, String name) {
        return null == qualifier ? name : qualifier + '.' + name;
    }

    public static String[] toComponents(String qname) {
        int length = qname.length();
        int count = 1;
        boolean opaque = false;
        for (int i = 0; i < length; ++i) {
            char c = qname.charAt(i);
            if (opaque) {
                if (')' != c) continue;
                opaque = false;
                continue;
            }
            if ('.' == c) {
                ++count;
            }
            if ('(' != c) continue;
            opaque = true;
        }
        if (1 == count) {
            return new String[]{qname};
        }
        String[] components = new String[count];
        int start = -1;
        count = 0;
        for (int i = 0; i < length; ++i) {
            char c = qname.charAt(i);
            if (opaque) {
                if (')' != c) continue;
                opaque = false;
                continue;
            }
            if ('.' == c) {
                components[count] = qname.substring(start + 1, i);
                start = i;
                ++count;
                continue;
            }
            if ('(' != c) continue;
            opaque = true;
        }
        components[count] = qname.substring(start + 1, length);
        return components;
    }

    private static String requalify(String s, char qual) {
        int length = s.length();
        StringBuilder buf = new StringBuilder(length);
        boolean opaque = false;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (opaque) {
                buf.append(c);
                if (')' != c) continue;
                opaque = false;
                continue;
            }
            if ('.' == c) {
                buf.append(qual);
                continue;
            }
            buf.append(c);
            if ('(' != c) continue;
            opaque = true;
        }
        return buf.toString();
    }

    public static String toIdentifier(String qname) {
        return Utilities.requalify(qname, '$');
    }

    public static String toPath(String qname) {
        return Utilities.requalify(qname, File.separatorChar);
    }

    public static String toPath(String qname, String ext) {
        return Utilities.toPath(qname) + '.' + ext;
    }

    public static File locate(List<File> roots, String path) throws FileNotFoundException {
        for (File root : roots) {
            File file = new File(root, path);
            if (!file.exists() || !file.isFile()) continue;
            return file;
        }
        throw new FileNotFoundException(path + " not found");
    }

    public static void pump(Reader in, Writer out) throws IOException {
        if (null == charBuffer) {
            charBuffer = new char[4096];
        }
        int number = in.read(charBuffer);
        while (-1 != number) {
            out.write(charBuffer, 0, number);
            number = in.read(charBuffer);
        }
    }

    public static String withoutSpace(String s) {
        return WHITE_SPACE.matcher(s).replaceAll("");
    }

    public static boolean useBellVTEscapes(int flags) {
        return 0 != (1 & flags);
    }

    public static boolean useDoubleEscapes(int flags) {
        return 0 != (2 & flags);
    }

    public static boolean useRegexEscapes(int flags) {
        return 0 != (4 & flags);
    }

    public static boolean useUnicodeEscapes(int flags) {
        return 0 != (8 & flags);
    }

    public static boolean useHTMLEscapes(int flags) {
        return 0 != (0x10 & flags);
    }

    public static void escape(char c, Appendable out, int flags) throws IOException {
        switch (c) {
            case '\u0007': {
                if (!Utilities.useBellVTEscapes(flags)) break;
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\a");
                    break;
                }
                out.append("\\a");
                break;
            }
            case '\b': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\b");
                } else {
                    out.append("\\b");
                }
                return;
            }
            case '\t': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\t");
                } else {
                    out.append("\\t");
                }
                return;
            }
            case '\n': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\n");
                } else {
                    out.append("\\n");
                }
                return;
            }
            case '\u000b': {
                if (!Utilities.useBellVTEscapes(flags)) break;
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\v");
                    break;
                }
                out.append("\\v");
                break;
            }
            case '\f': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\f");
                } else {
                    out.append("\\f");
                }
                return;
            }
            case '\r': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\r");
                } else {
                    out.append("\\r");
                }
                return;
            }
            case '\"': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\\\\"");
                } else {
                    out.append("\\\"");
                }
                return;
            }
            case '\'': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\\\'");
                } else {
                    out.append("\\'");
                }
                return;
            }
            case '-': {
                if (Utilities.useRegexEscapes(flags)) {
                    if (Utilities.useDoubleEscapes(flags)) {
                        out.append("\\\\-");
                    } else {
                        out.append("\\-");
                    }
                } else {
                    out.append('-');
                }
                return;
            }
            case '<': {
                if (Utilities.useHTMLEscapes(flags)) {
                    out.append("&lt;");
                } else {
                    out.append('<');
                }
                return;
            }
            case '>': {
                if (Utilities.useHTMLEscapes(flags)) {
                    out.append("&gt;");
                } else {
                    out.append('>');
                }
                return;
            }
            case '[': {
                if (Utilities.useRegexEscapes(flags)) {
                    if (Utilities.useDoubleEscapes(flags)) {
                        out.append("\\\\[");
                    } else {
                        out.append("\\[");
                    }
                } else {
                    out.append('[');
                }
                return;
            }
            case '\\': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\\\\\");
                } else {
                    out.append("\\\\");
                }
                return;
            }
            case ']': {
                if (Utilities.useRegexEscapes(flags)) {
                    if (Utilities.useDoubleEscapes(flags)) {
                        out.append("\\\\]");
                    } else {
                        out.append("\\]");
                    }
                } else {
                    out.append(']');
                }
                return;
            }
        }
        if (Utilities.useUnicodeEscapes(flags) && (' ' > c || '~' < c)) {
            String padding;
            String hex = Integer.toHexString(c);
            switch (hex.length()) {
                case 1: {
                    padding = "000";
                    break;
                }
                case 2: {
                    padding = "00";
                    break;
                }
                case 3: {
                    padding = "0";
                    break;
                }
                default: {
                    padding = "";
                }
            }
            if (Utilities.useDoubleEscapes(flags)) {
                out.append("\\\\");
            } else {
                out.append("\\");
            }
            out.append('u');
            out.append(padding);
            out.append(hex);
        } else {
            out.append(c);
        }
    }

    public static void escape(String s, Appendable out, int flags) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            Utilities.escape(s.charAt(i), out, flags);
        }
    }

    public static String escape(char c, int flags) {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder(1);
            try {
                Utilities.escape(c, (Appendable)buf, flags);
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    public static String escape(String s, int flags) {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder(s.length());
            try {
                Utilities.escape(s, (Appendable)buf, flags);
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    public static String unescape(String s) {
        if (-1 == s.indexOf(92)) {
            return s;
        }
        int length = s.length();
        StringBuilder buf = new StringBuilder(length);
        block20: for (int i = 0; i < length; ++i) {
            int c = s.charAt(i);
            if (92 != c) {
                buf.append((char)c);
                continue;
            }
            if (++i >= length) {
                throw new IllegalArgumentException("incomplete escape sequence");
            }
            c = s.charAt(i);
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int val = c;
                    if (i + 1 < length && 48 <= (c = s.charAt(i + 1)) && c <= 55) {
                        val = val * 8 + c;
                        if (++i + 1 < length && 48 <= (c = (int)s.charAt(i + 1)) && c <= 55) {
                            val = val * 8 + c;
                            ++i;
                        }
                    }
                    buf.append((char)val);
                    continue block20;
                }
                case 34: {
                    buf.append('\"');
                    continue block20;
                }
                case 39: {
                    buf.append('\'');
                    continue block20;
                }
                case 45: {
                    buf.append('-');
                    continue block20;
                }
                case 63: {
                    buf.append('?');
                    continue block20;
                }
                case 91: {
                    buf.append('[');
                    continue block20;
                }
                case 92: {
                    buf.append('\\');
                    continue block20;
                }
                case 93: {
                    buf.append(']');
                    continue block20;
                }
                case 97: {
                    buf.append('\u0007');
                    continue block20;
                }
                case 98: {
                    buf.append('\b');
                    continue block20;
                }
                case 102: {
                    buf.append('\f');
                    continue block20;
                }
                case 110: {
                    buf.append('\n');
                    continue block20;
                }
                case 114: {
                    buf.append('\r');
                    continue block20;
                }
                case 116: {
                    buf.append('\t');
                    continue block20;
                }
                case 117: {
                    int n;
                    if ((i += 4) >= length) {
                        throw new IllegalArgumentException("incomplete universal character name " + s.substring(i - 3));
                    }
                    try {
                        n = Integer.parseInt(s.substring(i - 3, i + 1), 16);
                    }
                    catch (NumberFormatException x) {
                        throw new IllegalArgumentException("malformed universal character name " + s.substring(i - 3, i + 1));
                    }
                    buf.append((char)n);
                    continue block20;
                }
                case 118: {
                    buf.append('\u000b');
                    continue block20;
                }
                default: {
                    throw new IllegalArgumentException("illegal escaped character '\\" + (char)c + "'");
                }
            }
        }
        return buf.toString();
    }

    public static String format(List<?> l) {
        int length = l.size();
        StringBuilder buf = new StringBuilder();
        Iterator<?> iter = l.iterator();
        while (iter.hasNext()) {
            String el = iter.next().toString();
            if (1 < length && !iter.hasNext()) {
                buf.append("and ");
            }
            buf.append(el);
            if (2 == length && iter.hasNext()) {
                buf.append(' ');
                continue;
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String split(String id, char separator) {
        int idx = id.indexOf(36);
        if (-1 != idx) {
            id = id.substring(0, idx);
        }
        int length = id.length();
        boolean startsUpper = false;
        int upperCount = 0;
        for (int i = 0; i < length; ++i) {
            if (!Character.isUpperCase(id.charAt(i))) continue;
            if (0 == i) {
                startsUpper = true;
            }
            ++upperCount;
        }
        if (0 == upperCount || length == upperCount) {
            return id;
        }
        int size = startsUpper ? length + upperCount - 1 : length + upperCount;
        StringBuilder buf = new StringBuilder(size);
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c)) {
                if (0 != i) {
                    buf.append(separator);
                }
                buf.append(Character.toLowerCase(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toArticle(String noun) {
        if (noun.startsWith("a") || noun.startsWith("e") || noun.startsWith("i") || noun.startsWith("o") || noun.startsWith("u")) {
            return "an";
        }
        return "a";
    }
}

