/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import xtc.parser.ParseException;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.VisitingException;
import xtc.util.Runtime;
import xtc.util.Statistics;

public abstract class Tool {
    protected final Runtime runtime = new Runtime();

    public abstract String getName();

    public String getVersion() {
        return "1.15.0";
    }

    public String getCopy() {
        return "(C) 2004-2009 Robert Grimm and New York University";
    }

    public String getExplanation() {
        return null;
    }

    public void init() {
        this.runtime.bool("silent", "optionSilent", false, "Enable silent operation.").bool("verbose", "optionVerbose", false, "Enable verbose operation.").bool("no-exit", "optionNoExit", false, "Do not explicitly exit the Java virtual machine.").dir("in", "inputDirectory", true, "Add the specified directory to the file search path.").dir("out", "outputDirectory", false, "Use the specified directory for output.").word("enc-in", "inputEncoding", false, "Use the specified character encoding for input.").word("enc-out", "outputEncoding", false, "Use the specified character encoding for output.").bool("diagnostics", "optionDiagnostics", false, "Print diagnostics for internal tool state.").bool("performance", "optionPerformance", false, "Collect and print performance statistics.").bool("measureParser", "optionMeasureParser", false, "Measure parser performance only.").bool("measureProcess", "optionMeasureProcessing", false, "Measure processing performance only.").bool("gc", "optionGC", false, "Perform GC before each operation.").number("warmupRuns", "runsWarmUp", 2, "Perform the specified number of warm-up runs.  The default is 2.").number("totalRuns", "runsTotal", 12, "Perform the specified number of total runs.  The default is 12.");
    }

    public void prepare() {
        this.runtime.initDefaultValues();
        if (this.runtime.test("optionSilent") && this.runtime.test("optionVerbose")) {
            this.runtime.error("can't run in silent and verbose mode at the same time");
        }
        if (this.runtime.test("optionMeasureParser") && this.runtime.test("optionMeasureProcessing")) {
            this.runtime.error("can't measure just parsing and just processing at the same time");
        }
        if (this.runtime.test("optionMeasureParser") && !this.runtime.test("optionPerformance")) {
            this.runtime.setValue("optionPerformance", true);
        }
        if (this.runtime.test("optionMeasureProcessing") && !this.runtime.test("optionPerformance")) {
            this.runtime.setValue("optionPerformance", true);
        }
    }

    public void diagnose() {
    }

    public File locate(String name) throws IOException {
        File file = new File(name);
        if (!file.exists()) {
            throw new FileNotFoundException(name + ": not found");
        }
        return file;
    }

    public abstract Node parse(Reader var1, File var2) throws IOException, ParseException;

    public void process(Node node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String name) throws IOException, ParseException {
        Node root;
        File file = this.locate(name);
        Reader in = this.runtime.getReader(file);
        try {
            root = this.parse(in, file);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException x) {}
        }
        this.process(root);
    }

    public void printHeader(Printer printer) {
        printer.sep();
        printer.indent().pln("// This file has been generated by");
        printer.indent().p("// ").p(this.getName()).p(", version ").p(this.getVersion()).pln(',');
        printer.p("// ").p(this.getCopy()).pln(',');
        Date now = new Date();
        printer.indent().p("// on ").p(DateFormat.getDateInstance(0).format(now)).p(" at ").p(DateFormat.getTimeInstance(2).format(now)).pln('.');
        printer.indent().pln("// Edit at your own risk.");
        printer.sep();
        printer.pln();
    }

    public void wrapUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        Statistics heapSizes;
        boolean diagnose;
        this.init();
        if (0 == args.length) {
            this.runtime.console().p(this.getName()).p(", v. ").p(this.getVersion()).p(", ").pln(this.getCopy());
            this.runtime.console().pln().pln("Usage: <option>* <file-name>+").pln().pln("Options are:");
            this.runtime.printOptions();
            String explanation = this.getExplanation();
            if (null != explanation) {
                this.runtime.console().pln().wrap(0, explanation).pln();
            }
            this.runtime.console().pln().flush();
            if (this.runtime.hasValue("optionNoExit") && this.runtime.test("optionNoExit")) {
                return;
            }
            this.runtime.exit();
        }
        int index = this.runtime.process(args);
        if (!this.runtime.hasValue("optionSilent") || !this.runtime.test("optionSilent")) {
            this.runtime.console().p(this.getName()).p(", v. ").p(this.getVersion()).p(", ").pln(this.getCopy()).flush();
        }
        boolean bl = diagnose = this.runtime.hasValue("optionDiagnostics") && this.runtime.test("optionDiagnostics");
        if (index >= args.length && !diagnose) {
            this.runtime.error("no file names specified");
        }
        this.prepare();
        if (diagnose) {
            this.diagnose();
        }
        if (this.runtime.seenError()) {
            if (this.runtime.test("optionNoExit")) {
                return;
            }
            this.runtime.exit();
        }
        boolean silent = this.runtime.test("optionSilent");
        boolean doGC = this.runtime.test("optionGC");
        boolean measure = this.runtime.test("optionPerformance");
        boolean parserOnly = this.runtime.test("optionMeasureParser");
        boolean processOnly = this.runtime.test("optionMeasureProcessing");
        int warmUp = measure ? this.runtime.getInt("runsWarmUp") : 0;
        int total = measure ? this.runtime.getInt("runsTotal") : 1;
        Statistics time = measure ? new Statistics() : null;
        Statistics memory = measure ? new Statistics() : null;
        Statistics fileSizes = measure ? new Statistics() : null;
        Statistics latencies = measure ? new Statistics() : null;
        Statistics statistics = heapSizes = measure ? new Statistics() : null;
        if (measure) {
            this.runtime.console().p("Legend: file, size, time (ave, med, stdev), ").pln("memory (ave, med, stdev)").pln().flush();
        }
        while (index < args.length) {
            if (!silent && !measure) {
                this.runtime.console().p("Processing ").p(args[index]).pln(" ...").flush();
            }
            File file = null;
            try {
                file = this.locate(args[index]);
            }
            catch (IllegalArgumentException x) {
                this.runtime.error(x.getMessage());
            }
            catch (FileNotFoundException x) {
                this.runtime.error(x.getMessage());
            }
            catch (IOException x) {
                if (null == x.getMessage()) {
                    this.runtime.error(args[index] + ": I/O error");
                } else {
                    this.runtime.error(args[index] + ": " + x.getMessage());
                }
            }
            catch (Throwable x) {
                this.runtime.error();
                x.printStackTrace();
            }
            if (null != file) {
                if (measure) {
                    time.reset();
                    memory.reset();
                }
                for (int i = 0; i < total; ++i) {
                    Node ast = null;
                    boolean success = false;
                    if (doGC) {
                        System.gc();
                    }
                    long startTime = 0L;
                    long startMemory = 0L;
                    if (measure && !processOnly) {
                        startMemory = java.lang.Runtime.getRuntime().freeMemory();
                        startTime = System.currentTimeMillis();
                    }
                    Reader in = null;
                    try {
                        in = this.runtime.getReader(file);
                        ast = this.parse(in, file);
                        success = true;
                    }
                    catch (IllegalArgumentException x) {
                        this.runtime.error(x.getMessage());
                    }
                    catch (FileNotFoundException x) {
                        this.runtime.error(x.getMessage());
                    }
                    catch (UnsupportedEncodingException x) {
                        this.runtime.error(x.getMessage());
                    }
                    catch (IOException x) {
                        if (null == x.getMessage()) {
                            this.runtime.error(args[index] + ": I/O error");
                        } else {
                            this.runtime.error(args[index] + ": " + x.getMessage());
                        }
                    }
                    catch (ParseException x) {
                        this.runtime.error();
                        System.err.print(x.getMessage());
                    }
                    catch (Throwable x) {
                        this.runtime.error();
                        x.printStackTrace();
                    }
                    finally {
                        if (null != in) {
                            try {
                                in.close();
                            }
                            catch (IOException x) {}
                        }
                    }
                    if (success && null != ast && !parserOnly) {
                        if (measure && processOnly) {
                            startMemory = java.lang.Runtime.getRuntime().freeMemory();
                            startTime = System.currentTimeMillis();
                        }
                        try {
                            this.process(ast);
                        }
                        catch (VisitingException x) {
                            this.runtime.error();
                            x.getCause().printStackTrace();
                        }
                        catch (Throwable x) {
                            this.runtime.error();
                            x.printStackTrace();
                        }
                    }
                    if (!measure) continue;
                    long endTime = System.currentTimeMillis();
                    long endMemory = java.lang.Runtime.getRuntime().freeMemory();
                    if (i < warmUp) continue;
                    time.add(endTime - startTime);
                    memory.add(startMemory - endMemory);
                }
                if (measure) {
                    long fileSize = file.length();
                    double latency = time.mean();
                    double heapSize = memory.mean();
                    fileSizes.add((double)fileSize / 1024.0);
                    latencies.add(latency);
                    heapSizes.add(heapSize / 1024.0);
                    this.runtime.console().p(args[index]).p(' ').p(fileSize).p(' ').p(Statistics.round(latency)).p(' ').p(time.median()).p(' ').p(Statistics.round(time.stdev())).p(' ').p(Statistics.round(heapSize)).p(' ').p(memory.median()).p(' ').pln(Statistics.round(memory.stdev())).flush();
                }
            }
            ++index;
        }
        this.wrapUp();
        if (measure) {
            double totalTime = latencies.sum();
            double totalMemory = heapSizes.sum();
            double throughput = 1000.0 / Statistics.fitSlope(fileSizes, latencies);
            double heapUtil = Statistics.fitSlope(fileSizes, heapSizes);
            this.runtime.console().pln().p("Total time               : ").p(Statistics.round(totalTime)).pln(" ms").p("Total memory             : ").p(Statistics.round(totalMemory)).pln(" KB").p("Average throughput       : ").p(Statistics.round(throughput)).pln(" KB/s").p("Average heap utilization : ").p(Statistics.round(heapUtil)).pln(":1").flush();
        }
        if (!this.runtime.test("optionNoExit")) {
            this.runtime.exit();
        }
    }
}

