/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.util.EmptyIterator;
import xtc.util.Utilities;

public class SymbolTable {
    protected Scope root;
    protected Scope current;
    protected int freshNameCount;
    protected int freshIdCount;
    private static final String END_OPAQUE = Character.toString(')');

    public SymbolTable() {
        this("");
    }

    public SymbolTable(String root) {
        this.current = this.root = new Scope(root);
        this.freshNameCount = 0;
        this.freshIdCount = 0;
    }

    public void reset() {
        this.root.scopes = null;
        this.root.symbols = null;
        this.current = this.root;
        this.freshNameCount = 0;
        this.freshIdCount = 0;
    }

    public Scope root() {
        return this.root;
    }

    public Scope current() {
        return this.current;
    }

    public Scope getScope(String name) {
        Scope scope = this.current;
        if (name.startsWith(scope.qName) && name.lastIndexOf(46) == scope.qName.length()) {
            return scope.getNested(Utilities.getName(name));
        }
        String[] components = Utilities.toComponents(name);
        scope = this.root.name.equals(components[0]) ? this.root : null;
        for (int index = 1; null != scope && index < components.length; scope = scope.getNested(components[index]), ++index) {
        }
        return scope;
    }

    public void setScope(Scope scope) {
        Scope s = scope;
        while (null != s.parent) {
            s = s.parent;
        }
        if (s != this.root) {
            throw new IllegalArgumentException("Scope " + scope.qName + " not " + "in this symbol table " + this);
        }
        this.current = scope;
    }

    public boolean isDefined(String symbol) {
        Scope scope = this.lookupScope(symbol);
        if (null == scope || null == scope.symbols) {
            return false;
        }
        return scope.symbols.containsKey(Utilities.unqualify(symbol));
    }

    public boolean isDefinedMultiply(String symbol) {
        Scope scope = this.lookupScope(symbol);
        if (null == scope || null == scope.symbols) {
            return false;
        }
        return scope.symbols.get(Utilities.unqualify(symbol)) instanceof List;
    }

    public Scope lookupScope(String symbol) {
        if (Utilities.isQualified(symbol)) {
            return this.getScope(Utilities.getQualifier(symbol));
        }
        return this.current.lookupScope(symbol);
    }

    public Object lookup(String symbol) {
        Scope scope = this.lookupScope(symbol);
        if (null == scope || null == scope.symbols) {
            return null;
        }
        return scope.symbols.get(Utilities.unqualify(symbol));
    }

    public void enter(String name) {
        Scope parent = this.current;
        Scope child = parent.getNested(name);
        if (null == child) {
            child = new Scope(name, parent);
        }
        this.current = child;
    }

    public void exit() {
        if (null == this.current.parent) {
            throw new IllegalStateException("Unable to exit root scope");
        }
        this.current = this.current.parent;
    }

    public void delete(String name) {
        if (null != this.current.scopes) {
            this.current.scopes.remove(name);
        }
    }

    public static boolean hasScope(Node n) {
        return n.hasProperty("xtc.Constants.Scope");
    }

    public void mark(Node n) {
        if (!n.hasProperty("xtc.Constants.Scope")) {
            n.setProperty("xtc.Constants.Scope", this.current.getQualifiedName());
        }
    }

    public void enter(Node n) {
        if (n.hasProperty("xtc.Constants.Scope")) {
            String name = n.getStringProperty("xtc.Constants.Scope");
            Scope scope = this.getScope(name);
            if (null == scope) {
                throw new IllegalStateException("Invalid scope " + name);
            }
            if (scope.getParent() != this.current) {
                throw new IllegalStateException("Scope " + name + " not nested in " + this.current.getQualifiedName());
            }
            this.current = scope;
        }
    }

    public void exit(Node n) {
        if (n.hasProperty("xtc.Constants.Scope")) {
            this.exit();
        }
    }

    public String freshName() {
        return this.freshName("anonymous");
    }

    public String freshName(String base) {
        StringBuilder buf = new StringBuilder();
        buf.append(base);
        buf.append('(');
        buf.append(this.freshNameCount++);
        buf.append(')');
        return buf.toString();
    }

    public String freshCId() {
        return this.freshCId("tmp");
    }

    public String freshCId(String base) {
        StringBuilder buf = new StringBuilder();
        buf.append("__");
        buf.append(base);
        buf.append('_');
        buf.append(this.freshIdCount++);
        return buf.toString();
    }

    public String freshJavaId() {
        return this.freshJavaId("tmp");
    }

    public String freshJavaId(String base) {
        StringBuilder buf = new StringBuilder();
        buf.append(base);
        buf.append('$');
        buf.append(this.freshIdCount++);
        return buf.toString();
    }

    public static String toNameSpace(String symbol, String space) {
        return space + '(' + symbol + ')';
    }

    public static boolean isInNameSpace(String symbol, String space) {
        try {
            return symbol.startsWith(space) && '(' == symbol.charAt(space.length()) && symbol.endsWith(END_OPAQUE);
        }
        catch (IndexOutOfBoundsException x) {
            return false;
        }
    }

    public static String fromNameSpace(String symbol) {
        int start = symbol.indexOf(40);
        int end = symbol.length() - 1;
        if (0 < start && ')' == symbol.charAt(end)) {
            return symbol.substring(start + 1, end);
        }
        throw new IllegalArgumentException("Not a mangled symbol '" + symbol + "'");
    }

    public static String toMacroScopeName(String id) {
        return SymbolTable.toNameSpace(id, "macro");
    }

    public static boolean isMacroScopeName(String name) {
        return SymbolTable.isInNameSpace(name, "macro");
    }

    public static String toFunctionScopeName(String id) {
        return SymbolTable.toNameSpace(id, "function");
    }

    public static boolean isFunctionScopeName(String name) {
        return SymbolTable.isInNameSpace(name, "function");
    }

    public static String toTagName(String tag) {
        return SymbolTable.toNameSpace(tag, "tag");
    }

    public static String toLabelName(String id) {
        return SymbolTable.toNameSpace(id, "label");
    }

    public static String toMethodName(String id) {
        return SymbolTable.toNameSpace(id, "method");
    }

    public static class Scope {
        String name;
        String qName;
        Scope parent;
        Map<String, Scope> scopes;
        Map<String, Object> symbols;

        Scope(String name) {
            this.name = name;
            this.qName = name;
        }

        Scope(String name, Scope parent) {
            if (null != parent.scopes && parent.scopes.containsKey(name)) {
                throw new IllegalArgumentException("Scope " + parent.qName + " already contains scope " + name);
            }
            this.name = name;
            this.qName = Utilities.qualify(parent.qName, name);
            this.parent = parent;
            if (null == parent.scopes) {
                parent.scopes = new HashMap<String, Scope>();
            }
            parent.scopes.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.qName;
        }

        void requalify() {
            this.qName = Utilities.qualify(this.parent.qName, this.name);
            if (null != this.scopes) {
                for (Scope scope : this.scopes.values()) {
                    scope.requalify();
                }
            }
        }

        public boolean isRoot() {
            return null == this.parent;
        }

        public Scope getParent() {
            return this.parent;
        }

        public boolean hasNested() {
            return null != this.scopes && 0 < this.scopes.size();
        }

        public Iterator<String> nested() {
            if (null == this.scopes) {
                return EmptyIterator.value();
            }
            return this.scopes.keySet().iterator();
        }

        public boolean hasNested(String name) {
            return null != this.getNested(name);
        }

        public Scope getNested(String name) {
            return null == this.scopes ? null : this.scopes.get(name);
        }

        public boolean isMergeable(String name) {
            Scope nested = this.getNested(name);
            if (null == nested) {
                throw new IllegalArgumentException("Scope " + this.qName + " does not " + " contain scope " + name);
            }
            if (null != nested.scopes) {
                for (String s : nested.scopes.keySet()) {
                    if (s.equals(name) || !this.scopes.containsKey(s)) continue;
                    return false;
                }
            }
            if (null != this.symbols && null != nested.symbols) {
                for (String s : nested.symbols.keySet()) {
                    if (!this.symbols.containsKey(s)) continue;
                    return false;
                }
            }
            return true;
        }

        public void merge(String name) {
            Scope nested = this.getNested(name);
            if (!this.isMergeable(name)) {
                throw new IllegalArgumentException("Scope " + nested.qName + " cannot be merged into the parent");
            }
            this.scopes.remove(name);
            if (null != nested.scopes) {
                this.scopes.putAll(nested.scopes);
                for (Scope s : nested.scopes.values()) {
                    s.parent = this;
                    s.requalify();
                }
            }
            if (null != nested.symbols) {
                if (null == this.symbols) {
                    this.symbols = nested.symbols;
                } else {
                    this.symbols.putAll(nested.symbols);
                }
            }
            nested.parent = null;
            nested.name = null;
            nested.qName = null;
            nested.scopes = null;
            nested.symbols = null;
        }

        public boolean hasSymbols() {
            return null != this.symbols && 0 < this.symbols.size();
        }

        public Iterator<String> symbols() {
            if (null == this.symbols) {
                return EmptyIterator.value();
            }
            return this.symbols.keySet().iterator();
        }

        public boolean isDefinedLocally(String symbol) {
            return null == this.symbols ? false : this.symbols.containsKey(symbol);
        }

        public boolean isDefined(String symbol) {
            return null != this.lookupScope(symbol);
        }

        public boolean isDefinedMultiply(String symbol) {
            Scope scope = this.lookupScope(symbol);
            return null == scope ? false : scope.symbols.get(symbol) instanceof List;
        }

        public Scope lookupScope(String symbol) {
            Scope scope = this;
            do {
                if (null == scope.symbols || !scope.symbols.containsKey(symbol)) continue;
                return scope;
            } while (null != (scope = scope.parent));
            return null;
        }

        public Object lookup(String symbol) {
            Scope scope = this.lookupScope(symbol);
            return null == scope ? null : scope.symbols.get(symbol);
        }

        public Scope lookupBoundScope(String symbol) {
            Scope scope = this.lookupScope(symbol);
            return null == scope ? null : scope.getNested(symbol);
        }

        public Object lookupLocally(String symbol) {
            return null == this.symbols ? null : this.symbols.get(symbol);
        }

        public void define(String symbol, Object value) {
            if (null == this.symbols) {
                this.symbols = new HashMap<String, Object>();
            }
            this.symbols.put(symbol, value);
        }

        public void addDefinition(String symbol, Object value) {
            if (null == this.symbols) {
                this.symbols = new HashMap<String, Object>();
            }
            if (this.symbols.containsKey(symbol)) {
                Object o = this.symbols.get(symbol);
                if (o instanceof List) {
                    ((List)o).add(value);
                } else {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(o);
                    l.add(value);
                    this.symbols.put(symbol, l);
                }
            } else {
                this.symbols.put(symbol, value);
            }
        }

        public void undefine(String symbol) {
            if (null != this.symbols) {
                this.symbols.remove(symbol);
            }
        }

        public String qualify(String symbol) {
            return Utilities.qualify(this.qName, symbol);
        }

        public void dump(Printer printer) {
            boolean hasVisitor = null != printer.visitor();
            printer.indent().p('.').p(this.name).pln(" = {").incr();
            if (null != this.symbols) {
                for (Map.Entry<String, Object> entry : this.symbols.entrySet()) {
                    String symbol = entry.getKey();
                    Object value = entry.getValue();
                    printer.indent().p(symbol).p(" = ");
                    if (null == value) {
                        printer.p("null");
                    } else if (hasVisitor && value instanceof Node) {
                        printer.p((Node)value);
                    } else if (value instanceof String) {
                        printer.p('\"').escape((String)value, 8).p('\"');
                    } else {
                        try {
                            printer.p(value.toString());
                        }
                        catch (Exception e) {
                            printer.p(value.getClass().getName() + "@?");
                        }
                    }
                    printer.pln(';');
                    Scope nested = this.getNested(symbol);
                    if (null == nested) continue;
                    nested.dump(printer);
                }
            }
            if (null != this.scopes) {
                for (Scope nested : this.scopes.values()) {
                    if (null != this.symbols && this.symbols.containsKey(nested.name)) continue;
                    nested.dump(printer);
                }
            }
            printer.decr().indent().pln("};");
        }
    }
}

