/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Statistics {
    private List<Double> numbers = new ArrayList<Double>();

    public void reset() {
        this.numbers.clear();
    }

    public void add(double d) {
        this.numbers.add(d);
    }

    public int size() {
        return this.numbers.size();
    }

    public double get(int idx) {
        return this.numbers.get(idx);
    }

    public double sum() {
        double sum = 0.0;
        int size = this.numbers.size();
        for (int i = 0; i < size; ++i) {
            sum += this.numbers.get(i).doubleValue();
        }
        return sum;
    }

    public double mean() {
        double mean = 0.0;
        int size = this.numbers.size();
        for (int i = 0; i < size; ++i) {
            mean += (this.numbers.get(i) - mean) / (double)(i + 1);
        }
        return mean;
    }

    public double median() {
        if (0 == this.size()) {
            return 0.0;
        }
        ArrayList<Double> sorted = new ArrayList<Double>(this.numbers);
        Collections.sort(sorted);
        return (Double)sorted.get(this.size() / 2);
    }

    public double stdev() {
        double mean = this.mean();
        double variance = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double diff = this.numbers.get(i) - mean;
            variance += (diff * diff - variance) / (double)(i + 1);
        }
        return Math.sqrt(variance);
    }

    public static double round(double d) {
        return Math.floor(d * 100.0 + 0.5) / 100.0;
    }

    public static double fitSlope(Statistics x, Statistics y) {
        int i;
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Inconsistent collection sizes");
        }
        if (0 == x.size()) {
            throw new IllegalArgumentException("Empty collections");
        }
        double xMean = 0.0;
        double yMean = 0.0;
        double dx2Mean = 0.0;
        double dxdyMean = 0.0;
        int size = x.size();
        for (i = 0; i < size; ++i) {
            xMean += (x.get(i) - xMean) / (double)(i + 1);
            yMean += (y.get(i) - yMean) / (double)(i + 1);
        }
        for (i = 0; i < size; ++i) {
            double dx = x.get(i) - xMean;
            double dy = y.get(i) - yMean;
            dx2Mean += (dx * dx - dx2Mean) / (double)(i + 1);
            dxdyMean += (dx * dy - dxdyMean) / (double)(i + 1);
        }
        return (xMean * yMean + dxdyMean) / (xMean * xMean + dx2Mean);
    }
}

