/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xtc.parser.PParser;
import xtc.parser.ParseError;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.util.Option;

public class Runtime {
    public static final String INPUT_DIRECTORY = "inputDirectory";
    public static final String OUTPUT_DIRECTORY = "outputDirectory";
    public static final String INPUT_ENCODING = "inputEncoding";
    public static final String OUTPUT_ENCODING = "outputEncoding";
    protected Printer console = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
    protected Printer errConsole = new Printer(new BufferedWriter(new OutputStreamWriter(System.err)));
    protected final List<Option> optionList = new ArrayList<Option>();
    protected final Map<String, Option> externalMap = new HashMap<String, Option>();
    protected final Map<String, Option> internalMap = new HashMap<String, Option>();
    protected final Map<String, Object> options = new HashMap<String, Object>();
    protected int errors = 0;
    protected int warnings = 0;

    public Printer console() {
        return this.console;
    }

    public void setConsole(Printer console) {
        this.console = console;
    }

    public Printer errConsole() {
        return this.errConsole;
    }

    public void setErrConsole(Printer console) {
        this.errConsole = console;
    }

    public long freeMemory() {
        return java.lang.Runtime.getRuntime().freeMemory();
    }

    protected void check(String external, String internal) {
        if (this.externalMap.containsKey(external)) {
            throw new IllegalArgumentException("Option with external name " + external + " already exists");
        }
        if (this.internalMap.containsKey(internal)) {
            throw new IllegalArgumentException("Option with internal name " + internal + " already exists");
        }
    }

    protected void add(Option option) {
        this.optionList.add(option);
        this.externalMap.put(option.external, option);
        this.internalMap.put(option.internal, option);
    }

    public Runtime bool(String external, String internal, boolean value, String description) {
        this.check(external, internal);
        this.add(new Option(Option.Kind.BOOLEAN, external, internal, value, false, description));
        return this;
    }

    public Runtime word(String external, String internal, boolean multiple, String description) {
        this.check(external, internal);
        this.add(new Option(Option.Kind.WORD, external, internal, null, multiple, description));
        return this;
    }

    public Runtime number(String external, String internal, int value, String description) {
        this.check(external, internal);
        this.add(new Option(Option.Kind.INTEGER, external, internal, new Integer(value), false, description));
        return this;
    }

    public Runtime file(String external, String internal, boolean multiple, String description) {
        this.check(external, internal);
        this.add(new Option(Option.Kind.FILE, external, internal, null, multiple, description));
        return this;
    }

    public Runtime dir(String external, String internal, boolean multiple, String description) {
        this.check(external, internal);
        this.add(new Option(Option.Kind.DIRECTORY, external, internal, new File(System.getProperty("user.dir")), multiple, description));
        return this;
    }

    public Runtime att(String external, String internal, boolean multiple, String description) {
        this.check(external, internal);
        this.add(new Option(Option.Kind.ATTRIBUTE, external, internal, null, multiple, description));
        return this;
    }

    public void printOptions() {
        int alignment = 0;
        block13: for (Option option : this.optionList) {
            switch (option.kind) {
                case BOOLEAN: {
                    alignment = Math.max(alignment, option.external.length() + 5);
                    continue block13;
                }
                case WORD: 
                case FILE: {
                    alignment = Math.max(alignment, option.external.length() + 5 + 7);
                    continue block13;
                }
                case INTEGER: 
                case DIRECTORY: 
                case ATTRIBUTE: {
                    alignment = Math.max(alignment, option.external.length() + 5 + 6);
                    continue block13;
                }
            }
            assert (false) : "Invalid option " + option;
        }
        for (Option option : this.optionList) {
            this.console.p("  -").p(option.external);
            switch (option.kind) {
                case BOOLEAN: {
                    break;
                }
                case WORD: {
                    this.console.p(" <word>");
                    break;
                }
                case INTEGER: {
                    this.console.p(" <num>");
                    break;
                }
                case FILE: {
                    this.console.p(" <file>");
                    break;
                }
                case DIRECTORY: {
                    this.console.p(" <dir>");
                    break;
                }
                case ATTRIBUTE: {
                    this.console.p(" <att>");
                    break;
                }
                default: {
                    assert (false) : "Invalid option " + option;
                    break;
                }
            }
            this.console.align(alignment).wrap(alignment, option.description).pln();
        }
        this.console.flush();
    }

    public int process(String[] args) {
        int index;
        this.options.clear();
        for (index = 0; index < args.length && args[index].startsWith("-"); ++index) {
            if (1 >= args[index].length()) {
                this.error("empty command line option");
                continue;
            }
            String name = args[index].substring(1);
            Option option = this.externalMap.get(name);
            if (null == option) {
                this.error("unrecognized command line option " + name);
                continue;
            }
            if (!option.multiple && this.options.containsKey(option.internal)) {
                this.error("repeated " + name + " option");
                continue;
            }
            if (Option.Kind.BOOLEAN == option.kind) {
                this.options.put(option.internal, Boolean.TRUE);
                continue;
            }
            if (args.length == index + 1) {
                this.error(name + " option without argument");
                continue;
            }
            Object value = null;
            ++index;
            switch (option.kind) {
                case WORD: {
                    value = args[index];
                    break;
                }
                case INTEGER: {
                    try {
                        value = new Integer(args[index]);
                    }
                    catch (NumberFormatException x) {
                        this.error("malformed integer argument to " + name + " option");
                    }
                    break;
                }
                case FILE: {
                    File file = new File(args[index]);
                    if (file.exists()) {
                        value = file;
                        break;
                    }
                    this.error("nonexistent file argument to " + name + " option");
                    break;
                }
                case DIRECTORY: {
                    File dir = new File(args[index]);
                    if (dir.exists()) {
                        if (dir.isDirectory()) {
                            value = dir;
                            break;
                        }
                        this.error(args[index] + " not a directory");
                        break;
                    }
                    this.error("nonexistent directory argument to " + name + " option");
                    break;
                }
                case ATTRIBUTE: {
                    PParser parser = new PParser(new StringReader(args[index]), "<console>", args[index].length());
                    Result result = null;
                    try {
                        result = parser.pAttribute(0);
                    }
                    catch (IOException x) {
                        this.error("internal error: " + x);
                    }
                    if (!result.hasValue()) {
                        this.error("malformed attribute " + args[index] + ": " + ((ParseError)result).msg);
                        break;
                    }
                    if (result.index != args[index].length()) {
                        this.error("extra characters after " + args[index].substring(0, result.index));
                        break;
                    }
                    value = ((SemanticValue)result).value;
                    break;
                }
                default: {
                    assert (false) : "Unrecognized option " + option;
                    break;
                }
            }
            if (null == value) continue;
            if (option.multiple) {
                List<Object> values;
                if (this.options.containsKey(option.internal)) {
                    values = (List)this.options.get(option.internal);
                    values.add(value);
                    continue;
                }
                values = new ArrayList<Object>();
                values.add(value);
                this.options.put(option.internal, values);
                continue;
            }
            this.options.put(option.internal, value);
        }
        return index;
    }

    public void initDefaultValues() {
        for (Option option : this.optionList) {
            if (this.options.containsKey(option.internal)) continue;
            ArrayList value = null;
            if (null != option.value) {
                if (option.multiple) {
                    ArrayList<Object> list = new ArrayList<Object>(1);
                    list.add(option.value);
                    value = list;
                } else {
                    value = option.value;
                }
            } else if (option.multiple) {
                value = new ArrayList(0);
            }
            this.options.put(option.internal, value);
        }
    }

    public void initFlags(boolean value) {
        for (Option option : this.optionList) {
            if (Option.Kind.BOOLEAN != option.kind || this.options.containsKey(option.internal)) continue;
            this.options.put(option.internal, value);
        }
    }

    public void initFlags(String prefix, boolean value) {
        for (Option option : this.optionList) {
            if (Option.Kind.BOOLEAN != option.kind || !option.internal.startsWith(prefix) || this.options.containsKey(option.internal)) continue;
            this.options.put(option.internal, value);
        }
    }

    public boolean hasValue(String name) {
        return this.options.containsKey(name);
    }

    public boolean hasPrefixValue(String prefix) {
        for (String s : this.options.keySet()) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name);
        }
        throw new IllegalArgumentException("Undefined internal option " + name);
    }

    public boolean test(String name) {
        if (this.options.containsKey(name)) {
            return (Boolean)this.options.get(name);
        }
        throw new IllegalArgumentException("Undefined boolean option " + name);
    }

    public int getInt(String name) {
        if (this.options.containsKey(name)) {
            return (Integer)this.options.get(name);
        }
        throw new IllegalArgumentException("Undefined integer option " + name);
    }

    public String getString(String name) {
        if (this.options.containsKey(name)) {
            return (String)this.options.get(name);
        }
        throw new IllegalArgumentException("Undefined word option " + name);
    }

    public File getFile(String name) {
        if (this.options.containsKey(name)) {
            return (File)this.options.get(name);
        }
        throw new IllegalArgumentException("Undefined file/directory option " + name);
    }

    public List<?> getList(String name) {
        if (this.options.containsKey(name)) {
            return (List)this.options.get(name);
        }
        throw new IllegalArgumentException("Undefined option " + name + " with multiple values");
    }

    public List<Attribute> getAttributeList(String name) {
        List<Attribute> l = this.getList(name);
        if (0 < l.size()) {
            Attribute attribute = l.get(0);
        }
        return l;
    }

    public List<File> getFileList(String name) {
        List<File> l = this.getList(name);
        if (0 < l.size()) {
            File file = l.get(0);
        }
        return l;
    }

    protected void check(Option option, Object value) {
        switch (option.kind) {
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("Invalid value " + value + " for boolean option " + option.internal);
            }
            case WORD: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("Invalid value " + value + " for word option " + option.internal);
            }
            case INTEGER: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException("Invalid value " + value + " for number option " + option.internal);
            }
            case FILE: {
                if (value instanceof File && ((File)value).exists()) break;
                throw new IllegalArgumentException("Invalid value " + value + " for file option " + option.internal);
            }
            case DIRECTORY: {
                if (value instanceof File && ((File)value).isDirectory()) break;
                throw new IllegalArgumentException("Invalid value " + value + " for directory option " + option.internal);
            }
            case ATTRIBUTE: {
                if (value instanceof Attribute) break;
                throw new IllegalArgumentException("Invalid value " + value + " for attribute option " + option.internal);
            }
            default: {
                assert (false) : "Invalid option " + option;
                break;
            }
        }
    }

    public void setValue(String name, Object value) {
        Option option = this.internalMap.get(name);
        if (null == option) {
            throw new IllegalArgumentException("Undefined option " + name);
        }
        this.check(option, value);
        if (option.multiple) {
            ArrayList list = new ArrayList(1);
            list.add(value);
            value = list;
        }
        this.options.put(name, value);
    }

    public void setValue(String name, boolean value) {
        Option option = this.internalMap.get(name);
        if (null == option) {
            throw new IllegalArgumentException("Undefined option " + name);
        }
        if (Option.Kind.BOOLEAN != option.kind) {
            throw new IllegalArgumentException("Not a boolean-valued option " + name);
        }
        this.options.put(name, value);
    }

    public File locate(String path) throws FileNotFoundException {
        List<File> roots = this.getFileList(INPUT_DIRECTORY);
        if (null != roots) {
            for (File root : roots) {
                File file = new File(root, path);
                if (!file.exists() || !file.isFile()) continue;
                return file;
            }
        }
        throw new FileNotFoundException(path + " not found");
    }

    public Reader getReader(File file) throws IOException {
        return this.getReader(new FileInputStream(file));
    }

    public Reader getReader(InputStream in) throws UnsupportedEncodingException {
        String encoding = (String)this.options.get(INPUT_ENCODING);
        if (null == encoding) {
            return new BufferedReader(new InputStreamReader(in));
        }
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public File getOutputDirectory() {
        return this.getFile(OUTPUT_DIRECTORY);
    }

    public Writer getWriter(File file) throws IOException {
        return this.getWriter(new FileOutputStream(file));
    }

    public Writer getWriter(OutputStream in) throws UnsupportedEncodingException {
        String encoding = (String)this.options.get(OUTPUT_ENCODING);
        if (null == encoding) {
            return new BufferedWriter(new OutputStreamWriter(in));
        }
        return new BufferedWriter(new OutputStreamWriter(in, encoding));
    }

    public boolean seenError() {
        return 0 < this.errors;
    }

    public int errorCount() {
        return this.errors;
    }

    public void error() {
        ++this.errors;
    }

    public void error(String msg) {
        this.errConsole.p("error: ").pln(msg).flush();
        ++this.errors;
    }

    public void error(String msg, Node n) {
        this.errConsole.loc(n).p(": ");
        this.error(msg);
    }

    public void warning() {
        ++this.warnings;
    }

    public void warning(String msg) {
        this.errConsole.p("warning: ").pln(msg).flush();
        ++this.warnings;
    }

    public void warning(String msg, Node n) {
        this.errConsole.loc(n).p(": ");
        this.warning(msg);
    }

    public void exit() {
        if (0 < this.errors) {
            if (1 == this.errors) {
                this.errConsole.p("1 error");
            } else {
                this.errConsole.p(this.errors);
                this.errConsole.p(" errors");
            }
        }
        if (0 < this.warnings) {
            if (0 < this.errors) {
                this.errConsole.p(", ");
            }
            if (1 == this.warnings) {
                this.errConsole.p("1 warning");
            } else {
                this.errConsole.p(this.warnings);
                this.errConsole.p(" warnings");
            }
        }
        if (0 < this.errors || 0 < this.warnings) {
            this.errConsole.pln().flush();
        }
        if (0 < this.errors) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

