/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EventListener;
import java.util.LinkedList;

public class NestedReader
extends Reader {
    protected boolean closed = false;
    protected Reader reader;
    protected EOFListener listener;
    protected LinkedList<Reader> readerStack;
    protected LinkedList<EOFListener> listenerStack;

    public NestedReader(Reader in) {
        this.reader = in;
        this.listener = null;
        this.readerStack = new LinkedList();
        this.listenerStack = new LinkedList();
    }

    public Reader open(String file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    public void insert(Reader in) throws IOException {
        this.insert(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Reader in, EOFListener eof) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Nested reader closed");
            }
            this.readerStack.addFirst(this.reader);
            this.listenerStack.addFirst(this.listener);
            this.reader = in;
            this.listener = eof;
        }
    }

    private void restore() throws IOException {
        if (null != this.listener) {
            this.listener.consumed();
        }
        this.reader.close();
        this.reader = this.readerStack.removeFirst();
        this.listener = this.listenerStack.removeFirst();
    }

    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int result;
                if (-1 != (result = this.reader.read()) || this.readerStack.isEmpty()) {
                    return result;
                }
                this.restore();
            }
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int result;
                if (-1 != (result = this.reader.read(cbuf, off, len)) || this.readerStack.isEmpty()) {
                    return result;
                }
                this.restore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            IOException error = null;
            try {
                this.reader.close();
            }
            catch (IOException x) {
                error = x;
            }
            while (!this.readerStack.isEmpty()) {
                this.reader = this.readerStack.removeFirst();
                try {
                    this.reader.close();
                }
                catch (IOException x) {
                    error = x;
                }
                this.listenerStack.removeFirst();
            }
            if (null != error) {
                throw error;
            }
        }
    }

    public static interface EOFListener
    extends EventListener {
        public void consumed();
    }
}

