/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import xtc.type.DerivedT;
import xtc.type.ErrorT;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.util.Utilities;

public class VariantT
extends DerivedT {
    private final String qname;
    private final String qualifier;
    private final String sname;
    private final boolean polymorphic;
    private List<TupleT> tuples;

    public VariantT(String name) {
        this(null, name, false, null);
    }

    public VariantT(String name, List<TupleT> tuples) {
        this(null, name, false, tuples);
    }

    public VariantT(String name, boolean polymorphic, List<TupleT> tuples) {
        this(null, name, polymorphic, tuples);
    }

    public VariantT(Type template, String name, boolean polymorphic, List<TupleT> tuples) {
        super(template);
        this.qname = name;
        this.qualifier = null == name ? null : Utilities.getQualifier(name);
        this.sname = null == name ? null : Utilities.unqualify(name);
        this.polymorphic = polymorphic;
        this.tuples = tuples;
        if (null == name && !polymorphic) {
            throw new NullPointerException("Null name");
        }
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.tuples = Type.seal(this.tuples);
        }
        return this;
    }

    @Override
    public VariantT copy() {
        return new VariantT(this, this.qname, this.polymorphic, VariantT.copy(this.tuples));
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.VARIANT;
    }

    @Override
    public boolean isVariant() {
        return true;
    }

    @Override
    public VariantT toVariant() {
        return this;
    }

    @Override
    public String getName() {
        return this.qname;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getSimpleName() {
        return this.sname;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public Type lookup(String name) {
        for (TupleT tuple : this.tuples) {
            if (!tuple.hasName(name)) continue;
            return tuple;
        }
        return ErrorT.TYPE;
    }

    public Type lookupSimple(String name) {
        for (TupleT tuple : this.tuples) {
            if (!tuple.hasSimpleName(name)) continue;
            return tuple;
        }
        return ErrorT.TYPE;
    }

    public List<TupleT> getTuples() {
        return this.tuples;
    }

    public void setTuples(List<TupleT> tuples) {
        this.checkNotSealed();
        this.tuples = tuples;
    }

    public int hashCode() {
        if (this.polymorphic) {
            return null == this.tuples ? 0 : this.tuples.hashCode();
        }
        return this.qname.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = VariantT.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isVariant()) {
            return false;
        }
        VariantT other = t.toVariant();
        if (this.polymorphic != other.polymorphic) {
            return false;
        }
        if (!this.polymorphic) {
            return this.qname.equals(other.qname);
        }
        if (null == this.tuples) {
            return null == other.tuples;
        }
        if (this.tuples.size() != other.tuples.size()) {
            return false;
        }
        for (TupleT tuple : this.tuples) {
            if (other.tuples.contains(tuple)) continue;
            return false;
        }
        for (TupleT tuple : other.tuples) {
            if (this.tuples.contains(tuple)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (null != this.qname) {
            out.append("variant ");
            out.append(this.qname);
        } else {
            out.append("variant(");
            Iterator<TupleT> iter = this.tuples.iterator();
            while (iter.hasNext()) {
                out.append('`');
                iter.next().write(out);
                if (!iter.hasNext()) continue;
                out.append(", ");
            }
            out.append(')');
        }
    }
}

