/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Type;
import xtc.type.WrappedT;

public class VariableT
extends WrappedT {
    private Kind kind;
    private String name;
    private int width;

    public VariableT(Type template, Type type, Kind kind, String name) {
        super(template, type);
        if (Kind.BITFIELD == kind) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        this.kind = kind;
        this.name = name;
        this.width = -1;
    }

    public VariableT(Type template, Type type, String name, int width) {
        super(template, type);
        if (0 > width) {
            throw new IllegalArgumentException("Negative width " + width);
        }
        this.kind = Kind.BITFIELD;
        this.name = name;
        this.width = width;
    }

    @Override
    public VariableT copy() {
        return -1 == this.width ? new VariableT((Type)this, this.getType().copy(), this.kind, this.name) : new VariableT((Type)this, this.getType().copy(), this.name, this.width);
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.VARIABLE;
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    @Override
    public boolean hasVariable() {
        return true;
    }

    @Override
    public VariableT toVariable() {
        return this;
    }

    public boolean hasKind(Kind kind) {
        return kind == this.kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean hasName() {
        return null != this.name;
    }

    @Override
    public boolean hasName(String name) {
        return name.equals(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean hasWidth() {
        return -1 != this.width;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void write(Appendable out) throws IOException {
        switch (this.kind) {
            case GLOBAL: {
                out.append("global");
                break;
            }
            case LOCAL: {
                out.append("local");
                break;
            }
            case PARAMETER: {
                out.append("param");
                break;
            }
            case FIELD: {
                out.append("field");
                break;
            }
            case BITFIELD: {
                out.append("bitfield");
            }
        }
        out.append('(');
        this.getType().write(out);
        out.append(", ");
        if (null != this.name) {
            out.append(this.name);
        } else {
            out.append("<none>");
        }
        if (-1 != this.width) {
            out.append(", ");
            out.append(Integer.toString(this.width));
        }
        out.append(')');
    }

    public static VariableT newGlobal(Type type, String name) {
        return new VariableT(null, type, Kind.GLOBAL, name);
    }

    public static VariableT newLocal(Type type, String name) {
        return new VariableT(null, type, Kind.LOCAL, name);
    }

    public static VariableT newParam(Type type, String name) {
        return new VariableT(null, type, Kind.PARAMETER, name);
    }

    public static VariableT newField(Type type, String name) {
        return new VariableT(null, type, Kind.FIELD, name);
    }

    public static VariableT newBitfield(Type type, String name, int width) {
        return new VariableT(null, type, name, width);
    }

    public static enum Kind {
        GLOBAL,
        LOCAL,
        PARAMETER,
        FIELD,
        BITFIELD;

    }
}

