/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.tree.Attribute;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.ClassT;
import xtc.type.EnumT;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.FunctionOrMethodT;
import xtc.type.FunctionT;
import xtc.type.InstantiatedT;
import xtc.type.InterfaceT;
import xtc.type.InternalT;
import xtc.type.LabelT;
import xtc.type.MethodT;
import xtc.type.NumberT;
import xtc.type.PackageT;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.PointerT;
import xtc.type.StructT;
import xtc.type.Tagged;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.UnionT;
import xtc.type.UnitT;
import xtc.type.VariableT;
import xtc.type.VariantT;
import xtc.type.VoidT;

public class TypePrinter
extends Visitor {
    protected final Printer printer;
    protected final Map<Object, Object> visited;
    protected boolean isInstantiated;

    public TypePrinter(Printer printer) {
        this.printer = printer;
        this.visited = new IdentityHashMap<Object, Object>();
        this.isInstantiated = false;
        printer.register(this);
    }

    public void reset() {
        this.visited.clear();
    }

    public boolean printAnnotations(Type t) {
        boolean printed = false;
        if (t.hasLocation(false)) {
            this.printer.p("line(").p(t.getLocation((boolean)false).line).p(") ");
            printed = true;
        }
        if (t.hasLanguage(false)) {
            this.printer.p("language(").p(t.getLanguage(false).toString()).p(") ");
            printed = true;
        }
        if (t.hasScope(false)) {
            this.printer.p("scope(").p(t.getScope(false)).p(") ");
            printed = true;
        }
        if (t.hasConstant(false)) {
            this.printer.p("value(").p(t.getConstant(false).getValue().toString()).p(") ");
            printed = true;
        }
        if (t.hasShape(false)) {
            this.printer.p("shape(").p(t.getShape().toString()).p(") ");
            printed = true;
        }
        if (t.hasAttributes()) {
            for (Attribute att : t.attributes()) {
                this.printer.p(att).p(' ');
                printed = true;
            }
        }
        return printed;
    }

    public void visit(BooleanT t) {
        this.printAnnotations(t);
        this.printer.p("boolean");
    }

    public void visit(ErrorT t) {
        this.printAnnotations(t);
        this.printer.p("** error **");
    }

    public void visit(InternalT t) {
        this.printAnnotations(t);
        this.printer.p(t.getName());
    }

    public void visit(LabelT t) {
        this.printAnnotations(t);
        this.printer.p("label(").p(t.getName()).p(')');
    }

    public void visit(NumberT t) {
        this.printAnnotations(t);
        this.printer.p(t.toString());
    }

    public void visit(PackageT t) {
        this.printAnnotations(t);
        this.printer.p("package(").p(t.getName()).p(')');
    }

    public void visit(Parameter t) {
        this.printAnnotations(t);
        this.printer.p('<').p(t.getName()).p('>');
    }

    public void visit(UnitT t) {
        this.printAnnotations(t);
        this.printer.p(t.getName());
    }

    public void visit(VoidT t) {
        this.printAnnotations(t);
        this.printer.p("void");
    }

    public void visit(ArrayT t) {
        this.printAnnotations(t);
        this.printer.p("array(").p(t.getType());
        if (t.isVarLength()) {
            this.printer.p(", *");
        } else if (t.hasLength()) {
            this.printer.p(", ").p(t.getLength());
        }
        this.printer.p(')');
    }

    public void printBody(ClassOrInterfaceT t) {
        if (!t.getInterfaces().isEmpty()) {
            Iterator<Type> iter = t.getInterfaces().iterator();
            while (iter.hasNext()) {
                Type type = iter.next();
                if (type.isAlias() && null == type.toAlias().getType()) {
                    this.printer.p(type);
                } else {
                    this.printer.p(((InterfaceT)type.resolve()).getQName());
                }
                if (!iter.hasNext()) continue;
                this.printer.p(", ");
            }
        }
        if (this.visited.containsKey(t)) {
            return;
        }
        this.visited.put(t, Boolean.TRUE);
        if (t.getFields().isEmpty() && t.getMethods().isEmpty()) {
            this.printer.p(" {}");
        } else {
            this.printer.pln(" {").incr();
            for (Type field : t.getFields()) {
                this.printer.indent().p(field).pln(';');
            }
            for (Type method : t.getMethods()) {
                this.printer.indent().p(method).pln(';');
            }
            this.printer.decr().indent().p('}');
        }
    }

    public void visit(ClassT t) {
        this.printer.p("class ").p(t.getQName());
        if (null != t.getParent()) {
            Type type = t.getParent();
            this.printer.p(" extends ");
            if (type.isAlias() && null == type.toAlias().getType()) {
                this.printer.p(type);
            } else {
                this.printer.p(((ClassT)type.resolve()).getQName());
            }
        }
        if (!t.getInterfaces().isEmpty()) {
            this.printer.p(" implements ");
        }
        this.printBody(t);
    }

    public void visit(InterfaceT t) {
        this.printer.p("interface ").p(t.getQName());
        if (!t.getInterfaces().isEmpty()) {
            this.printer.p(" extends ");
        }
        this.printBody(t);
    }

    public void printSignature(FunctionOrMethodT t) {
        this.printer.p('(');
        Iterator<Type> iter = t.getParameters().iterator();
        while (iter.hasNext()) {
            this.printer.p(iter.next());
            if (!iter.hasNext() && !t.isVarArgs()) continue;
            this.printer.p(", ");
        }
        if (t.isVarArgs()) {
            this.printer.p("...");
        }
        this.printer.p(") -> ");
        if (t.getResult().resolve().isFunction()) {
            this.printer.p('(').p(t.getResult()).p(')');
        } else {
            this.printer.p(t.getResult());
        }
        if (null != t.getExceptions() && !t.getExceptions().isEmpty()) {
            this.printer.p(" throws ");
            iter = t.getExceptions().iterator();
            while (iter.hasNext()) {
                this.printer.p(iter.next());
                if (!iter.hasNext()) continue;
                this.printer.p(", ");
            }
        }
    }

    public void visit(FunctionT t) {
        this.printAnnotations(t);
        this.printSignature(t);
    }

    public void visit(MethodT t) {
        this.printAnnotations(t);
        this.printer.p(t.getName()).p(' ');
        this.printSignature(t);
    }

    public void visit(PointerT t) {
        this.printAnnotations(t);
        this.printer.p("pointer(").p(t.getType()).p(')');
    }

    public void printTagged(String kind, Tagged tag) {
        this.printer.p(kind).p(' ').p(tag.getName());
        if (null != tag.getMembers() && !this.visited.containsKey(tag)) {
            this.visited.put(tag, Boolean.TRUE);
            if (tag.getMembers().isEmpty()) {
                this.printer.p(" {}");
            } else {
                this.printer.pln(" {").incr();
                Iterator<? extends Type> iter = tag.getMembers().iterator();
                while (iter.hasNext()) {
                    this.printer.indent().p(iter.next());
                    if ("enum".equals(kind)) {
                        if (iter.hasNext()) {
                            this.printer.pln(',');
                            continue;
                        }
                        this.printer.pln();
                        continue;
                    }
                    this.printer.pln(';');
                }
                this.printer.decr().indent().p('}');
            }
        }
    }

    public void visit(StructT t) {
        this.printAnnotations(t);
        this.printTagged("struct", t);
    }

    public void visit(UnionT t) {
        this.printAnnotations(t);
        this.printTagged("union", t);
    }

    public void visit(TupleT t) {
        this.printAnnotations(t);
        if (null == t.getName()) {
            this.printer.p("<anon>");
        } else {
            this.printer.p(t.getName());
        }
        this.printer.p('(');
        if (null == t.getTypes()) {
            this.printer.p("...");
        } else {
            Iterator<Type> iter = t.getTypes().iterator();
            while (iter.hasNext()) {
                this.printer.p(iter.next());
                if (!iter.hasNext()) continue;
                this.printer.p(", ");
            }
        }
        this.printer.p(')');
    }

    public void visit(VariantT t) {
        this.printAnnotations(t);
        if (t.isPolymorphic()) {
            this.printer.p("polymorphic-");
        }
        this.printer.p("variant ");
        if (null == t.getName()) {
            this.printer.p("<anonymous>");
        } else {
            this.printer.p(t.getName());
        }
        if (this.visited.containsKey(t)) {
            return;
        }
        this.visited.put(t, Boolean.TRUE);
        if (null == t.getTuples()) {
            this.printer.p(" { ... }");
        } else {
            this.printer.pln(" {").incr();
            for (Type type : t.getTuples()) {
                this.printer.indent().p(type).pln(';');
            }
            this.printer.decr().indent().p('}');
        }
    }

    public void visit(AliasT t) {
        this.printAnnotations(t);
        this.printer.p("alias(").p(t.getName());
        if (null != t.getType()) {
            this.printer.p(", ").p(t.getType());
        }
        this.printer.p(')');
    }

    public void visit(AnnotatedT t) {
        this.printAnnotations(t);
        this.printer.p(t.getType());
    }

    public void visit(EnumeratorT t) {
        this.printAnnotations(t);
        this.printer.p("enumerator(").p(t.getType()).p(' ').p(t.getName()).p(')');
    }

    public void visit(EnumT t) {
        this.printAnnotations(t);
        this.printTagged("enum", t);
    }

    public void visit(InstantiatedT t) {
        this.printAnnotations(t);
        Iterator<Parameter> params = t.toParameterized().getParameters().iterator();
        Iterator<Type> args = t.getArguments().iterator();
        this.printer.p('<');
        while (params.hasNext()) {
            this.printer.p(params.next()).p(" = ").p(args.next());
            if (!params.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p('>');
        this.isInstantiated = true;
        this.printer.p(t.getType());
    }

    public void visit(ParameterizedT t) {
        this.printAnnotations(t);
        if (this.isInstantiated) {
            this.isInstantiated = false;
        } else {
            this.printer.p('<');
            Iterator<Parameter> iter = t.getParameters().iterator();
            while (iter.hasNext()) {
                this.printer.p(iter.next());
                if (!iter.hasNext()) continue;
                this.printer.p(", ");
            }
            this.printer.p("> ");
        }
        this.printer.p(t.getType());
    }

    public void visit(VariableT t) {
        this.printAnnotations(t);
        switch (t.getKind()) {
            case GLOBAL: {
                this.printer.p("global");
                break;
            }
            case LOCAL: {
                this.printer.p("local");
                break;
            }
            case PARAMETER: {
                this.printer.p("param");
                break;
            }
            case FIELD: {
                this.printer.p("field");
                break;
            }
            case BITFIELD: {
                this.printer.p("bitfield");
            }
        }
        this.printer.p('(').p(t.getType()).p(", ");
        if (t.hasName()) {
            this.printer.p(t.getName());
        } else {
            this.printer.p("<anon>");
        }
        if (t.hasWidth()) {
            this.printer.p(", ").p(t.getWidth());
        }
        this.printer.p(')');
    }
}

