/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import xtc.tree.Attribute;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.ClassT;
import xtc.type.Constant;
import xtc.type.DynamicReference;
import xtc.type.EnumT;
import xtc.type.EnumeratorT;
import xtc.type.FloatT;
import xtc.type.FunctionT;
import xtc.type.InstantiatedT;
import xtc.type.IntegerT;
import xtc.type.InterfaceT;
import xtc.type.InternalParameter;
import xtc.type.InternalT;
import xtc.type.LabelT;
import xtc.type.Language;
import xtc.type.MethodT;
import xtc.type.NamedParameter;
import xtc.type.NumberT;
import xtc.type.PackageT;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.PointerT;
import xtc.type.Reference;
import xtc.type.StaticReference;
import xtc.type.StructOrUnionT;
import xtc.type.StructT;
import xtc.type.Tagged;
import xtc.type.TupleT;
import xtc.type.TypePrinter;
import xtc.type.UnionT;
import xtc.type.UnitT;
import xtc.type.VariableT;
import xtc.type.VariantT;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.type.WrappedT;
import xtc.util.Runtime;

public abstract class Type
extends Node {
    boolean sealed;
    Language language;
    String scope;
    Constant constant;
    Reference shape;
    List<Attribute> attributes;

    public Type() {
    }

    public Type(Type template) {
        if (null == template) {
            return;
        }
        this.setLocation(template);
        this.language = template.language;
        this.scope = template.scope;
        this.constant = template.constant;
        this.shape = template.shape;
        if (null != template.attributes) {
            this.attributes = new ArrayList<Attribute>(template.attributes);
        }
    }

    public abstract Type copy();

    public boolean isSealed() {
        return this.sealed;
    }

    public Type seal() {
        this.sealed = true;
        return this;
    }

    protected void checkNotSealed() {
        if (this.sealed) {
            throw new IllegalStateException("Type " + this + " is sealed");
        }
    }

    public Type annotate() {
        return this.isAnnotated() && !this.isSealed() ? this : new AnnotatedT(this);
    }

    public Type deannotate() {
        Type t = this;
        while (t.isAnnotated()) {
            t = t.toAnnotated().getType();
        }
        return t;
    }

    @Override
    public Object setProperty(String name, Object value) {
        this.checkNotSealed();
        return super.setProperty(name, value);
    }

    @Override
    public Object removeProperty(String name) {
        this.checkNotSealed();
        return super.removeProperty(name);
    }

    @Override
    public Set<String> properties() {
        if (this.sealed) {
            return Collections.unmodifiableSet(super.properties());
        }
        return this.properties();
    }

    @Override
    public boolean hasLocation() {
        return this.hasLocation(true);
    }

    public boolean hasLocation(boolean forward) {
        return super.hasLocation();
    }

    @Override
    public Location getLocation() {
        return this.getLocation(true);
    }

    public Location getLocation(boolean forward) {
        return super.getLocation();
    }

    public Type locate(Location location) {
        this.setLocation(location);
        return this;
    }

    public Type locate(Locatable locatable) {
        this.setLocation(locatable);
        return this;
    }

    @Override
    public void setLocation(Location location) {
        this.checkNotSealed();
        super.setLocation(location);
    }

    @Override
    public void setLocation(Locatable locatable) {
        this.checkNotSealed();
        super.setLocation(locatable);
    }

    public boolean hasLanguage() {
        return this.hasLanguage(true);
    }

    public boolean hasLanguage(boolean forward) {
        return null != this.language;
    }

    public Language getLanguage() {
        return this.getLanguage(true);
    }

    public Language getLanguage(boolean forward) {
        return this.language;
    }

    public Type language(Language language) {
        this.checkNotSealed();
        this.language = language;
        return this;
    }

    public boolean hasScope() {
        return this.hasScope(true);
    }

    public boolean hasScope(boolean forward) {
        return null != this.scope;
    }

    public String getScope() {
        return this.getScope(true);
    }

    public String getScope(boolean forward) {
        return this.scope;
    }

    public Type scope(String scope) {
        this.checkNotSealed();
        this.scope = scope;
        return this;
    }

    public boolean hasConstant() {
        return this.hasConstant(true);
    }

    public boolean hasConstant(boolean forward) {
        return null != this.constant;
    }

    public Constant getConstant() {
        return this.getConstant(true);
    }

    public Constant getConstant(boolean forward) {
        return this.constant;
    }

    public Type constant(boolean value) {
        return this.constant(value ? BigInteger.ONE : BigInteger.ZERO);
    }

    public Type constant(Object value) {
        this.checkNotSealed();
        this.constant = new Constant(value);
        return this;
    }

    public boolean hasShape() {
        return this.hasShape(true);
    }

    public boolean hasShape(boolean forward) {
        return null != this.shape;
    }

    public Reference getShape() {
        return this.getShape(true);
    }

    public Reference getShape(boolean forward) {
        return this.shape;
    }

    public Type shape(boolean isStatic, String name) {
        if (isStatic) {
            return this.shape(new StaticReference(name, this.resolve()));
        }
        return this.shape(new DynamicReference(name, this.resolve()));
    }

    public Type shape(Reference shape) {
        this.checkNotSealed();
        this.shape = shape;
        return this;
    }

    public boolean hasAttributes() {
        return null != this.attributes && !this.attributes.isEmpty();
    }

    public List<Attribute> attributes() {
        if (null == this.attributes) {
            return Collections.emptyList();
        }
        if (this.sealed) {
            return Collections.unmodifiableList(this.attributes);
        }
        return this.attributes;
    }

    public boolean hasAttribute(Attribute att) {
        return this.hasAttribute(att, true);
    }

    public boolean hasAttribute(Attribute att, boolean forward) {
        return null != this.attributes && this.attributes.contains(att);
    }

    public boolean hasAttribute(String name) {
        return null != this.getAttribute(name);
    }

    public boolean hasAttribute(String name, boolean forward) {
        return null != this.getAttribute(name, forward);
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(name, true);
    }

    public Attribute getAttribute(String name, boolean forward) {
        return Attribute.get(name, this.attributes);
    }

    public void addAttribute(Attribute att) {
        this.checkNotSealed();
        if (null == this.attributes) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(att);
    }

    public boolean removeAttribute(Attribute att) {
        this.checkNotSealed();
        return null != this.attributes ? this.attributes.remove(att) : false;
    }

    public Type attribute(Attribute att) {
        if (!this.hasAttribute(att)) {
            this.addAttribute(att);
        }
        return this;
    }

    public Type attribute(List<Attribute> attributes) {
        for (Attribute att : attributes) {
            if (this.hasAttribute(att)) continue;
            this.addAttribute(att);
        }
        return this;
    }

    public Type attribute(Type template) {
        do {
            if (!template.hasAttributes()) continue;
            for (Attribute att : template.attributes()) {
                if (this.hasAttribute(att)) continue;
                this.addAttribute(att);
            }
        } while (null != (template = template.isWrapped() ? template.toWrapped().getType() : null));
        return this;
    }

    public void mark(Node node) {
        if (node.hasProperty("xtc.Constants.Type")) {
            throw new IllegalArgumentException("Node " + node + " already has type");
        }
        node.setProperty("xtc.Constants.Type", this);
    }

    public boolean hasTag(Tag tag) {
        return tag == this.tag();
    }

    public abstract Tag tag();

    public boolean hasWTag(Tag tag) {
        return tag == this.wtag();
    }

    public Tag wtag() {
        return this.tag();
    }

    public boolean isError() {
        return false;
    }

    public boolean hasError() {
        return Tag.ERROR == this.tag();
    }

    public boolean isParameter() {
        return false;
    }

    public Parameter toParameter() {
        throw new ClassCastException("Not a parameter " + this);
    }

    public boolean isNamedParameter() {
        return false;
    }

    public NamedParameter toNamedParameter() {
        throw new ClassCastException("Not a named parameter " + this);
    }

    public boolean isInternalParameter() {
        return false;
    }

    public InternalParameter toInternalParameter() {
        throw new ClassCastException("Not an internal parameter " + this);
    }

    public boolean isWildcard() {
        return false;
    }

    public Wildcard toWildcard() {
        throw new ClassCastException("Not a wildcard " + this);
    }

    public boolean isVoid() {
        return false;
    }

    public VoidT toVoid() {
        throw new ClassCastException("Not a void " + this);
    }

    public boolean isUnit() {
        return false;
    }

    public UnitT toUnit() {
        throw new ClassCastException("Not a unit " + this);
    }

    public boolean isBoolean() {
        return false;
    }

    public BooleanT toBoolean() {
        throw new ClassCastException("Not a boolean " + this);
    }

    public boolean isNumber() {
        return false;
    }

    public NumberT toNumber() {
        throw new ClassCastException("Not a number " + this);
    }

    public boolean isInteger() {
        return false;
    }

    public IntegerT toInteger() {
        throw new ClassCastException("Not an integer " + this);
    }

    public boolean isFloat() {
        return false;
    }

    public FloatT toFloat() {
        throw new ClassCastException("Not a float " + this);
    }

    public boolean isInternal() {
        return false;
    }

    public InternalT toInternal() {
        throw new ClassCastException("Not an internal type " + this);
    }

    public boolean isLabel() {
        return false;
    }

    public LabelT toLabel() {
        throw new ClassCastException("Not a label " + this);
    }

    public boolean isPackage() {
        return false;
    }

    public PackageT toPackage() {
        throw new ClassCastException("Not a package " + this);
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public PointerT toPointer() {
        throw new ClassCastException("Not a pointer " + this);
    }

    public boolean isArray() {
        return false;
    }

    public ArrayT toArray() {
        throw new ClassCastException("Not an array " + this);
    }

    public boolean hasStructOrUnion() {
        switch (this.tag()) {
            case STRUCT: 
            case UNION: {
                return true;
            }
        }
        return false;
    }

    public StructOrUnionT toStructOrUnion() {
        throw new ClassCastException("Not a struct or union " + this);
    }

    public boolean isStruct() {
        return false;
    }

    public StructT toStruct() {
        throw new ClassCastException("Not a struct " + this);
    }

    public boolean isUnion() {
        return false;
    }

    public UnionT toUnion() {
        throw new ClassCastException("Not a union " + this);
    }

    public boolean isFunction() {
        return false;
    }

    public FunctionT toFunction() {
        throw new ClassCastException("Not a function " + this);
    }

    public boolean isMethod() {
        return false;
    }

    public MethodT toMethod() {
        throw new ClassCastException("Not a method " + this);
    }

    public boolean isClass() {
        return false;
    }

    public ClassT toClass() {
        throw new ClassCastException("Not a class " + this);
    }

    public boolean isInterface() {
        return false;
    }

    public InterfaceT toInterface() {
        throw new ClassCastException("Not an interface " + this);
    }

    public boolean isTuple() {
        return false;
    }

    public TupleT toTuple() {
        throw new ClassCastException("Not an tuple " + this);
    }

    public boolean isVariant() {
        return false;
    }

    public VariantT toVariant() {
        throw new ClassCastException("Not an variant " + this);
    }

    public boolean isWrapped() {
        return false;
    }

    public WrappedT toWrapped() {
        throw new ClassCastException("Not a wrapped type " + this);
    }

    public boolean isAnnotated() {
        return false;
    }

    public boolean hasAnnotated() {
        return false;
    }

    public AnnotatedT toAnnotated() {
        throw new ClassCastException("Not an annotated type " + this);
    }

    public boolean isAlias() {
        return false;
    }

    public boolean hasAlias() {
        return false;
    }

    public AliasT toAlias() {
        throw new ClassCastException("Not an alias " + this);
    }

    public boolean isEnum() {
        return false;
    }

    public boolean hasEnum() {
        return false;
    }

    public EnumT toEnum() {
        throw new ClassCastException("Not an enum " + this);
    }

    public boolean isEnumerator() {
        return false;
    }

    public boolean hasEnumerator() {
        return false;
    }

    public EnumeratorT toEnumerator() {
        throw new ClassCastException("Not an enumerator " + this);
    }

    public boolean isInstantiated() {
        return false;
    }

    public boolean hasInstantiated() {
        return false;
    }

    public InstantiatedT toInstantiated() {
        throw new ClassCastException("Not an instantiated type " + this);
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean hasParameterized() {
        return false;
    }

    public ParameterizedT toParameterized() {
        throw new ClassCastException("Not a parameterized type " + this);
    }

    public boolean isVariable() {
        return false;
    }

    @Override
    public boolean hasVariable() {
        return false;
    }

    public VariableT toVariable() {
        throw new ClassCastException("Not a variable " + this);
    }

    public boolean hasTagged() {
        return false;
    }

    public Tagged toTagged() {
        throw new ClassCastException("Not a tagged type " + this);
    }

    public boolean isConcrete() {
        return !this.hasParameterized() || this.hasInstantiated();
    }

    public Type resolve() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Runtime runtime) {
        Visitor visitor = runtime.console().visitor();
        TypePrinter printer = new TypePrinter(runtime.console());
        try {
            printer.dispatch(this);
            runtime.console().pln();
        }
        finally {
            runtime.console().register(visitor);
        }
        runtime.console().flush();
    }

    public static Type cast(Object type) {
        return (Type)type;
    }

    public static Type resolve(Object type) {
        return ((Type)type).resolve();
    }

    public static <T extends Type> List<T> copy(List<T> types) {
        if (null == types) {
            return null;
        }
        ArrayList<Type> copy = new ArrayList<Type>(types.size());
        for (Type t : types) {
            copy.add(t.copy());
        }
        return copy;
    }

    public static <T extends Type> List<T> seal(List<T> types) {
        if (null == types) {
            return null;
        }
        for (Type t : types) {
            t.seal();
        }
        return Collections.unmodifiableList(types);
    }

    public static enum Tag {
        BOOLEAN,
        ARRAY,
        CLASS,
        INTERFACE,
        FUNCTION,
        METHOD,
        NAMED_PARAMETER,
        INTERNAL_PARAMETER,
        WILDCARD,
        POINTER,
        STRUCT,
        TUPLE,
        UNION,
        VARIANT,
        ERROR,
        INTERNAL,
        LABEL,
        FLOAT,
        INTEGER,
        PACKAGE,
        UNIT,
        VOID,
        ALIAS,
        ANNOTATED,
        ENUMERATOR,
        ENUM,
        INSTANTIATED,
        PARAMETERIZED,
        VARIABLE;

    }
}

