/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.type.DerivedT;
import xtc.type.Type;
import xtc.util.Utilities;

public class TupleT
extends DerivedT {
    private final String qname;
    private final String sname;
    private List<Type> types;

    public TupleT() {
        this(null, null, null);
    }

    public TupleT(List<Type> types) {
        this(null, null, types);
    }

    public TupleT(String name) {
        this(null, name, null);
    }

    public TupleT(String name, Type type) {
        this(null, name, new ArrayList<Type>(1));
        this.types.add(type);
    }

    public TupleT(String name, List<Type> types) {
        this(null, name, types);
    }

    public TupleT(Type template, String name, List<Type> types) {
        super(template);
        this.qname = name;
        this.sname = null == name ? null : Utilities.unqualify(name);
        this.types = types;
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.types = Type.seal(this.types);
        }
        return this;
    }

    @Override
    public TupleT copy() {
        return new TupleT(this, this.qname, TupleT.copy(this.types));
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.TUPLE;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public TupleT toTuple() {
        return this;
    }

    public boolean hasName() {
        return null != this.qname;
    }

    @Override
    public boolean hasName(String name) {
        return name.equals(this.qname);
    }

    public boolean hasSimpleName(String name) {
        return name.equals(this.sname);
    }

    @Override
    public String getName() {
        return this.qname;
    }

    public String getSimpleName() {
        return this.sname;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void setTypes(List<Type> types) {
        this.checkNotSealed();
        this.types = types;
    }

    public int hashCode() {
        int hash = 0;
        if (null != this.qname) {
            hash = this.qname.hashCode();
        }
        if (null != this.types) {
            hash = 7 * hash + this.types.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = TupleT.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isTuple()) {
            return false;
        }
        TupleT other = t.toTuple();
        if (null == this.qname ? null != other.qname : !this.qname.equals(other.qname)) {
            return false;
        }
        return null == this.types ? null == other.types : this.types.equals(other.types);
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (null == this.qname) {
            out.append("<anonymous>");
        } else {
            out.append(this.qname);
        }
        out.append('(');
        if (null == this.types) {
            out.append("...");
        } else {
            Iterator<Type> iter = this.types.iterator();
            while (iter.hasNext()) {
                iter.next().write(out);
                if (!iter.hasNext()) continue;
                out.append(", ");
            }
        }
        out.append(')');
    }
}

