/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.List;
import xtc.type.DerivedT;
import xtc.type.ErrorT;
import xtc.type.Tagged;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.util.Nonce;

public abstract class StructOrUnionT
extends DerivedT
implements Tagged {
    protected final Nonce nonce;
    protected final String name;
    protected List<VariableT> members;

    public StructOrUnionT(Type template, Nonce nonce, String name, List<VariableT> members) {
        super(template);
        if (null == name) {
            throw new NullPointerException("Null name");
        }
        this.nonce = nonce;
        this.name = name;
        this.members = members;
    }

    @Override
    public Type seal() {
        if (null != this.members && !this.isSealed()) {
            super.seal();
            this.members = Type.seal(this.members);
        }
        return this;
    }

    @Override
    public StructOrUnionT toStructOrUnion() {
        return this;
    }

    @Override
    public boolean hasTagged() {
        return true;
    }

    @Override
    public Tagged toTagged() {
        return this;
    }

    @Override
    public Nonce getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isUnnamed() {
        return this.name.startsWith("tag(");
    }

    @Override
    public boolean hasName(String name) {
        return name.equals(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type lookup(String name) {
        for (VariableT member : this.members) {
            Type nested;
            if (member.hasName(name)) {
                return member;
            }
            if (member.hasName() || member.hasWidth() || (nested = ((StructOrUnionT)member.resolve()).lookup(name)).isError()) continue;
            return nested;
        }
        return ErrorT.TYPE;
    }

    @Override
    public int getMemberCount() {
        if (null == this.members) {
            return -1;
        }
        int count = 0;
        for (VariableT member : this.members) {
            if (!member.hasName() && member.hasWidth()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public VariableT getMember(int index) {
        int count = -1;
        for (VariableT member : this.members) {
            if (!member.hasName() && member.hasWidth() || index != ++count) continue;
            return member;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + (count + 1));
    }

    public List<VariableT> getMembers() {
        return this.members;
    }

    public void setMembers(List<VariableT> members) {
        this.checkNotSealed();
        this.members = members;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = (Type)o;
        return t.hasTagged() && this.nonce == t.toTagged().getNonce();
    }
}

