/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Reference;
import xtc.type.Type;
import xtc.util.Utilities;

public class StringReference
extends Reference {
    private final String literal;

    public StringReference(String literal, Type type) {
        super(type);
        this.literal = literal;
    }

    @Override
    public boolean isString() {
        return true;
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringReference)) {
            return false;
        }
        StringReference other = (StringReference)o;
        return this.type.equals(other.type) && this.literal.equals(other.literal);
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (this.type.hasTag(Type.Tag.INTEGER)) {
            switch (this.type.resolve().toInteger().getKind()) {
                default: {
                    out.append('L');
                }
                case CHAR: 
                case S_CHAR: 
                case U_CHAR: 
            }
        }
        out.append('\"');
        Utilities.escape(this.literal, out, 9);
        out.append('\"');
    }
}

