/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import xtc.Constants;
import xtc.tree.Attribute;
import xtc.tree.Printer;
import xtc.tree.VisitingException;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.ArrayT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.EnumT;
import xtc.type.ErrorT;
import xtc.type.FunctionT;
import xtc.type.InternalT;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.StructT;
import xtc.type.Type;
import xtc.type.UnionT;
import xtc.type.VariableT;
import xtc.type.VoidT;
import xtc.type.WrappedT;

public class SourcePrinter
extends Visitor {
    private static Set<Attribute> LITERALS = new HashSet<Attribute>();
    protected final Printer printer;
    protected Type base;
    protected List<Type> derived;
    protected String name;
    protected boolean needsSpace;

    public SourcePrinter(Printer printer) {
        this.printer = printer;
    }

    public void print(Type type) {
        this.print(type, null);
    }

    public void print(Type type, String variable) {
        Type savedBase = this.base;
        List<Type> savedDerived = this.derived;
        String savedName = this.name;
        boolean savedNeedsSpace = this.needsSpace;
        this.base = type;
        this.derived = null;
        this.name = variable;
        this.needsSpace = false;
        try {
            this.dispatch(type);
        }
        catch (VisitingException x) {
            if (x.getCause() instanceof RuntimeException) {
                throw (RuntimeException)x.getCause();
            }
            throw x;
        }
        finally {
            this.base = savedBase;
            this.derived = savedDerived;
            this.name = savedName;
            this.needsSpace = savedNeedsSpace;
        }
    }

    protected void setVariable(String variable) {
        if (null != this.name) {
            throw new IllegalArgumentException("duplicate variable name");
        }
        this.name = variable;
    }

    protected void addDerived(Type type) {
        if (null == this.derived) {
            this.derived = new ArrayList<Type>();
        }
        this.derived.add(type);
    }

    protected void space() {
        if (this.needsSpace) {
            this.printer.p(' ');
            this.needsSpace = false;
        }
    }

    protected void printDerived() {
        if (null != this.derived) {
            boolean isPointer = true;
            for (int i = this.derived.size() - 1; i >= 0; --i) {
                Type t = this.derived.get(i);
                Type r = t.resolve();
                if (!r.isPointer()) {
                    isPointer = false;
                    continue;
                }
                if (!isPointer) {
                    this.space();
                    this.printer.p('(');
                    this.needsSpace = false;
                    isPointer = true;
                }
                this.printPointer(t);
            }
        }
        if (null != this.name) {
            this.space();
            this.printer.p(this.name);
        }
        if (null != this.derived) {
            int size = this.derived.size();
            boolean isPointer = false;
            for (int i = 0; i < size; ++i) {
                Type t = this.derived.get(i);
                Type r = t.resolve();
                if (r.isPointer()) {
                    if (isPointer) continue;
                    for (int j = i + 1; j < size; ++j) {
                        if (this.derived.get(j).resolve().isPointer()) continue;
                        this.space();
                        this.printer.p(')');
                        break;
                    }
                    isPointer = true;
                    continue;
                }
                if (r.isArray()) {
                    isPointer = false;
                    this.printArray(t);
                    continue;
                }
                if (!r.isFunction()) continue;
                isPointer = false;
                this.printFunction(t);
            }
        }
    }

    protected void printPointer(Type type) {
        if (!type.resolve().isPointer()) {
            throw new IllegalStateException("printing non-pointer as pointer");
        }
        this.space();
        this.printer.p('*');
        if (SourcePrinter.hasAttributes(type)) {
            this.printer.p(' ');
            this.printAttributes(type);
        }
    }

    protected void printArray(Type type) {
        Type r = type.resolve();
        if (!r.isArray()) {
            throw new IllegalStateException("printing non-array as array");
        }
        ArrayT a = r.toArray();
        this.space();
        this.printer.p('[');
        if (SourcePrinter.hasAttributes(type)) {
            this.printAttributes(type);
        }
        if (a.isVarLength()) {
            this.space();
            this.printer.p('*');
        } else if (a.hasLength()) {
            this.space();
            this.printer.p(a.getLength());
        }
        this.printer.p(']');
    }

    protected void printFunction(Type type) {
        Type r = type.resolve();
        if (!r.isFunction()) {
            throw new IllegalStateException("printing non-function as function");
        }
        FunctionT f = (FunctionT)r;
        this.space();
        this.printer.p('(');
        if (f.hasAttribute(Constants.ATT_STYLE_NEW)) {
            List<Type> params = f.getParameters();
            if (0 == params.size()) {
                this.printer.p("void");
            } else {
                Iterator<Type> iter = params.iterator();
                while (iter.hasNext()) {
                    this.print(iter.next());
                    if (!iter.hasNext()) continue;
                    this.printer.p(", ");
                }
            }
        }
        this.printer.p(')');
    }

    public static boolean isPrintable(Attribute att) {
        if (LITERALS.contains(att)) {
            return true;
        }
        String name = att.getName();
        return "storage".equals(name) || "visibility".equals(name) && !Constants.ATT_PACKAGE_PRIVATE.equals(att);
    }

    public static boolean hasAttributes(Type type) {
        while (true) {
            if (type.hasAttributes()) {
                for (Attribute att : type.attributes()) {
                    if (!SourcePrinter.isPrintable(att)) continue;
                    return true;
                }
            }
            if (!type.isWrapped()) {
                return false;
            }
            type = type.toWrapped().getType();
        }
    }

    protected void printAttributes(Type type) {
        while (true) {
            if (type.hasAttributes()) {
                for (Attribute att : type.attributes()) {
                    this.dispatch(att);
                }
            }
            if (!type.isWrapped()) {
                return;
            }
            type = type.toWrapped().getType();
        }
    }

    public void visit(Attribute att) {
        String name = att.getName();
        if ("storage".equals(name)) {
            this.space();
            this.printer.p(att.getValue().toString());
            this.needsSpace = true;
        } else if ("visibility".equals(name)) {
            if (!Constants.ATT_PACKAGE_PRIVATE.equals(att)) {
                this.space();
                this.printer.p(att.getValue().toString());
                this.needsSpace = true;
            }
        } else if (Constants.ATT_CONSTANT.equals(att)) {
            this.space();
            this.printer.p("const");
            this.needsSpace = true;
        } else if (Constants.ATT_THREAD_LOCAL.equals(att)) {
            this.space();
            this.printer.p("__thread");
            this.needsSpace = true;
        } else if (LITERALS.contains(att)) {
            this.space();
            this.printer.p(name);
            this.needsSpace = true;
        }
    }

    public void visit(VoidT t) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p("void");
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(NumberT t) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p(t.toString());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(StructT t) {
        if (t.isUnnamed()) {
            throw new IllegalArgumentException("anonymous struct");
        }
        this.printAttributes(this.base);
        this.space();
        this.printer.p("struct ").p(t.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(UnionT t) {
        if (t.isUnnamed()) {
            throw new IllegalArgumentException("anonymous union");
        }
        this.printAttributes(this.base);
        this.space();
        this.printer.p("union ").p(t.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(EnumT t) {
        if (t.isUnnamed()) {
            throw new IllegalArgumentException("anonymous enum");
        }
        this.printAttributes(this.base);
        this.space();
        this.printer.p("enum ").p(t.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(ClassOrInterfaceT t) {
        this.space();
        this.printer.p(t.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(AliasT t) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p(t.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(InternalT t) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p(t.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(PointerT t) {
        this.addDerived(this.base);
        this.base = t.getType();
        this.dispatch(this.base);
    }

    public void visit(ArrayT t) {
        this.addDerived(this.base);
        this.base = t.getType();
        this.dispatch(this.base);
    }

    public void visit(FunctionT t) {
        this.addDerived(this.base);
        this.base = t.getResult();
        this.dispatch(this.base);
    }

    public void visit(VariableT t) {
        this.setVariable(t.getName());
        this.dispatch(t.getType());
    }

    public void visit(WrappedT t) {
        this.dispatch(t.getType());
    }

    public void visit(ErrorT t) {
        throw new IllegalArgumentException("error type");
    }

    static {
        LITERALS.add(Constants.ATT_ABSTRACT);
        LITERALS.add(Constants.ATT_CONSTANT);
        LITERALS.add(Constants.ATT_INLINE);
        LITERALS.add(Constants.ATT_NATIVE);
        LITERALS.add(Constants.ATT_RESTRICT);
        LITERALS.add(Constants.ATT_STRICT_FP);
        LITERALS.add(Constants.ATT_SYNCHRONIZED);
        LITERALS.add(Constants.ATT_THREAD_LOCAL);
        LITERALS.add(Constants.ATT_TRANSIENT);
        LITERALS.add(Constants.ATT_VOLATILE);
    }
}

