/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.math.BigInteger;
import xtc.type.C;
import xtc.type.IndexReference;
import xtc.type.IndirectReference;
import xtc.type.Type;

public abstract class Reference {
    protected final Type type;

    public Reference(Type type) {
        type = type.resolve();
        while (type.isArray()) {
            type = type.toArray().getType().resolve();
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isPrefix() {
        return false;
    }

    public boolean isCast() {
        return false;
    }

    public boolean isIndirect() {
        return false;
    }

    public boolean hasBase() {
        return false;
    }

    public Reference getBase() {
        throw new IllegalStateException("not a relative reference");
    }

    public boolean hasIndex() {
        return false;
    }

    public BigInteger getIndex() {
        throw new IllegalStateException("not an index reference");
    }

    public boolean hasField() {
        return false;
    }

    public String getField() {
        throw new IllegalStateException("not a field reference");
    }

    public boolean hasLocation() {
        return false;
    }

    public BigInteger getLocation(C ops) {
        throw new IllegalStateException();
    }

    public boolean isConstant() {
        return false;
    }

    public Reference indirect(Type type) {
        Type resolved = type.resolve();
        if (resolved.isArray() || resolved.isFunction()) {
            return this;
        }
        return new IndirectReference(this);
    }

    public Reference add(long val) {
        if (0L == val) {
            return this;
        }
        return this.add(BigInteger.valueOf(val));
    }

    public Reference add(BigInteger val) {
        if (val.signum() == 0) {
            return this;
        }
        return new IndexReference(this, val);
    }

    public Reference subtract(long val) {
        if (0L == val) {
            return this;
        }
        return this.subtract(BigInteger.valueOf(val));
    }

    public Reference subtract(BigInteger val) {
        if (val.signum() == 0) {
            return this;
        }
        return new IndexReference(this, val.negate());
    }

    public BigInteger difference(Reference ref) {
        if (this.hasIndex() && ref.hasIndex()) {
            IndexReference r1 = (IndexReference)this;
            IndexReference r2 = (IndexReference)ref;
            if (r1.base.equals(r2.base)) {
                return r1.index.subtract(r2.index);
            }
        } else if (this.hasIndex()) {
            IndexReference r1 = (IndexReference)this;
            if (r1.base.equals(ref)) {
                return r1.index;
            }
        } else if (ref.hasIndex()) {
            IndexReference r2 = (IndexReference)ref;
            if (this.equals(r2.base)) {
                return r2.index.negate();
            }
        }
        return null;
    }

    public abstract void write(Appendable var1) throws IOException;

    public String toString() {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder();
            try {
                this.write(buf);
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }
}

