/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.DerivedT;
import xtc.type.Type;
import xtc.type.VoidT;

public class PointerT
extends DerivedT {
    public static final PointerT TO_VOID = new PointerT(VoidT.TYPE);
    private Type type;

    public PointerT(Type type) {
        this.type = type;
    }

    public PointerT(Type template, Type type) {
        super(template);
        this.type = type;
    }

    @Override
    public PointerT copy() {
        return new PointerT(this, this.type.copy());
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.type.seal();
        }
        return this;
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.POINTER;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public PointerT toPointer() {
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = PointerT.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isPointer()) {
            return false;
        }
        return this.type.equals(((PointerT)t).type);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append("pointer(");
        this.type.write(out);
        out.append(')');
    }

    static {
        TO_VOID.seal();
    }
}

