/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.type.Parameter;
import xtc.type.Type;
import xtc.type.WrappedT;

public class ParameterizedT
extends WrappedT {
    private List<Parameter> parameters;

    public ParameterizedT(Parameter parameter, Type type) {
        super(type);
        this.parameters = new ArrayList<Parameter>(1);
        this.parameters.add(parameter);
    }

    public ParameterizedT(List<Parameter> parameters, Type type) {
        super(type);
        this.parameters = parameters;
    }

    public ParameterizedT(Type template, List<Parameter> parameters, Type type) {
        super(template, type);
        this.parameters = parameters;
    }

    @Override
    public ParameterizedT copy() {
        return new ParameterizedT(this, Type.copy(this.parameters), this.getType().copy());
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.parameters = Type.seal(this.parameters);
        }
        return this;
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.PARAMETERIZED;
    }

    @Override
    public boolean isParameterized() {
        return true;
    }

    @Override
    public boolean hasParameterized() {
        return true;
    }

    @Override
    public ParameterizedT toParameterized() {
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append('<');
        Iterator<Parameter> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            iter.next().write(out);
            if (!iter.hasNext()) continue;
            out.append(", ");
        }
        out.append("> ");
        this.getType().write(out);
    }
}

