/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.FloatT;
import xtc.type.IntegerT;
import xtc.type.Type;

public abstract class NumberT
extends Type {
    public static final IntegerT BYTE = new IntegerT(Kind.BYTE);
    public static final IntegerT CHAR = new IntegerT(Kind.CHAR);
    public static final IntegerT S_CHAR = new IntegerT(Kind.S_CHAR);
    public static final IntegerT U_CHAR = new IntegerT(Kind.U_CHAR);
    public static final IntegerT SHORT = new IntegerT(Kind.SHORT);
    public static final IntegerT U_SHORT = new IntegerT(Kind.U_SHORT);
    public static final IntegerT INT = new IntegerT(Kind.INT);
    public static final IntegerT S_INT = new IntegerT(Kind.S_INT);
    public static final IntegerT U_INT = new IntegerT(Kind.U_INT);
    public static final IntegerT LONG = new IntegerT(Kind.LONG);
    public static final IntegerT U_LONG = new IntegerT(Kind.U_LONG);
    public static final IntegerT LONG_LONG = new IntegerT(Kind.LONG_LONG);
    public static final IntegerT U_LONG_LONG = new IntegerT(Kind.U_LONG_LONG);
    public static final FloatT FLOAT = new FloatT(Kind.FLOAT);
    public static final FloatT DOUBLE = new FloatT(Kind.DOUBLE);
    public static final FloatT LONG_DOUBLE = new FloatT(Kind.LONG_DOUBLE);
    public static final FloatT FLOAT_COMPLEX = new FloatT(Kind.FLOAT_COMPLEX);
    public static final FloatT DOUBLE_COMPLEX = new FloatT(Kind.DOUBLE_COMPLEX);
    public static final FloatT LONG_DOUBLE_COMPLEX = new FloatT(Kind.LONG_DOUBLE_COMPLEX);
    protected final Kind kind;

    public NumberT(Kind kind) {
        this.kind = kind;
    }

    public NumberT(Type template, Kind kind) {
        super(template);
        this.kind = kind;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public NumberT toNumber() {
        return this;
    }

    public boolean hasKind(Kind kind) {
        return NumberT.equal(this.kind, kind);
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isSigned() {
        switch (this.kind) {
            case U_CHAR: 
            case U_SHORT: 
            case U_INT: 
            case U_LONG: 
            case U_LONG_LONG: {
                return false;
            }
            case CHAR: {
                return true;
            }
        }
        return true;
    }

    public int hashCode() {
        return (this.kind.ordinal() + 1) * 37;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = NumberT.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isNumber()) {
            return false;
        }
        return NumberT.equal(this.kind, ((NumberT)t).kind);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append(this.toString());
    }

    @Override
    public String toString() {
        switch (this.kind) {
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case S_CHAR: {
                return "signed char";
            }
            case U_CHAR: {
                return "unsigned char";
            }
            case SHORT: {
                return "short";
            }
            case U_SHORT: {
                return "unsigned short";
            }
            case INT: {
                return "int";
            }
            case S_INT: {
                return "signed int";
            }
            case U_INT: {
                return "unsigned int";
            }
            case LONG: {
                return "long";
            }
            case U_LONG: {
                return "unsigned long";
            }
            case LONG_LONG: {
                return "long long";
            }
            case U_LONG_LONG: {
                return "unsigned long long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case LONG_DOUBLE: {
                return "long double";
            }
            case FLOAT_COMPLEX: {
                return "float _Complex";
            }
            case DOUBLE_COMPLEX: {
                return "double _Complex";
            }
            case LONG_DOUBLE_COMPLEX: {
                return "long double _Complex";
            }
        }
        throw new AssertionError((Object)("Invalid kind: " + (Object)((Object)this.kind)));
    }

    public static boolean equal(Kind k1, Kind k2) {
        return k1 == k2 || (Kind.INT == k1 || Kind.S_INT == k1) && (Kind.INT == k2 || Kind.S_INT == k2);
    }

    public static boolean equalIgnoringSign(Kind k1, Kind k2) {
        switch (k1) {
            case U_CHAR: 
            case CHAR: 
            case S_CHAR: {
                return Kind.CHAR == k2 || Kind.S_CHAR == k2 || Kind.U_CHAR == k2;
            }
            case U_SHORT: 
            case SHORT: {
                return Kind.SHORT == k2 || Kind.U_SHORT == k2;
            }
            case U_INT: 
            case INT: 
            case S_INT: {
                return Kind.INT == k2 || Kind.S_INT == k2 || Kind.U_INT == k2;
            }
            case U_LONG: 
            case LONG: {
                return Kind.LONG == k2 || Kind.U_LONG == k2;
            }
            case U_LONG_LONG: 
            case LONG_LONG: {
                return Kind.LONG_LONG == k2 || Kind.U_LONG_LONG == k2;
            }
        }
        return k1 == k2;
    }

    static {
        BYTE.seal();
        CHAR.seal();
        S_CHAR.seal();
        U_CHAR.seal();
        SHORT.seal();
        U_SHORT.seal();
        INT.seal();
        S_INT.seal();
        U_INT.seal();
        LONG.seal();
        U_LONG.seal();
        LONG_LONG.seal();
        U_LONG_LONG.seal();
        FLOAT.seal();
        DOUBLE.seal();
        LONG_DOUBLE.seal();
        FLOAT_COMPLEX.seal();
        DOUBLE_COMPLEX.seal();
        LONG_DOUBLE_COMPLEX.seal();
    }

    public static enum Kind {
        BYTE,
        CHAR,
        S_CHAR,
        U_CHAR,
        SHORT,
        U_SHORT,
        INT,
        S_INT,
        U_INT,
        LONG,
        U_LONG,
        LONG_LONG,
        U_LONG_LONG,
        FLOAT,
        DOUBLE,
        LONG_DOUBLE,
        FLOAT_COMPLEX,
        DOUBLE_COMPLEX,
        LONG_DOUBLE_COMPLEX;

    }
}

