/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Parameter;
import xtc.type.Type;

public class NamedParameter
extends Parameter {
    private String name;

    public NamedParameter(String name) {
        this.name = name;
    }

    private NamedParameter(Type template, String name) {
        super(template);
        this.name = name;
    }

    @Override
    public NamedParameter copy() {
        return new NamedParameter(this, this.name);
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.NAMED_PARAMETER;
    }

    @Override
    public boolean isNamedParameter() {
        return true;
    }

    @Override
    public NamedParameter toNamedParameter() {
        return this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = NamedParameter.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isNamedParameter()) {
            return false;
        }
        return this.name.equals(t.toNamedParameter().name);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append(this.name);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

