/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.tree.Locatable;
import xtc.type.AST;
import xtc.type.ClassT;
import xtc.type.ErrorT;
import xtc.type.InstantiatedT;
import xtc.type.NamedParameter;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.Wildcard;

public class JavaAST
extends AST {
    public static final Set<String> PRIMITIVES;
    public static final Set<String> MODIFIERS;
    public static final Set<String> KEYWORDS;
    protected Map<String, Class<?>> resolvedTypes = new HashMap();
    private static final int QLIST_IDX;
    private static final int LIST_IDX;
    private static final int QACTION_IDX;
    private static final int ACTION_IDX;

    @Override
    public void initialize(boolean hasNode, boolean hasToken, boolean hasFormatting, boolean hasAction) {
        this.externToIntern.clear();
        this.internToExtern.clear();
        this.externToIntern.put("?", Wildcard.TYPE);
        this.externToIntern.put("void", VoidT.TYPE);
        this.externToIntern.put("Object", ANY);
        this.externToIntern.put("java.lang.Object", ANY);
        this.externToIntern.put("Character", CHAR);
        this.externToIntern.put("java.lang.Character", CHAR);
        this.externToIntern.put("String", STRING);
        this.externToIntern.put("java.lang.String", STRING);
        if (hasToken) {
            this.externToIntern.put("Token", TOKEN);
        }
        this.externToIntern.put("xtc.tree.Token", TOKEN);
        if (hasNode) {
            this.externToIntern.put("Node", NODE);
        }
        this.externToIntern.put("xtc.tree.Node", NODE);
        this.externToIntern.put("generic", GENERIC);
        if (hasNode) {
            this.externToIntern.put("GNode", NODE);
        }
        this.externToIntern.put("xtc.tree.GNode", NODE);
        if (hasFormatting) {
            this.externToIntern.put("Formatting", FORMATTING);
        }
        this.externToIntern.put("xtc.tree.Formatting", FORMATTING);
        this.externToIntern.put("Pair", WILD_LIST);
        this.externToIntern.put("xtc.util.Pair", WILD_LIST);
        if (hasAction) {
            this.externToIntern.put("Action", WILD_ACTION);
        }
        this.externToIntern.put("xtc.util.Action", WILD_ACTION);
        this.internToExtern.put("?", "?");
        this.internToExtern.put("void", "Void");
        this.internToExtern.put("unit", "Void");
        this.internToExtern.put("any", "Object");
        this.internToExtern.put("char", "Character");
        this.internToExtern.put("string", "String");
        this.internToExtern.put("token", "Token");
        this.internToExtern.put("node", "Node");
        this.internToExtern.put("formatting", "Formatting");
        this.internToExtern.put("list", "Pair");
        this.internToExtern.put("action", "Action");
    }

    @Override
    public boolean isVoid(String s) {
        return "void".equals(s);
    }

    @Override
    public boolean isGenericNode(String s) {
        return "generic".equals(s);
    }

    @Override
    protected Type internList(String s) {
        if (s.startsWith("xtc.util.Pair<")) {
            return new InstantiatedT(this.intern(s.substring(QLIST_IDX, s.length() - 1)), LIST);
        }
        if (s.startsWith("Pair<")) {
            return new InstantiatedT(this.intern(s.substring(LIST_IDX, s.length() - 1)), LIST);
        }
        return ErrorT.TYPE;
    }

    @Override
    protected Type internAction(String s) {
        if (s.startsWith("xtc.util.Action<")) {
            return new InstantiatedT(this.intern(s.substring(QACTION_IDX, s.length() - 1)), ACTION);
        }
        if (s.startsWith("Action<")) {
            return new InstantiatedT(this.intern(s.substring(ACTION_IDX, s.length() - 1)), ACTION);
        }
        return ErrorT.TYPE;
    }

    @Override
    protected Type internUser(String s) {
        if (PRIMITIVES.contains(s)) {
            throw new IllegalArgumentException("Java primitive type");
        }
        if (MODIFIERS.contains(s)) {
            throw new IllegalArgumentException("Java modifier as type");
        }
        if (KEYWORDS.contains(s)) {
            throw new IllegalArgumentException("Java keyword as type");
        }
        int idx = s.indexOf(60);
        if (-1 == idx) {
            return new ClassT(s, null, null, null, null);
        }
        ClassT type = new ClassT(s.substring(0, idx), null, null, null, null);
        String args = s.substring(idx + 1, s.length() - 1);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        ArrayList<Type> arguments = new ArrayList<Type>();
        int count = 1;
        int start = 0;
        do {
            int end = this.endOfType(args, start);
            parameters.add(new NamedParameter("T" + count));
            arguments.add(this.intern(args.substring(start, end)));
            start = end + 1;
            ++count;
        } while (start < args.length());
        return new InstantiatedT(arguments, (Type)new ParameterizedT(parameters, (Type)type));
    }

    protected int endOfType(String args, int start) {
        int size = args.length();
        int end = start;
        int nesting = 0;
        do {
            char c = args.charAt(end);
            switch (c) {
                case '<': {
                    ++nesting;
                    break;
                }
                case '>': {
                    --nesting;
                    break;
                }
                case ',': {
                    if (0 != nesting) break;
                    return end;
                }
            }
        } while (++end < size);
        return end;
    }

    @Override
    protected String externList(Type type) {
        return "Pair<" + this.extern(JavaAST.getArgument(type)) + ">";
    }

    @Override
    protected String externAction(Type type) {
        return "Action<" + this.extern(JavaAST.getArgument(type)) + ">";
    }

    @Override
    protected String externUser(Type type) {
        if (type.hasInstantiated() || type.hasParameterized()) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.extern(type.resolve()));
            buf.append('<');
            Iterator<Type> iter = type.hasInstantiated() ? type.toInstantiated().getArguments().iterator() : type.toParameterized().getParameters().iterator();
            do {
                buf.append(this.extern(iter.next()));
                if (!iter.hasNext()) continue;
                buf.append(',');
            } while (iter.hasNext());
            buf.append('>');
            return buf.toString();
        }
        if (!type.resolve().isClass()) {
            System.out.println(type);
        }
        return type.resolve().toClass().getQName();
    }

    @Override
    protected Constants.FuzzyBoolean hasLocationUser(Type type) {
        Class<?> k = this.resolve(type.resolve().toClass().getQName());
        if (null == k || Object.class.equals(k)) {
            return Constants.FuzzyBoolean.MAYBE;
        }
        if (Locatable.class.isAssignableFrom(k)) {
            return Constants.FuzzyBoolean.TRUE;
        }
        return Constants.FuzzyBoolean.FALSE;
    }

    @Override
    protected Type unifyUser(Type t1, Type t2, boolean strict) {
        Type r1 = t1.resolve();
        Type r2 = t2.resolve();
        if (r1.isClass() && r2.isClass() && r1.toClass().getQName().equals(r2.toClass().getQName())) {
            return t1;
        }
        if (strict) {
            return ErrorT.TYPE;
        }
        return ANY;
    }

    public Class<?> resolve(String name) {
        if (this.resolvedTypes.containsKey(name)) {
            return this.resolvedTypes.get(name);
        }
        Class<?> k = null;
        if (this.importedTypes.containsKey(name)) {
            try {
                k = Class.forName((String)this.importedTypes.get(name));
            }
            catch (ClassNotFoundException x) {}
        } else {
            for (String module : this.importedModules) {
                try {
                    k = Class.forName(module + name);
                    break;
                }
                catch (ClassNotFoundException x) {
                }
            }
            if (null == k) {
                try {
                    k = Class.forName(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        this.resolvedTypes.put(name, k);
        return k;
    }

    static {
        HashSet<String> primitives = new HashSet<String>();
        primitives.add("byte");
        primitives.add("short");
        primitives.add("char");
        primitives.add("int");
        primitives.add("long");
        primitives.add("float");
        primitives.add("double");
        primitives.add("boolean");
        PRIMITIVES = Collections.unmodifiableSet(primitives);
        HashSet<String> modifiers = new HashSet<String>();
        modifiers.add("public");
        modifiers.add("protected");
        modifiers.add("private");
        modifiers.add("static");
        modifiers.add("abstract");
        modifiers.add("final");
        modifiers.add("native");
        modifiers.add("synchronized");
        modifiers.add("transient");
        modifiers.add("volatile");
        modifiers.add("strictfp");
        MODIFIERS = Collections.unmodifiableSet(primitives);
        HashSet<String> keywords = new HashSet<String>();
        keywords.add("assert");
        keywords.add("break");
        keywords.add("case");
        keywords.add("catch");
        keywords.add("class");
        keywords.add("const");
        keywords.add("continue");
        keywords.add("default");
        keywords.add("do");
        keywords.add("else");
        keywords.add("enum");
        keywords.add("extends");
        keywords.add("finally");
        keywords.add("for");
        keywords.add("if");
        keywords.add("goto");
        keywords.add("implements");
        keywords.add("import");
        keywords.add("instanceof");
        keywords.add("interface");
        keywords.add("new");
        keywords.add("package");
        keywords.add("return");
        keywords.add("super");
        keywords.add("switch");
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add("try");
        keywords.add("while");
        KEYWORDS = Collections.unmodifiableSet(keywords);
        QLIST_IDX = "xtc.util.Pair<".length();
        LIST_IDX = "Pair<".length();
        QACTION_IDX = "xtc.util.Action<".length();
        ACTION_IDX = "Action<".length();
    }
}

