/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Parameter;
import xtc.type.Type;

public class InternalParameter
extends Parameter {
    private static long count = 0L;
    private long nonce;

    public InternalParameter() {
        this.nonce = ++count;
    }

    public InternalParameter(Type template) {
        super(template);
        this.nonce = ++count;
    }

    private InternalParameter(Type template, long nonce) {
        super(template);
        this.nonce = nonce;
    }

    @Override
    public InternalParameter copy() {
        return new InternalParameter(this, this.nonce);
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.INTERNAL_PARAMETER;
    }

    @Override
    public boolean isInternalParameter() {
        return true;
    }

    @Override
    public InternalParameter toInternalParameter() {
        return this;
    }

    public int hashCode() {
        return (int)this.nonce;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = InternalParameter.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isInternalParameter()) {
            return false;
        }
        return this.nonce == t.toInternalParameter().nonce;
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append(Long.toString(this.nonce));
    }

    @Override
    public String toString() {
        return Long.toString(this.nonce);
    }
}

