/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.type.Type;
import xtc.type.WrappedT;

public class InstantiatedT
extends WrappedT {
    private List<Type> arguments;

    public InstantiatedT(Type argument, Type type) {
        super(type);
        this.arguments = new ArrayList<Type>(1);
        this.arguments.add(argument);
        if (!type.hasParameterized()) {
            throw new IllegalArgumentException("Not a parameterized type " + type);
        }
        if (1 != type.toParameterized().getParameters().size()) {
            throw new IllegalArgumentException("Wrong number of parameters " + type);
        }
    }

    public InstantiatedT(List<Type> arguments, Type type) {
        super(type);
        this.arguments = arguments;
        if (!type.hasParameterized()) {
            throw new IllegalArgumentException("Not a parameterized type " + type);
        }
        if (arguments.size() != type.toParameterized().getParameters().size()) {
            throw new IllegalArgumentException("Wrong number of parameters " + type);
        }
    }

    public InstantiatedT(Type template, List<Type> arguments, Type type) {
        super(template, type);
        this.arguments = arguments;
        if (!type.hasParameterized()) {
            throw new IllegalArgumentException("Not a parameterized type " + type);
        }
        if (arguments.size() != type.toParameterized().getParameters().size()) {
            throw new IllegalArgumentException("Wrong number of parameters " + type);
        }
    }

    @Override
    public InstantiatedT copy() {
        return new InstantiatedT(this, Type.copy(this.arguments), this.getType().copy());
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.arguments = Type.seal(this.arguments);
        }
        return this;
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.INSTANTIATED;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public boolean hasInstantiated() {
        return true;
    }

    @Override
    public InstantiatedT toInstantiated() {
        return this;
    }

    public List<Type> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = InstantiatedT.cast(o);
        if (!t.hasInstantiated()) {
            return false;
        }
        InstantiatedT other = t.toInstantiated();
        if (this.arguments.size() != other.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i).equals(other.arguments.get(i))) continue;
            return false;
        }
        return this.getType().equals(other.getType());
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (1 == this.arguments.size()) {
            out.append("argument(");
        } else {
            out.append("arguments(");
        }
        Iterator<Type> iter = this.arguments.iterator();
        while (iter.hasNext()) {
            iter.next().write(out);
            if (!iter.hasNext()) continue;
            out.append(", ");
        }
        out.append(") ");
        this.getType().write(out);
    }
}

