/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.math.BigInteger;
import xtc.type.C;
import xtc.type.Reference;
import xtc.type.RelativeReference;
import xtc.type.Type;

public class IndexReference
extends RelativeReference {
    final BigInteger index;
    private static final BigInteger MIN = BigInteger.valueOf(-255L);
    private static final BigInteger MAX = BigInteger.valueOf(255L);

    public IndexReference(Reference base, BigInteger index) {
        super(base.type, base);
        this.index = index;
    }

    IndexReference(Type type, Reference base, BigInteger index) {
        super(type, base);
        this.index = index;
    }

    @Override
    public boolean isNull() {
        return 0 == this.index.signum() ? this.base.isNull() : false;
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public BigInteger getIndex() {
        return this.index;
    }

    @Override
    public boolean hasLocation() {
        return this.base.hasLocation();
    }

    @Override
    public BigInteger getLocation(C ops) {
        if (!this.base.hasLocation()) {
            throw new IllegalStateException();
        }
        return this.base.getLocation(ops).add(this.index.multiply(BigInteger.valueOf(ops.getSize(this.type))));
    }

    @Override
    public Reference add(BigInteger val) {
        if (val.signum() == 0) {
            return this;
        }
        return new IndexReference(this.type, this.base, this.index.add(val));
    }

    @Override
    public Reference subtract(BigInteger val) {
        if (val.signum() == 0) {
            return this;
        }
        return new IndexReference(this.type, this.base, this.index.subtract(val));
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexReference)) {
            return false;
        }
        IndexReference other = (IndexReference)o;
        return this.index.equals(other.index) && this.base.equals(other.base) && this.type.equals(other.type);
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (this.base.isPrefix()) {
            out.append('(');
        }
        this.base.write(out);
        if (this.base.isPrefix()) {
            out.append(')');
        }
        out.append('[');
        if (MIN.compareTo(this.index) <= 0 && this.index.compareTo(MAX) <= 0) {
            out.append(this.index.toString());
        } else if (-1 == this.index.signum()) {
            out.append("-0x");
            out.append(this.index.negate().toString(16));
        } else {
            out.append("0x");
            out.append(this.index.toString(16));
        }
        out.append(']');
    }
}

