/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import xtc.type.DerivedT;
import xtc.type.Type;

public abstract class FunctionOrMethodT
extends DerivedT {
    protected Type result;
    protected String name;
    protected List<Type> parameters;
    protected boolean varargs;
    protected List<Type> exceptions;

    public FunctionOrMethodT(Type template, Type result, String name, List<Type> parameters, boolean varargs, List<Type> exceptions) {
        super(template);
        this.result = result;
        this.name = name;
        this.parameters = parameters;
        this.varargs = varargs;
        this.exceptions = exceptions;
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.result.seal();
            this.parameters = Type.seal(this.parameters);
            this.exceptions = Type.seal(this.exceptions);
        }
        return this;
    }

    public Type getResult() {
        return this.result;
    }

    public void setResult(Type result) {
        this.checkNotSealed();
        this.result = result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<Type> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Type> parameters) {
        this.checkNotSealed();
        this.parameters = parameters;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public List<Type> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<Type> exceptions) {
        this.checkNotSealed();
        this.exceptions = exceptions;
    }

    public int hashCode() {
        return this.parameters.hashCode() * 37 + this.result.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = FunctionOrMethodT.resolve(o);
        if (this == t) {
            return true;
        }
        if (!this.getClass().equals(t.getClass())) {
            return false;
        }
        FunctionOrMethodT other = (FunctionOrMethodT)t;
        if (this.varargs != other.varargs) {
            return false;
        }
        if (!this.result.equals(other.result)) {
            return false;
        }
        if (null == this.exceptions ? null != other.exceptions : !this.exceptions.equals(other.exceptions)) {
            return false;
        }
        return this.parameters.equals(other.parameters);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append('(');
        Iterator<Type> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            iter.next().write(out);
            if (!iter.hasNext() && !this.varargs) continue;
            out.append(", ");
        }
        if (this.varargs) {
            out.append("...");
        }
        out.append(") -> ");
        if (this.result.resolve().isFunction()) {
            out.append('(');
            this.result.write(out);
            out.append(')');
        } else {
            this.result.write(out);
        }
    }
}

