/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.math.BigInteger;
import xtc.type.C;
import xtc.type.Reference;
import xtc.type.RelativeReference;

public class FieldReference
extends RelativeReference {
    private final String name;

    public FieldReference(Reference base, String name) {
        super(base.type.toStructOrUnion().lookup(name), base);
        this.name = name;
        if (this.type.isError()) {
            throw new IllegalArgumentException("struct/union without member '" + name + "'");
        }
    }

    @Override
    public boolean hasField() {
        return true;
    }

    @Override
    public String getField() {
        return this.name;
    }

    @Override
    public boolean hasLocation() {
        return this.base.hasLocation();
    }

    @Override
    public BigInteger getLocation(C ops) {
        if (!this.base.hasLocation()) {
            throw new IllegalStateException();
        }
        return this.base.getLocation(ops).add(BigInteger.valueOf(ops.getOffset(this.base.type.toStructOrUnion(), this.name)));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldReference)) {
            return false;
        }
        FieldReference other = (FieldReference)o;
        return this.name.equals(other.name) && this.base.equals(other.base);
    }

    @Override
    public void write(Appendable out) throws IOException {
        if (this.base.isPrefix()) {
            out.append('(');
        }
        this.base.write(out);
        if (this.base.isPrefix()) {
            out.append(')');
        }
        out.append('.');
        out.append(this.name);
    }
}

