/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.List;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.Tagged;
import xtc.type.Type;
import xtc.type.WrappedT;
import xtc.util.Nonce;

public class EnumT
extends WrappedT
implements Tagged {
    private final Nonce nonce;
    private final String name;
    private List<EnumeratorT> enumerators;

    public EnumT(String name) {
        this(null, ErrorT.TYPE, Nonce.create(), name, null);
    }

    public EnumT(Type type, String name, List<EnumeratorT> enumerators) {
        this(null, type, Nonce.create(), name, enumerators);
    }

    public EnumT(Type template, Type type, Nonce nonce, String name, List<EnumeratorT> enumerators) {
        super(template, type);
        if (null == name) {
            throw new NullPointerException("Null name");
        }
        this.nonce = nonce;
        this.name = name;
        this.enumerators = enumerators;
    }

    @Override
    public EnumT copy() {
        return new EnumT(this, this.getType().copy(), this.nonce, this.name, EnumT.copy(this.enumerators));
    }

    @Override
    public Type seal() {
        if (null != this.enumerators && !this.isSealed()) {
            super.seal();
            this.enumerators = Type.seal(this.enumerators);
        }
        return this;
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.ENUM;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public boolean hasEnum() {
        return true;
    }

    @Override
    public EnumT toEnum() {
        return this;
    }

    @Override
    public boolean hasTagged() {
        return true;
    }

    @Override
    public Tagged toTagged() {
        return this;
    }

    @Override
    public void setType(Type type) {
        super.setType(type);
        for (EnumeratorT e : this.enumerators) {
            e.setType(type);
        }
    }

    @Override
    public Nonce getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isUnnamed() {
        return this.name.startsWith("tag(");
    }

    @Override
    public boolean hasName(String name) {
        return name.equals(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type lookup(String name) {
        for (EnumeratorT e : this.enumerators) {
            if (!e.hasName(name)) continue;
            return e;
        }
        return ErrorT.TYPE;
    }

    @Override
    public int getMemberCount() {
        return null == this.enumerators ? -1 : this.enumerators.size();
    }

    @Override
    public EnumeratorT getMember(int index) {
        return this.enumerators.get(index);
    }

    public List<EnumeratorT> getMembers() {
        return this.enumerators;
    }

    public void setMembers(List<EnumeratorT> enumerators) {
        this.checkNotSealed();
        this.enumerators = enumerators;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = (Type)o;
        return t.hasTagged() && this.nonce == t.toTagged().getNonce();
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append("enum ");
        out.append(this.name);
    }
}

