/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.math.BigInteger;
import xtc.type.Reference;

public class Constant {
    private Kind kind;
    private Object value;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant(Object value) {
        this.value = value;
        if (null == value) {
            throw new NullPointerException();
        }
        if (value instanceof Number) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                this.kind = Kind.INTEGER;
                return;
            } else if (value instanceof BigInteger) {
                this.kind = Kind.BIG_INTEGER;
                return;
            } else {
                if (!(value instanceof Float) && !(value instanceof Double)) throw new IllegalArgumentException("Invalid number " + value);
                this.kind = Kind.DOUBLE;
            }
            return;
        } else if (value instanceof Character) {
            this.kind = Kind.CHARACTER;
            return;
        } else if (value instanceof String) {
            this.kind = Kind.STRING;
            return;
        } else {
            if (!(value instanceof Reference)) throw new IllegalArgumentException("invalid value " + value);
            this.kind = Kind.REFERENCE;
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isNumber() {
        switch (this.kind) {
            case CHARACTER: 
            case INTEGER: 
            case BIG_INTEGER: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return Kind.STRING == this.kind;
    }

    public boolean isReference() {
        return Kind.REFERENCE == this.kind;
    }

    public Object getValue() {
        return this.value;
    }

    public long longValue() {
        switch (this.kind) {
            case INTEGER: 
            case BIG_INTEGER: 
            case DOUBLE: {
                return ((Number)this.value).longValue();
            }
            case CHARACTER: {
                return ((Character)this.value).charValue();
            }
        }
        throw new IllegalStateException("Not a number " + (Object)((Object)this.kind));
    }

    public BigInteger bigIntValue() {
        switch (this.kind) {
            case INTEGER: {
                return BigInteger.valueOf(((Number)this.value).longValue());
            }
            case BIG_INTEGER: {
                return (BigInteger)this.value;
            }
            case CHARACTER: {
                return BigInteger.valueOf(((Character)this.value).charValue());
            }
        }
        throw new IllegalStateException("Not a big integer " + (Object)((Object)this.kind));
    }

    public double doubleValue() {
        switch (this.kind) {
            case INTEGER: 
            case BIG_INTEGER: 
            case DOUBLE: {
                return ((Number)this.value).doubleValue();
            }
            case CHARACTER: {
                return ((Character)this.value).charValue();
            }
        }
        throw new IllegalStateException("Not a number " + (Object)((Object)this.kind));
    }

    public Reference refValue() {
        switch (this.kind) {
            case REFERENCE: {
                return (Reference)this.value;
            }
        }
        throw new IllegalStateException("Not a reference " + (Object)((Object)this.kind));
    }

    public String stringValue() {
        switch (this.kind) {
            case STRING: {
                return (String)this.value;
            }
        }
        throw new IllegalStateException("Not a string " + (Object)((Object)this.kind));
    }

    public boolean isTrue() {
        switch (this.kind) {
            case INTEGER: {
                return 0L != ((Number)this.value).longValue();
            }
            case BIG_INTEGER: {
                return 0 != ((BigInteger)this.value).signum();
            }
            case DOUBLE: {
                return 0.0 != ((Number)this.value).doubleValue();
            }
            case CHARACTER: {
                return '\u0000' != ((Character)this.value).charValue();
            }
            case STRING: {
                return true;
            }
            case REFERENCE: {
                return !((Reference)this.value).isNull();
            }
        }
        throw new AssertionError((Object)("Invalid kind " + (Object)((Object)this.kind)));
    }

    public boolean isNull() {
        switch (this.kind) {
            case INTEGER: {
                return 0L == ((Number)this.value).longValue();
            }
            case BIG_INTEGER: {
                return 0 == ((BigInteger)this.value).signum();
            }
            case DOUBLE: {
                return 0.0 == ((Number)this.value).doubleValue();
            }
            case CHARACTER: {
                return '\u0000' == ((Character)this.value).charValue();
            }
            case STRING: {
                return false;
            }
            case REFERENCE: {
                return ((Reference)this.value).isNull();
            }
        }
        throw new AssertionError((Object)("Invalid kind " + (Object)((Object)this.kind)));
    }

    public static enum Kind {
        INTEGER,
        BIG_INTEGER,
        DOUBLE,
        CHARACTER,
        STRING,
        REFERENCE;

    }
}

