/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import xtc.Constants;
import xtc.type.C;
import xtc.type.FunctionT;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.util.SymbolTable;

public class CFactory {
    private static final Type CONST_VOID = VoidT.TYPE.annotate().attribute(Constants.ATT_CONSTANT).seal();
    private static final Type CONST_CHAR = NumberT.CHAR.annotate().attribute(Constants.ATT_CONSTANT).seal();
    private static final Type PTR_2_VOID = new PointerT(VoidT.TYPE).seal();
    private static final Type PTR_2_CONST_VOID = new PointerT(CONST_VOID).seal();
    private static final Type PTR_2_CHAR = new PointerT(NumberT.CHAR).seal();
    private static final Type PTR_2_CONST_CHAR = new PointerT(CONST_CHAR).seal();
    private String prefix;
    private SymbolTable.Scope scope;

    public CFactory(String prefix, SymbolTable.Scope scope) {
        this.prefix = prefix;
        this.scope = scope;
    }

    public Type v() {
        return VoidT.TYPE;
    }

    public Type cv() {
        return CONST_VOID;
    }

    public Type c() {
        return NumberT.CHAR;
    }

    public Type cc() {
        return CONST_CHAR;
    }

    public Type i() {
        return NumberT.INT;
    }

    public Type size() {
        return C.SIZEOF;
    }

    public PointerT p(Type type) {
        return new PointerT(type);
    }

    public Type pr(Type type) {
        return new PointerT(type).annotate().attribute(Constants.ATT_RESTRICT);
    }

    public Type p2v() {
        return PointerT.TO_VOID;
    }

    public Type p2cv() {
        return PTR_2_CONST_VOID;
    }

    public Type p2c() {
        return PTR_2_CHAR;
    }

    public Type p2cc() {
        return PTR_2_CONST_CHAR;
    }

    public Type f() {
        return this.f(this.v());
    }

    public Type f(Type result) {
        return new FunctionT(result, new ArrayList<Type>(0), false).attribute(Constants.ATT_STYLE_NEW);
    }

    public Type f(Type result, Type param) {
        ArrayList<Type> params = new ArrayList<Type>(1);
        params.add(param);
        FunctionT function = new FunctionT(result, params, false);
        function.addAttribute(Constants.ATT_STYLE_NEW);
        return function;
    }

    public Type f(Type result, Type param1, Type param2) {
        ArrayList<Type> params = new ArrayList<Type>(2);
        params.add(param1);
        params.add(param2);
        FunctionT function = new FunctionT(result, params, false);
        function.addAttribute(Constants.ATT_STYLE_NEW);
        return function;
    }

    public Type f(Type result, Type param1, Type param2, Type param3) {
        ArrayList<Type> params = new ArrayList<Type>(3);
        params.add(param1);
        params.add(param2);
        params.add(param3);
        FunctionT function = new FunctionT(result, params, false);
        function.addAttribute(Constants.ATT_STYLE_NEW);
        return function;
    }

    public Type f(Type result, Type param1, Type param2, Type param3, Type param4) {
        ArrayList<Type> params = new ArrayList<Type>(4);
        params.add(param1);
        params.add(param2);
        params.add(param3);
        params.add(param4);
        FunctionT function = new FunctionT(result, params, false);
        function.addAttribute(Constants.ATT_STYLE_NEW);
        return function;
    }

    public Type constant(Type type) {
        return type.attribute(Constants.ATT_CONSTANT);
    }

    public Type builtin(Type type) {
        return type.attribute(Constants.ATT_BUILTIN);
    }

    public CFactory decl(boolean nofix, String name, Type type) {
        if (nofix) {
            this.scope.define(name, this.builtin(type));
        }
        this.scope.define(this.prefix + name, this.builtin(type));
        return this;
    }

    public void declareBuiltIns(boolean nofix) {
        this.decl(nofix, "calloc", this.f(this.p2v(), this.size(), this.size()));
        this.decl(nofix, "free", this.f(this.v(), this.p2v()));
        this.decl(nofix, "malloc", this.f(this.p2v(), this.size()));
        this.decl(nofix, "realloc", this.f(this.p2v(), this.p2v(), this.size()));
        this.decl(nofix, "abort", this.f());
        this.decl(nofix, "atexit", this.f(this.i(), this.p(this.f())));
        this.decl(nofix, "exit", this.f(this.v(), this.i()));
        this.decl(nofix, "_Exit", this.f(this.v(), this.i()));
        this.decl(nofix, "getenv", this.f(this.p2c(), this.p(this.cc())));
        this.decl(nofix, "system", this.f(this.i(), this.p(this.cc())));
        this.decl(nofix, "memcpy", this.f(this.p2v(), this.pr(this.v()), this.pr(this.cv()), this.size()));
        this.decl(nofix, "memset", this.f(this.p2v(), this.p2v(), this.i(), this.size()));
        this.decl(nofix, "stpcpy", this.f(this.p2c(), this.p2c(), this.p(this.cc())));
        this.decl(nofix, "__memcpy_chk", this.f(this.p2v(), this.p2v(), this.p2cv(), this.size(), this.size()));
        this.decl(nofix, "__memmove_chk", this.f(this.p2v(), this.p2v(), this.p2cv(), this.size(), this.size()));
        this.decl(nofix, "__memset_chk", this.f(this.p2v(), this.p2v(), this.i(), this.size(), this.size()));
        this.decl(nofix, "__strcpy_chk", this.f(this.p2c(), this.pr(this.c()), this.pr(this.cc()), this.size()));
        this.decl(nofix, "__stpcpy_chk", this.f(this.p2c(), this.p2c(), this.p2cc(), this.size()));
        this.decl(nofix, "__strncpy_chk", this.f(this.p2c(), this.pr(this.c()), this.pr(this.cc()), this.size(), this.size()));
        this.decl(nofix, "__strcat_chk", this.f(this.p2c(), this.pr(this.c()), this.pr(this.cc()), this.size()));
        this.decl(nofix, "__strncat_chk", this.f(this.p2c(), this.pr(this.c()), this.pr(this.cc()), this.size(), this.size()));
    }
}

