/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.Limits;
import xtc.tree.Attribute;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.Constant;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.FloatT;
import xtc.type.FunctionT;
import xtc.type.IntegerT;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.Reference;
import xtc.type.StructOrUnionT;
import xtc.type.StructT;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.util.Utilities;

public class C {
    public static final boolean GCC_LEGACY_LAYOUT;
    public static final IntegerT IMPLICIT;
    protected static final NumberT.Kind KIND_SIZEOF;
    public static final IntegerT SIZEOF;
    protected static final NumberT.Kind KIND_PTR_DIFF;
    public static final IntegerT PTR_DIFF;
    protected static final NumberT.Kind KIND_WCHAR;
    public static final IntegerT WCHAR;
    private Boolean threadlocal = null;
    private static final Attribute PACKED;
    protected final BigInteger FACTOR_CHAR = BigInteger.valueOf(2L).pow(8);
    protected final BigInteger FACTOR_WIDE = BigInteger.valueOf(2L).pow(32);
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isChar(Type type) {
        if (type.hasEnum()) {
            return false;
        }
        if ((type = type.resolve()).isInteger()) {
            switch (type.toInteger().getKind()) {
                case CHAR: 
                case S_CHAR: 
                case U_CHAR: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isWideChar(Type type) {
        if (type.hasEnum()) {
            return false;
        }
        if ((type = type.resolve()).isInteger()) {
            return NumberT.equal(KIND_WCHAR, type.toInteger().getKind());
        }
        return false;
    }

    public boolean isString(Type type) {
        return (type = type.resolve()).isArray() && this.isChar(type.toArray().getType());
    }

    public boolean isWideString(Type type) {
        return (type = type.resolve()).isArray() && this.isWideChar(type.toArray().getType());
    }

    public boolean isStringLiteral(Type type) {
        return (this.isString(type) || this.isWideString(type)) && type.hasConstant();
    }

    public boolean isIntegral(Type type) {
        switch (type.tag()) {
            case BOOLEAN: 
            case INTEGER: {
                return true;
            }
        }
        return false;
    }

    public boolean isReal(Type type) {
        switch (type.tag()) {
            case BOOLEAN: 
            case INTEGER: {
                return true;
            }
            case FLOAT: {
                switch (type.resolve().toFloat().getKind()) {
                    case FLOAT_COMPLEX: 
                    case DOUBLE_COMPLEX: 
                    case LONG_DOUBLE_COMPLEX: {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isArithmetic(Type type) {
        switch (type.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public boolean isScalar(Type type) {
        switch (type.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case POINTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isIncomplete(Type type) {
        while (type.isWrapped()) {
            switch (type.wtag()) {
                case ALIAS: {
                    return null == type.toAlias().getType();
                }
                case ENUM: {
                    return null == type.toEnum().getMembers();
                }
            }
            type = type.toWrapped().getType();
        }
        switch (type.tag()) {
            case VOID: {
                return true;
            }
            case ARRAY: {
                ArrayT a = type.toArray();
                return !a.isVarLength() && !a.hasLength() || this.isIncomplete(a.getType()) || this.hasTrailingArray(a.getType());
            }
            case STRUCT: {
                List<VariableT> members = type.toStruct().getMembers();
                if (null == members) {
                    return true;
                }
                Iterator<VariableT> iter = members.iterator();
                while (iter.hasNext()) {
                    ArrayT array;
                    VariableT variableT = iter.next();
                    if (!(iter.hasNext() || Type.Tag.ARRAY != variableT.tag() ? this.isIncomplete(variableT) : this.isIncomplete((array = variableT.resolve().toArray()).getType()))) continue;
                    return true;
                }
                return false;
            }
            case UNION: {
                List<VariableT> members = type.toUnion().getMembers();
                if (null == members) {
                    return true;
                }
                for (Type type2 : members) {
                    if (!this.isIncomplete(type2)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean hasTrailingArray(Type type) {
        switch (type.tag()) {
            case STRUCT: {
                List<VariableT> members = type.resolve().toStruct().getMembers();
                if (null != members) {
                    VariableT variableT;
                    int size = members.size();
                    VariableT variableT2 = variableT = 0 < size ? members.get(size - 1) : null;
                    if (null != variableT && Type.Tag.ARRAY == ((Type)variableT).tag()) {
                        ArrayT a = ((Type)variableT).resolve().toArray();
                        return !a.isVarLength() && !a.hasLength();
                    }
                }
                return false;
            }
            case UNION: {
                List<VariableT> members = type.resolve().toUnion().getMembers();
                if (null != members) {
                    for (Type type2 : members) {
                        if (!this.hasTrailingArray(type2)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isVariablyModified(Type type) {
        switch (type.tag()) {
            case POINTER: {
                return this.isVariablyModified(type.resolve().toPointer().getType());
            }
            case ARRAY: {
                ArrayT a = type.resolve().toArray();
                return a.isVarLength() || this.isVariablyModified(a.getType());
            }
        }
        return false;
    }

    public boolean isConstant(Type type) {
        if (type.hasAttribute(Constants.ATT_CONSTANT)) {
            return true;
        }
        switch (type.tag()) {
            case ARRAY: {
                type = type.resolve().toArray().getType();
                return null == type ? false : this.isConstant(type);
            }
            case STRUCT: 
            case UNION: {
                for (Type type2 : type.toTagged().getMembers()) {
                    if (!this.isConstant(type2)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isModifiable(Type type) {
        if (!type.hasShape()) {
            return false;
        }
        if (this.isIncomplete(type)) {
            return false;
        }
        if (Type.Tag.ARRAY == type.tag()) {
            return false;
        }
        return !this.isConstant(type);
    }

    public boolean hasConstRef(Type type) {
        if (type.hasConstant() && type.getConstant().isReference()) {
            return true;
        }
        switch (type.tag()) {
            case ARRAY: 
            case FUNCTION: {
                return type.hasShape() && type.getShape().isConstant();
            }
        }
        return false;
    }

    public Reference getConstRef(Type type) {
        if (type.hasConstant()) {
            Constant constant = type.getConstant();
            if (!constant.isReference()) {
                throw new IllegalArgumentException("Constant not a reference " + type);
            }
            return constant.refValue();
        }
        switch (type.tag()) {
            case ARRAY: 
            case FUNCTION: {
                if (!type.hasShape()) break;
                Reference ref = type.getShape();
                if (!ref.isConstant()) {
                    throw new IllegalArgumentException("Shaped not constant " + type);
                }
                return ref;
            }
        }
        throw new IllegalArgumentException("Type without constant reference " + type);
    }

    public boolean hasQualifiers(Type type) {
        return type.hasAttribute(Constants.ATT_CONSTANT) || type.hasAttribute(Constants.ATT_RESTRICT) || type.hasAttribute(Constants.ATT_VOLATILE);
    }

    public boolean hasQualifiers(Type type, Type template) {
        if (template.hasAttribute(Constants.ATT_CONSTANT) && !type.hasAttribute(Constants.ATT_CONSTANT)) {
            return false;
        }
        if (template.hasAttribute(Constants.ATT_RESTRICT) && !type.hasAttribute(Constants.ATT_RESTRICT)) {
            return false;
        }
        return !template.hasAttribute(Constants.ATT_VOLATILE) || type.hasAttribute(Constants.ATT_VOLATILE);
    }

    public boolean hasSameQualifiers(Type type, Type template) {
        return type.hasAttribute(Constants.ATT_CONSTANT) == template.hasAttribute(Constants.ATT_CONSTANT) && type.hasAttribute(Constants.ATT_RESTRICT) == template.hasAttribute(Constants.ATT_RESTRICT) && type.hasAttribute(Constants.ATT_VOLATILE) == template.hasAttribute(Constants.ATT_VOLATILE);
    }

    public Type qualify(Type type, Type template) {
        if (!this.hasQualifiers(template)) {
            return type;
        }
        type = type.annotate();
        if (template.hasAttribute(Constants.ATT_CONSTANT)) {
            type = type.attribute(Constants.ATT_CONSTANT);
        }
        if (template.hasAttribute(Constants.ATT_RESTRICT)) {
            type = type.attribute(Constants.ATT_RESTRICT);
        }
        if (template.hasAttribute(Constants.ATT_VOLATILE)) {
            type = type.attribute(Constants.ATT_VOLATILE);
        }
        return type;
    }

    public Type reattribute(Type type, Type template) {
        boolean annotated = false;
        do {
            if (!template.hasAttributes()) continue;
            for (Attribute att : template.attributes()) {
                if (!"gcc".equals(att.getName()) || type.hasAttribute(att)) continue;
                if (!annotated) {
                    type = type.annotate();
                    annotated = true;
                }
                type.addAttribute(att);
            }
        } while (null != (template = template.isWrapped() ? template.toWrapped().getType() : null));
        return type;
    }

    public Type toRValue(Type type) {
        Type result;
        if (!type.hasShape()) {
            return type;
        }
        Type type2 = result = type.hasEnum() ? type.toEnum() : type.resolve();
        if (this.hasQualifiers(type) || type.hasConstant()) {
            result = this.qualify(result.annotate(), type);
            if (type.hasConstant()) {
                result = result.constant(type.getConstant().getValue());
            }
        }
        return result;
    }

    public boolean hasThreadLocals() {
        if (null == this.threadlocal) {
            this.threadlocal = Boolean.FALSE;
        }
        return this.threadlocal;
    }

    public long getAlignment(Type type) {
        return this.getAlignment(type, true);
    }

    public long getAlignment(Type type, boolean natural) {
        Type resolved = type.resolve();
        if (resolved.isStruct() || resolved.isUnion()) {
            if (this.isPacked(type)) {
                return 1L;
            }
            long alignment = Math.max(1L, this.getAligned(type));
            for (Type type2 : type.toTagged().getMembers()) {
                if (0 == type2.toVariable().getWidth()) continue;
                alignment = Math.max(alignment, this.getAlignment(type2, false));
            }
            return alignment;
        }
        long alignment = this.getAligned(type);
        if (-1L != alignment) {
            return alignment;
        }
        switch (type.tag()) {
            case VOID: {
                return 1L;
            }
            case BOOLEAN: {
                return natural ? 1L : 1L;
            }
            case INTEGER: 
            case FLOAT: {
                switch (type.resolve().toNumber().getKind()) {
                    case CHAR: 
                    case S_CHAR: 
                    case U_CHAR: {
                        return 1L;
                    }
                    case SHORT: 
                    case U_SHORT: {
                        return natural ? 2L : 2L;
                    }
                    case INT: 
                    case S_INT: 
                    case U_INT: {
                        return natural ? 4L : 4L;
                    }
                    case LONG: 
                    case U_LONG: {
                        return natural ? 8L : 8L;
                    }
                    case LONG_LONG: 
                    case U_LONG_LONG: {
                        return natural ? 8L : 8L;
                    }
                    case FLOAT: {
                        return natural ? 4L : 4L;
                    }
                    case DOUBLE: {
                        return natural ? 8L : 8L;
                    }
                    case LONG_DOUBLE: {
                        return natural ? 16L : 16L;
                    }
                    case FLOAT_COMPLEX: {
                        return natural ? 4L : 4L;
                    }
                    case DOUBLE_COMPLEX: {
                        return natural ? 8L : 8L;
                    }
                    case LONG_DOUBLE_COMPLEX: {
                        return natural ? 16L : 16L;
                    }
                }
                throw new AssertionError((Object)("Invalid number kind " + (Object)((Object)type.toNumber().getKind())));
            }
            case POINTER: {
                return natural ? 8L : 8L;
            }
            case ARRAY: {
                return this.getAlignment(type.resolve().toArray().getType(), natural);
            }
            case FUNCTION: {
                return 1L;
            }
        }
        throw new IllegalArgumentException("Type without alignment " + type);
    }

    public long getSize(Type type) {
        switch (type.tag()) {
            case VOID: {
                return 1L;
            }
            case BOOLEAN: {
                return 1L;
            }
            case INTEGER: 
            case FLOAT: {
                switch (type.resolve().toNumber().getKind()) {
                    case CHAR: 
                    case S_CHAR: 
                    case U_CHAR: {
                        return 1L;
                    }
                    case SHORT: 
                    case U_SHORT: {
                        return 2L;
                    }
                    case INT: 
                    case S_INT: 
                    case U_INT: {
                        return 4L;
                    }
                    case LONG: 
                    case U_LONG: {
                        return 8L;
                    }
                    case LONG_LONG: 
                    case U_LONG_LONG: {
                        return 8L;
                    }
                    case FLOAT: {
                        return 4L;
                    }
                    case DOUBLE: {
                        return 8L;
                    }
                    case LONG_DOUBLE: {
                        return 16L;
                    }
                    case FLOAT_COMPLEX: {
                        return 8L;
                    }
                    case DOUBLE_COMPLEX: {
                        return 16L;
                    }
                    case LONG_DOUBLE_COMPLEX: {
                        return 32L;
                    }
                }
                throw new AssertionError((Object)("Invalid number kind " + (Object)((Object)type.toNumber().getKind())));
            }
            case POINTER: {
                return 8L;
            }
            case ARRAY: {
                ArrayT array = type.resolve().toArray();
                if (array.hasLength()) {
                    return this.getSize(array.getType()) * array.getLength();
                }
                throw new IllegalArgumentException("Array without size");
            }
            case STRUCT: {
                return this.layout(type.resolve().toStruct(), null);
            }
            case UNION: {
                long size = 0L;
                for (Type type2 : type.toTagged().getMembers()) {
                    size = Math.max(size, this.getSize(type2));
                }
                return size;
            }
            case FUNCTION: {
                return 1L;
            }
        }
        throw new IllegalArgumentException("Type without size " + type);
    }

    public long getOffset(StructOrUnionT type, String name) {
        if (type.isStruct()) {
            return this.layout(type.toStruct(), name);
        }
        for (VariableT var : type.getMembers()) {
            long offset;
            if (var.hasName(name)) {
                return 0L;
            }
            if (var.hasName() || var.hasWidth() || -1L == (offset = this.getOffset(var.toStructOrUnion(), name))) continue;
            return offset;
        }
        return -1L;
    }

    public long layout(StructT type, String name) {
        List<VariableT> members = type.getMembers();
        int memberCount = members.size();
        boolean hasTrailing = this.hasTrailingArray(type);
        boolean isPacked = this.isPacked(type);
        long size = 0L;
        long bitCount = 0L;
        long bitSize = 0L;
        long bitAlign = 1L;
        long maxAlign = Math.max(1L, this.getAligned(type));
        for (int i = 0; !(i >= memberCount || hasTrailing && i == memberCount - 1); ++i) {
            long mod;
            long align;
            VariableT var = members.get(i);
            boolean isLastMember = i == memberCount - 1 || hasTrailing && i == memberCount - 2;
            long varAlign = this.getAlignment(var, false);
            long l = align = isPacked ? 1L : varAlign;
            if (0 != var.getWidth()) {
                maxAlign = Math.max(align, maxAlign);
            }
            if (!var.hasKind(VariableT.Kind.BITFIELD)) {
                long mod2 = size % align;
                if (0L != mod2) {
                    size += align - mod2;
                }
                if (null != name) {
                    long offset;
                    if (var.hasName(name)) {
                        return size;
                    }
                    if (!var.hasName() && -1L != (offset = this.getOffset(var.toStructOrUnion(), name))) {
                        return size + offset;
                    }
                }
                size += this.getSize(var);
                continue;
            }
            int width = var.getWidth();
            if (!$assertionsDisabled && -1 >= width) {
                throw new AssertionError();
            }
            if (isPacked && (GCC_LEGACY_LAYOUT || 0 != width)) {
                bitCount += (long)width;
                if (!isLastMember && -1 != members.get(i + 1).getWidth()) continue;
                size += bitCount / 8L;
                if (0L != bitCount % 8L) {
                    ++size;
                }
                bitCount = 0L;
                bitSize = 0L;
                bitAlign = 1L;
                continue;
            }
            if (0 == width) {
                size += bitCount / 8L;
                if (0L != bitCount % 8L) {
                    ++size;
                }
                if (0L != (mod = size % varAlign)) {
                    size += varAlign - mod;
                }
                bitCount = 0L;
                bitSize = 0L;
                bitAlign = 1L;
                continue;
            }
            if (0L == bitSize) {
                bitCount = width;
                bitSize = this.getSize(var);
                bitAlign = varAlign;
            } else if (bitCount + (long)width <= Limits.toWidth(bitSize)) {
                bitCount += (long)width;
            } else {
                mod = (size += bitSize) % bitAlign;
                if (0L != mod) {
                    size += bitAlign - mod;
                }
                bitCount = width;
                bitSize = this.getSize(var);
                bitAlign = varAlign;
            }
            if (!isLastMember && -1 != members.get(i + 1).getWidth()) continue;
            size += bitCount / 8L;
            if (0L != bitCount % 8L) {
                ++size;
            }
            bitCount = 0L;
            bitSize = 0L;
            bitAlign = 1L;
        }
        if (null != name) {
            return -1L;
        }
        long mod = size % maxAlign;
        if (0L != mod) {
            size += maxAlign - mod;
        }
        return size;
    }

    protected boolean isPacked(Type type) {
        return type.hasAttribute(PACKED);
    }

    protected long getAligned(Type type) {
        long alignment = -1L;
        while (true) {
            for (Attribute att : type.attributes()) {
                if (!"gcc".equals(att.getName()) || !"aligned".equals((att = (Attribute)att.getValue()).getName())) continue;
                if (null == att.getValue()) {
                    alignment = Math.max(8, 16);
                    continue;
                }
                alignment = ((BigInteger)att.getValue()).longValue();
            }
            if (!type.isWrapped()) break;
            type = type.toWrapped().getType();
        }
        return alignment;
    }

    public long getWidth(Type number) {
        switch (number.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                return this.getSize(number) * 8L;
            }
        }
        throw new AssertionError((Object)("Not a C number " + number));
    }

    public Type fit(BigInteger number) {
        if (Limits.fitsInt(number)) {
            return NumberT.INT;
        }
        if (Limits.fitsUnsignedInt(number)) {
            return NumberT.U_INT;
        }
        if (Limits.fitsLong(number)) {
            return NumberT.LONG;
        }
        if (Limits.fitsUnsignedLong(number)) {
            return NumberT.U_LONG;
        }
        if (Limits.fitsLongLong(number)) {
            return NumberT.LONG_LONG;
        }
        if (Limits.fitsUnsignedLongLong(number)) {
            return NumberT.U_LONG_LONG;
        }
        return ErrorT.TYPE;
    }

    public boolean fits(BigInteger number, Type type) {
        switch (type.tag()) {
            case BOOLEAN: {
                return Limits.fitsUnsignedChar(number);
            }
            case INTEGER: {
                switch (type.resolve().toInteger().getKind()) {
                    case CHAR: {
                        return Limits.fitsChar(number);
                    }
                    case S_CHAR: {
                        return Limits.fitsChar(number);
                    }
                    case U_CHAR: {
                        return Limits.fitsUnsignedChar(number);
                    }
                    case SHORT: {
                        return Limits.fitsShort(number);
                    }
                    case U_SHORT: {
                        return Limits.fitsUnsignedShort(number);
                    }
                    case INT: 
                    case S_INT: {
                        return Limits.fitsInt(number);
                    }
                    case U_INT: {
                        return Limits.fitsUnsignedInt(number);
                    }
                    case LONG: {
                        return Limits.fitsLong(number);
                    }
                    case U_LONG: {
                        return Limits.fitsUnsignedLong(number);
                    }
                    case LONG_LONG: {
                        return Limits.fitsLongLong(number);
                    }
                    case U_LONG_LONG: {
                        return Limits.fitsUnsignedLongLong(number);
                    }
                }
            }
        }
        throw new AssertionError((Object)("Not a C integer " + type));
    }

    public BigInteger mask(BigInteger number, Type type) {
        switch (type.tag()) {
            case BOOLEAN: {
                return 0 != number.signum() ? BigInteger.ONE : BigInteger.ZERO;
            }
            case INTEGER: {
                switch (type.resolve().toInteger().getKind()) {
                    case CHAR: {
                        return Limits.maskAsSignedChar(number);
                    }
                    case S_CHAR: {
                        return Limits.maskAsSignedChar(number);
                    }
                    case U_CHAR: {
                        return Limits.maskAsUnsignedChar(number);
                    }
                    case SHORT: {
                        return Limits.maskAsShort(number);
                    }
                    case U_SHORT: {
                        return Limits.maskAsUnsignedShort(number);
                    }
                    case INT: 
                    case S_INT: {
                        return Limits.maskAsInt(number);
                    }
                    case U_INT: {
                        return Limits.maskAsUnsignedInt(number);
                    }
                    case LONG: {
                        return Limits.maskAsLong(number);
                    }
                    case U_LONG: {
                        return Limits.maskAsUnsignedLong(number);
                    }
                    case LONG_LONG: {
                        return Limits.maskAsLongLong(number);
                    }
                    case U_LONG_LONG: {
                        return Limits.maskAsUnsignedLongLong(number);
                    }
                }
            }
        }
        throw new AssertionError((Object)("Not a C integer " + type));
    }

    public String toDesignation(Type type) {
        switch (type.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case POINTER: {
                return "scalar";
            }
            case ARRAY: {
                return "array";
            }
            case STRUCT: {
                return "struct";
            }
            case UNION: {
                return "union";
            }
            case FUNCTION: {
                return "function";
            }
            case INTERNAL: {
                return type.resolve().toInternal().getName();
            }
        }
        throw new AssertionError((Object)("Not a C type " + type));
    }

    public Type promote(Type type) {
        boolean flip = false;
        type = type.resolve();
        switch (type.tag()) {
            case BOOLEAN: {
                return NumberT.INT;
            }
            case INTEGER: {
                switch (type.toInteger().getKind()) {
                    case CHAR: 
                    case S_CHAR: 
                    case U_CHAR: 
                    case SHORT: {
                        return NumberT.INT;
                    }
                    case U_SHORT: {
                        return NumberT.INT;
                    }
                    case INT: {
                        return flip ? NumberT.U_INT : NumberT.INT;
                    }
                    case S_INT: {
                        return NumberT.INT;
                    }
                    case U_INT: 
                    case LONG: 
                    case U_LONG: 
                    case LONG_LONG: 
                    case U_LONG_LONG: {
                        return type;
                    }
                }
                throw new AssertionError((Object)("Not a C integer " + type));
            }
        }
        return type;
    }

    public Type promoteArgument(Type type) {
        Type resolved = type.resolve();
        if (resolved.isFloat()) {
            if (NumberT.Kind.FLOAT == resolved.toFloat().getKind()) {
                return NumberT.DOUBLE;
            }
            return resolved;
        }
        return this.promote(type);
    }

    public Type pointerize(Type type) {
        type = type.resolve();
        switch (type.tag()) {
            case ARRAY: {
                return new PointerT(type.toArray().getType());
            }
            case FUNCTION: {
                return new PointerT(type);
            }
        }
        return type;
    }

    public Type convert(Type t1, Type t2) {
        if (!this.isArithmetic(t1) || t1.hasError()) {
            throw new IllegalArgumentException("Not an arithmetic type " + t1);
        }
        if (!this.isArithmetic(t2) || t2.hasError()) {
            throw new IllegalArgumentException("Not an arithmetic type " + t2);
        }
        t1 = this.promote(t1);
        t2 = this.promote(t2);
        NumberT.Kind k1 = ((NumberT)t1).getKind();
        NumberT.Kind k2 = ((NumberT)t2).getKind();
        if (!this.isReal(t1) || !this.isReal(t2)) {
            if (NumberT.Kind.LONG_DOUBLE_COMPLEX == k1 || NumberT.Kind.LONG_DOUBLE_COMPLEX == k2) {
                return NumberT.LONG_DOUBLE_COMPLEX;
            }
            if (NumberT.Kind.DOUBLE_COMPLEX == k1 || NumberT.Kind.DOUBLE_COMPLEX == k2) {
                return NumberT.DOUBLE_COMPLEX;
            }
            if (NumberT.Kind.FLOAT_COMPLEX == k1 || NumberT.Kind.FLOAT_COMPLEX == k2) {
                return NumberT.FLOAT_COMPLEX;
            }
        }
        if (NumberT.Kind.LONG_DOUBLE == k1 || NumberT.Kind.LONG_DOUBLE == k2) {
            return NumberT.LONG_DOUBLE;
        }
        if (NumberT.Kind.DOUBLE == k1 || NumberT.Kind.DOUBLE == k2) {
            return NumberT.DOUBLE;
        }
        if (NumberT.Kind.FLOAT == k1 || NumberT.Kind.FLOAT == k2) {
            return NumberT.FLOAT;
        }
        IntegerT i1 = t1.toInteger();
        IntegerT i2 = t2.toInteger();
        if (k1 == k2) {
            return i1;
        }
        if (i1.isSigned() == i2.isSigned()) {
            return k1.ordinal() < k2.ordinal() ? i2 : i1;
        }
        if (!i1.isSigned()) {
            if (k1.ordinal() > k2.ordinal()) {
                return i1;
            }
        } else if (k2.ordinal() > k1.ordinal()) {
            return i2;
        }
        if (i1.isSigned()) {
            if (this.getSize(i1) > this.getSize(i2)) {
                return i1;
            }
        } else if (this.getSize(i2) > this.getSize(i1)) {
            return i2;
        }
        if (i1.isSigned()) {
            if (NumberT.Kind.INT == k1) {
                return NumberT.U_INT;
            }
            if (NumberT.Kind.LONG == k1) {
                return NumberT.U_LONG;
            }
            return NumberT.U_LONG_LONG;
        }
        if (NumberT.Kind.INT == k2) {
            return NumberT.U_INT;
        }
        if (NumberT.Kind.LONG == k2) {
            return NumberT.U_LONG;
        }
        return NumberT.U_LONG_LONG;
    }

    public Type compose(Type t1, Type t2, boolean pedantic) {
        return this.compose(t1, t2, pedantic, true);
    }

    protected Type compose(Type t1, Type t2, boolean pedantic, boolean recursive) {
        if (recursive) {
            if (t1.isEnum()) {
                return t1.equals(t2) ? t1 : ErrorT.TYPE;
            }
            if (t1.isWrapped()) {
                Type w1 = t1.toWrapped().getType();
                Type c = this.compose(w1, t2, pedantic, true);
                if (c.isError()) {
                    return ErrorT.TYPE;
                }
                if (w1 == c) {
                    return t1;
                }
                switch (t1.wtag()) {
                    case ALIAS: {
                        return new AliasT(t1, t1.toAlias().getName(), c);
                    }
                    case ANNOTATED: {
                        return new AnnotatedT(t1, c);
                    }
                    case ENUMERATOR: {
                        EnumeratorT e = t1.toEnumerator();
                        return new EnumeratorT(t1, c, e.getName(), e.getValue());
                    }
                    case VARIABLE: {
                        VariableT v = t1.toVariable();
                        return v.hasWidth() ? new VariableT(t1, c, v.getName(), v.getWidth()) : new VariableT(t1, c, v.getKind(), v.getName());
                    }
                }
                throw new AssertionError((Object)("Invalid type " + t1));
            }
        } else {
            while (t1.isWrapped()) {
                if (t1.isEnum()) {
                    return t1.equals(t2) ? t1 : ErrorT.TYPE;
                }
                t1 = t1.toWrapped().getType();
            }
        }
        if (t1 == (t2 = t2.resolve())) {
            return t1;
        }
        if (t1.tag() != t2.tag()) {
            return ErrorT.TYPE;
        }
        switch (t1.tag()) {
            case ERROR: {
                return ErrorT.TYPE;
            }
            case BOOLEAN: 
            case VOID: {
                return t1;
            }
            case INTEGER: 
            case FLOAT: {
                return NumberT.equal(t1.toNumber().getKind(), t2.toNumber().getKind()) ? t1 : ErrorT.TYPE;
            }
            case INTERNAL: {
                return t1.toInternal().getName().equals(t2.toInternal().getName()) ? t1 : ErrorT.TYPE;
            }
            case LABEL: {
                return t1.toLabel().getName().equals(t2.toLabel().getName()) ? t1 : ErrorT.TYPE;
            }
            case STRUCT: 
            case UNION: {
                return t1 == t2 ? t1 : ErrorT.TYPE;
            }
            case POINTER: {
                Type pt1 = t1.toPointer().getType();
                Type pt2 = t2.toPointer().getType();
                if (!this.hasSameQualifiers(pt1, pt2)) {
                    return ErrorT.TYPE;
                }
                Type ptc = this.compose(pt1, pt2, pedantic, true);
                if (ptc.isError()) {
                    return ErrorT.TYPE;
                }
                return pt1 == ptc ? t1 : new PointerT(t1, ptc);
            }
            case ARRAY: {
                return this.composeArrays(t1.toArray(), t2.toArray());
            }
            case FUNCTION: {
                return this.composeFunctions(t1.toFunction(), t2.toFunction(), pedantic);
            }
        }
        throw new AssertionError((Object)("Not a C type " + t1));
    }

    protected Type composeArrays(ArrayT a1, ArrayT a2) {
        if (!this.hasSameQualifiers(a1.getType(), a2.getType())) {
            return ErrorT.TYPE;
        }
        Type el = this.compose(a1.getType(), a2.getType(), true);
        if (el.isError()) {
            return ErrorT.TYPE;
        }
        if (a1.isVarLength()) {
            if (el == a1.getType()) {
                return a1;
            }
            return new ArrayT(a1, el, a1.isVarLength(), a1.getLength());
        }
        if (a2.isVarLength()) {
            if (el == a2.getType()) {
                return a2;
            }
            return new ArrayT(a2, el, a2.isVarLength(), a2.getLength());
        }
        if (a1.hasLength() && a2.hasLength()) {
            if (a1.getLength() == a2.getLength()) {
                if (el == a1.getType()) {
                    return a1;
                }
                return new ArrayT(a1, el, a1.isVarLength(), a1.getLength());
            }
            return ErrorT.TYPE;
        }
        if (a1.hasLength()) {
            if (el == a1.getType()) {
                return a1;
            }
            return new ArrayT(a1, el, a1.isVarLength(), a1.getLength());
        }
        if (a2.hasLength()) {
            if (el == a1.getType()) {
                return a2;
            }
            return new ArrayT(a2, el, a2.isVarLength(), a2.getLength());
        }
        return el == a1.getType() ? a1 : new ArrayT(a1, el, a1.isVarLength(), a1.getLength());
    }

    protected Type composeFunctions(FunctionT f1, FunctionT f2, boolean pedantic) {
        if (null == f1.getName() ? null != f2.getName() : !f1.getName().equals(f2.getName())) {
            return ErrorT.TYPE;
        }
        boolean differs = false;
        if (!this.hasSameQualifiers(f1.getResult(), f2.getResult())) {
            return ErrorT.TYPE;
        }
        Type res = this.compose(f1.getResult(), f2.getResult(), true);
        if (res.isError()) {
            return ErrorT.TYPE;
        }
        if (f1.getResult() != res) {
            differs = true;
        }
        if (f1.hasAttribute(Constants.ATT_STYLE_OLD)) {
            if (f2.hasAttribute(Constants.ATT_STYLE_OLD)) {
                if (f1.hasAttribute(Constants.ATT_DEFINED) || !f2.hasAttribute(Constants.ATT_DEFINED)) {
                    return differs ? new FunctionT(f1, res, f1.getParameters(), f1.isVarArgs()) : f1;
                }
                return new FunctionT(f2, res, f2.getParameters(), f2.isVarArgs());
            }
            if (f2.isVarArgs() && !f1.hasAttribute(Constants.ATT_DEFINED)) {
                return ErrorT.TYPE;
            }
            return new FunctionT(f2, res, f2.getParameters(), f2.isVarArgs());
        }
        if (f2.hasAttribute(Constants.ATT_STYLE_OLD)) {
            if (f1.isVarArgs() && !f2.hasAttribute(Constants.ATT_DEFINED)) {
                return ErrorT.TYPE;
            }
            return differs ? new FunctionT(f1, res, f1.getParameters(), f1.isVarArgs()) : f1;
        }
        if (f1.getParameters().size() != f2.getParameters().size()) {
            return ErrorT.TYPE;
        }
        if (f1.isVarArgs() != f2.isVarArgs()) {
            return ErrorT.TYPE;
        }
        int size = f1.getParameters().size();
        ArrayList<Type> par = differs ? new ArrayList<Type>(f1.getParameters()) : null;
        for (int i = 0; i < size; ++i) {
            Type p1 = f1.getParameters().get(i);
            Type p2 = f2.getParameters().get(i);
            if (pedantic && !this.hasSameQualifiers(p1, p2)) {
                return ErrorT.TYPE;
            }
            Type p3 = this.compose(p1, p2, true);
            if (p3.isError()) {
                return ErrorT.TYPE;
            }
            if (p1 == p3) continue;
            if (null == par) {
                par = new ArrayList<Type>(f1.getParameters());
            }
            differs = true;
            par.set(i, p3);
        }
        if (!differs) {
            return f1;
        }
        if (null == par) {
            par = new ArrayList<Type>(f1.getParameters());
        }
        FunctionT result = new FunctionT(f1, res, par, f1.isVarArgs());
        return result;
    }

    public boolean equal(Type t1, Type t2) {
        return this.hasSameQualifiers(t1, t2) && !this.compose(t1, t2, true).isError();
    }

    public Type typeCharacter(String literal) {
        boolean isWide = false;
        if (literal.startsWith("L")) {
            literal = literal.substring(2, literal.length() - 1);
            isWide = true;
        } else {
            literal = literal.substring(1, literal.length() - 1);
        }
        literal = Utilities.unescape(literal);
        BigInteger value = BigInteger.ZERO;
        BigInteger factor = isWide ? this.FACTOR_WIDE : this.FACTOR_CHAR;
        int length = literal.length();
        for (int i = 0; i < length; ++i) {
            value = value.multiply(factor).add(BigInteger.valueOf(literal.charAt(i)));
        }
        return isWide ? WCHAR.annotate().constant(value) : NumberT.CHAR.annotate().constant(value);
    }

    public Type typeInteger(String literal) {
        int idx;
        boolean isUnsigned = false;
        boolean isLong = false;
        boolean isLongLong = false;
        for (idx = literal.length(); idx > 0; --idx) {
            char c = literal.charAt(idx - 1);
            if ('u' == c || 'U' == c) {
                isUnsigned = true;
                continue;
            }
            if ('l' != c && 'L' != c) break;
            if (isLong) {
                isLong = false;
                isLongLong = true;
                continue;
            }
            isLong = true;
        }
        literal = literal.substring(0, idx);
        int radix = 10;
        if (literal.startsWith("0x") || literal.startsWith("0X")) {
            radix = 16;
            literal = literal.substring(2);
        } else if (literal.startsWith("0")) {
            radix = 8;
        }
        BigInteger value = new BigInteger(literal, radix);
        IntegerT type = null;
        if (isUnsigned) {
            if (isLongLong) {
                if (Limits.fitsUnsignedLongLong(value)) {
                    type = NumberT.U_LONG_LONG;
                }
            } else if (isLong) {
                if (Limits.fitsUnsignedLong(value)) {
                    type = NumberT.U_LONG;
                } else if (Limits.fitsUnsignedLongLong(value)) {
                    type = NumberT.U_LONG_LONG;
                }
            } else if (Limits.fitsUnsignedInt(value)) {
                type = NumberT.U_INT;
            } else if (Limits.fitsUnsignedLong(value)) {
                type = NumberT.U_LONG;
            } else if (Limits.fitsUnsignedLongLong(value)) {
                type = NumberT.U_LONG_LONG;
            }
            if (null == type) {
                type = NumberT.U_LONG_LONG;
            }
        } else if (10 == radix) {
            if (isLongLong) {
                if (Limits.fitsLongLong(value)) {
                    type = NumberT.LONG_LONG;
                }
            } else if (isLong) {
                if (Limits.fitsLong(value)) {
                    type = NumberT.LONG;
                } else if (Limits.fitsLongLong(value)) {
                    type = NumberT.LONG_LONG;
                }
            } else if (Limits.fitsInt(value)) {
                type = NumberT.INT;
            } else if (Limits.fitsLong(value)) {
                type = NumberT.LONG;
            } else if (Limits.fitsLongLong(value)) {
                type = NumberT.LONG_LONG;
            }
            if (null == type) {
                type = NumberT.LONG_LONG;
            }
        } else {
            if (isLongLong) {
                if (Limits.fitsLongLong(value)) {
                    type = NumberT.LONG_LONG;
                } else if (Limits.fitsUnsignedLongLong(value)) {
                    type = NumberT.U_LONG_LONG;
                }
            } else if (isLong) {
                if (Limits.fitsLong(value)) {
                    type = NumberT.LONG;
                } else if (Limits.fitsUnsignedLong(value)) {
                    type = NumberT.U_LONG;
                } else if (Limits.fitsLongLong(value)) {
                    type = NumberT.LONG_LONG;
                } else if (Limits.fitsUnsignedLongLong(value)) {
                    type = NumberT.U_LONG_LONG;
                }
            } else if (Limits.fitsInt(value)) {
                type = NumberT.INT;
            } else if (Limits.fitsUnsignedInt(value)) {
                type = NumberT.U_INT;
            } else if (Limits.fitsLong(value)) {
                type = NumberT.LONG;
            } else if (Limits.fitsUnsignedLong(value)) {
                type = NumberT.U_LONG;
            } else if (Limits.fitsLongLong(value)) {
                type = NumberT.LONG_LONG;
            } else if (Limits.fitsUnsignedLongLong(value)) {
                type = NumberT.U_LONG_LONG;
            }
            if (null == type) {
                type = NumberT.U_LONG_LONG;
            }
        }
        return type.annotate().constant(value);
    }

    public Type typeFloat(String literal) {
        FloatT type;
        char suffix = literal.charAt(literal.length() - 1);
        boolean chop = false;
        switch (suffix) {
            case 'F': 
            case 'f': {
                chop = true;
                type = NumberT.FLOAT;
                break;
            }
            case 'L': 
            case 'l': {
                chop = true;
                type = NumberT.LONG_DOUBLE;
                break;
            }
            case 'D': 
            case 'd': {
                chop = true;
            }
            default: {
                type = NumberT.DOUBLE;
            }
        }
        if (chop) {
            literal = literal.substring(0, literal.length() - 1);
        }
        return type.annotate().constant(Double.valueOf(literal));
    }

    static {
        boolean bl = $assertionsDisabled = !C.class.desiredAssertionStatus();
        if ("gcc".equals("gcc")) {
            // empty if block
        }
        GCC_LEGACY_LAYOUT = false;
        IMPLICIT = new IntegerT(NumberT.Kind.INT);
        IMPLICIT.addAttribute(Constants.ATT_IMPLICIT);
        IMPLICIT.seal();
        KIND_SIZEOF = IntegerT.fromRank(4, false);
        SIZEOF = new IntegerT(KIND_SIZEOF);
        SIZEOF.seal();
        KIND_PTR_DIFF = IntegerT.fromRank(4, true);
        PTR_DIFF = new IntegerT(KIND_PTR_DIFF);
        PTR_DIFF.seal();
        KIND_WCHAR = IntegerT.fromRank(3, true);
        WCHAR = new IntegerT(KIND_WCHAR);
        WCHAR.seal();
        PACKED = new Attribute("gcc", new Attribute("packed", null));
    }
}

