/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.DerivedT;
import xtc.type.Type;

public class ArrayT
extends DerivedT {
    private Type type;
    private boolean varlength;
    private long length;

    public ArrayT(Type type) {
        this(type, -1L);
    }

    public ArrayT(Type type, boolean varlength) {
        this.type = type;
        this.varlength = varlength;
        this.length = -1L;
    }

    public ArrayT(Type type, long length) {
        this.type = type;
        this.varlength = false;
        this.length = length;
    }

    public ArrayT(Type template, Type type, boolean varlength, long length) {
        super(template);
        this.type = type;
        this.varlength = varlength;
        this.length = length;
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.type.seal();
        }
        return this;
    }

    @Override
    public ArrayT copy() {
        return new ArrayT(this, this.type, this.varlength, this.length);
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayT toArray() {
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isVarLength() {
        return this.varlength;
    }

    public void setVarLength(boolean varlength) {
        this.checkNotSealed();
        this.varlength = varlength;
    }

    public boolean hasLength() {
        return -1L != this.length;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.checkNotSealed();
        this.length = length;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type t = ArrayT.resolve(o);
        if (this == t) {
            return true;
        }
        if (!t.isArray()) {
            return false;
        }
        ArrayT other = (ArrayT)t;
        if (this.varlength != other.varlength) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.type.equals(other.type);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append("array(");
        this.type.write(out);
        if (this.varlength) {
            out.append(", *");
        } else if (-1L != this.length) {
            out.append(", ");
            out.append(Long.toString(this.length));
        }
        out.append(')');
    }
}

