/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.tree.Printer;
import xtc.type.ErrorT;
import xtc.type.InstantiatedT;
import xtc.type.InternalT;
import xtc.type.NamedParameter;
import xtc.type.ParameterizedT;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.UnitT;
import xtc.type.VariantT;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.util.Utilities;

public abstract class AST {
    public static final Set<String> INTERNAL;
    public static final Type VOID;
    public static final Type ANY;
    public static final Type CHAR;
    public static final Type STRING;
    public static final Type TOKEN;
    public static final Type NODE;
    public static final Type NULL_NODE;
    public static final Type GENERIC;
    public static final Type FORMATTING;
    public static final Type LIST;
    public static final Type WILD_LIST;
    public static final Type ACTION;
    public static final Type WILD_ACTION;
    protected final Map<String, Type> externToIntern = new HashMap<String, Type>();
    protected final Map<String, String> internToExtern = new HashMap<String, String>();
    protected final List<String> importedModules = new ArrayList<String>();
    protected final Map<String, String> importedTypes = new HashMap<String, String>();
    protected final Map<String, VariantT> variants = new HashMap<String, VariantT>();
    protected final Map<String, Set<String>> variantNodes = new HashMap<String, Set<String>>();
    protected final Map<String, String> originalNames = new HashMap<String, String>();
    protected final Map<String, TupleT> tuples = new HashMap<String, TupleT>();
    protected final Map<String, List<VariantT>> tupleVariants = new HashMap<String, List<VariantT>>();

    public abstract void initialize(boolean var1, boolean var2, boolean var3, boolean var4);

    public void importModule(String module) {
        if (!this.importedModules.contains(module)) {
            this.importedModules.add(module);
        }
    }

    public void importType(String qualified, String simple) {
        if (this.importedTypes.containsKey(simple)) {
            assert (qualified.equals(this.importedTypes.get(simple)));
        } else {
            this.importedTypes.put(simple, qualified);
        }
    }

    public abstract boolean isVoid(String var1);

    public abstract boolean isGenericNode(String var1);

    public Type intern(String s) {
        Type type = this.externToIntern.get(s);
        if (null != type) {
            return type;
        }
        type = this.internList(s);
        if (!type.isError()) {
            return type;
        }
        type = this.internAction(s);
        if (!type.isError()) {
            return type;
        }
        return this.internUser(s);
    }

    protected abstract Type internList(String var1);

    protected abstract Type internAction(String var1);

    protected abstract Type internUser(String var1);

    public String extern(Type type) {
        switch (type.tag()) {
            case VARIANT: 
            case TUPLE: {
                if (type.hasAttribute(Constants.ATT_NODE)) {
                    return this.internToExtern.get("node");
                }
                return this.externUser(type);
            }
            case INTERNAL: {
                String name = type.resolve().toInternal().getName();
                if ("list".equals(name)) {
                    return this.externList(type);
                }
                if ("action".equals(name)) {
                    return this.externAction(type);
                }
                if (INTERNAL.contains(name)) {
                    return this.internToExtern.get(name);
                }
                return this.externUser(type);
            }
            case UNIT: {
                return type.hasAttribute(Constants.ATT_NODE) ? this.internToExtern.get("node") : this.internToExtern.get("unit");
            }
            case VOID: {
                return this.internToExtern.get("void");
            }
            case WILDCARD: {
                return this.internToExtern.get(type.resolve().toWildcard().getName());
            }
            case ERROR: {
                throw new AssertionError((Object)"Error type");
            }
        }
        return this.externUser(type);
    }

    protected abstract String externList(Type var1);

    protected abstract String externAction(Type var1);

    protected abstract String externUser(Type var1);

    public Constants.FuzzyBoolean hasLocation(Type type) {
        switch (type.tag()) {
            case VARIANT: 
            case TUPLE: {
                if (type.hasAttribute(Constants.ATT_NODE)) {
                    return Constants.FuzzyBoolean.TRUE;
                }
                return this.hasLocationUser(type);
            }
            case INTERNAL: {
                if (type.hasAttribute(Constants.ATT_NODE)) {
                    return Constants.FuzzyBoolean.TRUE;
                }
                String name = type.resolve().toInternal().getName();
                if ("any".equals(name)) {
                    return Constants.FuzzyBoolean.MAYBE;
                }
                if (INTERNAL.contains(name)) {
                    return Constants.FuzzyBoolean.FALSE;
                }
                return this.hasLocationUser(type);
            }
            case UNIT: {
                return type.hasAttribute(Constants.ATT_NODE) ? Constants.FuzzyBoolean.TRUE : Constants.FuzzyBoolean.FALSE;
            }
            case VOID: {
                return Constants.FuzzyBoolean.FALSE;
            }
            case WILDCARD: 
            case NAMED_PARAMETER: 
            case INTERNAL_PARAMETER: {
                return Constants.FuzzyBoolean.MAYBE;
            }
            case ERROR: {
                throw new AssertionError((Object)"Error type");
            }
        }
        return this.hasLocationUser(type);
    }

    protected abstract Constants.FuzzyBoolean hasLocationUser(Type var1);

    public static boolean isOptional(Type type) {
        return type.hasAttribute(Constants.ATT_OPTIONAL);
    }

    public static boolean isVariable(Type type) {
        return type.hasAttribute(Constants.ATT_VARIABLE);
    }

    public static boolean isVoid(Type type) {
        return type.resolve().isVoid();
    }

    public static boolean isAny(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "any".equals(r.toInternal().getName());
    }

    public static boolean isChar(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "char".equals(r.toInternal().getName());
    }

    public static boolean isString(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "string".equals(r.toInternal().getName());
    }

    public static boolean isToken(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "token".equals(r.toInternal().getName());
    }

    public static boolean isNode(Type type) {
        return type.hasAttribute(Constants.ATT_NODE);
    }

    public static boolean isDynamicNode(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "node".equals(r.toInternal().getName());
    }

    public static boolean isNullNode(Type type) {
        return type.hasAttribute(Constants.ATT_NODE) && type.resolve().isUnit();
    }

    public static boolean isStaticNode(Type type) {
        return type.hasAttribute(Constants.ATT_NODE) && type.resolve().isVariant();
    }

    public static boolean isGenericNode(Type type) {
        return type.hasAttribute(Constants.ATT_GENERIC) && type.hasAttribute(Constants.ATT_NODE);
    }

    public static boolean isFormatting(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "formatting".equals(r.toInternal().getName());
    }

    public static boolean isList(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "list".equals(r.toInternal().getName());
    }

    public static boolean isAction(Type type) {
        Type r = type.resolve();
        return r.isInternal() && "action".equals(r.toInternal().getName());
    }

    public static Type getArgument(Type type) {
        assert (type.hasInstantiated());
        assert (1 == type.toInstantiated().getArguments().size());
        return type.toInstantiated().getArguments().get(0);
    }

    public static boolean isUser(Type type) {
        switch (type.tag()) {
            case VARIANT: 
            case TUPLE: {
                return !type.hasAttribute(Constants.ATT_NODE);
            }
            case INTERNAL: {
                return !INTERNAL.contains(type.resolve().toInternal().getName());
            }
            case UNIT: 
            case VOID: 
            case WILDCARD: 
            case ERROR: 
            case NAMED_PARAMETER: 
            case INTERNAL_PARAMETER: {
                return false;
            }
        }
        return true;
    }

    public static Type markOptional(Type type) {
        return type.annotate().attribute(Constants.ATT_OPTIONAL);
    }

    public static Type markVariable(Type type) {
        return type.annotate().attribute(Constants.ATT_VARIABLE);
    }

    public String toVariantName(String name) {
        if (Utilities.isQualified(name)) {
            String qualifier = Utilities.getQualifier(name);
            String unqual = Utilities.getName(name);
            return Utilities.qualify(qualifier, Utilities.split(unqual, '_'));
        }
        return Utilities.split(name, '_');
    }

    public boolean hasVariant(String name) {
        return this.variants.containsKey(this.toVariantName(name));
    }

    public VariantT toVariant(String name, boolean poly) {
        VariantT variant;
        String vname = this.toVariantName(name);
        if (this.variants.containsKey(vname)) {
            variant = this.variants.get(vname);
            assert (poly == variant.isPolymorphic());
        } else {
            variant = new VariantT(vname, poly, new ArrayList<TupleT>());
            variant.addAttribute(Constants.ATT_NODE);
            this.variants.put(vname, variant);
            this.variantNodes.put(vname, new HashSet());
            this.originalNames.put(vname, name);
        }
        return variant;
    }

    public String toOriginal(VariantT variant) {
        String vname = variant.getName();
        assert (null != vname);
        assert (this.variants.containsKey(vname));
        assert (variant == this.variants.get(vname));
        return this.originalNames.get(vname);
    }

    public boolean hasTuple(String name) {
        return this.tuples.containsKey(name);
    }

    public boolean isMonomorphic(String name) {
        return this.tuples.containsKey(name) && 0 < this.tupleVariants.get(name).size() && !this.tupleVariants.get(name).get(0).isPolymorphic();
    }

    public TupleT toTuple(String name) {
        TupleT tuple;
        if (this.tuples.containsKey(name)) {
            tuple = this.tuples.get(name);
        } else {
            tuple = new TupleT(name);
            this.tuples.put(name, tuple);
            this.tupleVariants.put(name, new ArrayList());
        }
        return tuple;
    }

    public void add(TupleT tuple, VariantT variant) {
        Type t;
        String tname = tuple.getName();
        String vname = variant.getName();
        assert (this.tuples.containsKey(tname));
        assert (tuple == this.tuples.get(tname));
        assert (this.tupleVariants.containsKey(tname));
        if (null == vname) {
            assert (variant.isPolymorphic());
        } else {
            assert (this.variants.containsKey(vname));
            assert (variant == this.variants.get(vname));
        }
        if ((t = variant.lookup(tname)).isError()) {
            assert (variant.isPolymorphic() || null != vname && !this.variantNodes.get(vname).contains(tuple.getSimpleName()));
            if (!variant.isPolymorphic()) {
                this.variantNodes.get(vname).add(tuple.getSimpleName());
            }
            if (null != vname) {
                this.tupleVariants.get(tname).add(variant);
            }
            variant.getTuples().add(tuple);
        } else assert (t == tuple);
    }

    public List<VariantT> toVariants(TupleT tuple) {
        String tname = tuple.getName();
        assert (this.tuples.containsKey(tname));
        assert (tuple == this.tuples.get(tname));
        List<VariantT> variants = this.tupleVariants.get(tname);
        assert (null != variants);
        return variants;
    }

    public TupleT toTuple(VariantT variant) {
        TupleT tuple;
        String tname;
        String vname = variant.getName();
        assert (!variant.isPolymorphic());
        assert (this.variants.containsKey(vname));
        assert (variant == this.variants.get(vname));
        String qualifier = variant.getQualifier();
        if (this.isMonomorphic(Utilities.qualify(qualifier, tname = "Some" + Utilities.unqualify(this.originalNames.get(vname))))) {
            tname = "Just" + tname;
            while (this.isMonomorphic(Utilities.qualify(qualifier, tname))) {
                tname = tname + "1";
            }
        }
        if (null == (tuple = this.toTuple(Utilities.qualify(qualifier, tname))).getTypes()) {
            tuple.setTypes(new ArrayList<Type>(1));
            tuple.getTypes().add(variant);
        }
        return tuple;
    }

    public boolean overlap(VariantT v1, VariantT v2) {
        if (v1.isPolymorphic()) {
            for (TupleT tuple : v1.getTuples()) {
                if (!this.overlap(tuple.getTypes().get(0).toVariant(), v2)) continue;
                return true;
            }
        } else if (v2.isPolymorphic()) {
            for (TupleT tuple : v2.getTuples()) {
                if (!this.overlap(v1, tuple.getTypes().get(0).toVariant())) continue;
                return true;
            }
        } else {
            String vname1 = v1.getName();
            String vname2 = v2.getName();
            assert (this.variants.containsKey(vname1));
            assert (v1 == this.variants.get(vname1));
            assert (this.variants.containsKey(vname2));
            assert (v2 == this.variants.get(vname2));
            Set<String> nodes1 = this.variantNodes.get(v1.getName());
            Set<String> nodes2 = this.variantNodes.get(v2.getName());
            for (String s : nodes1) {
                if (!nodes2.contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    public MetaData getMetaData(VariantT variant) {
        MetaData meta = new MetaData();
        this.fillIn(variant, meta, new HashSet<String>());
        return meta;
    }

    private void fillIn(Type type, MetaData meta, Set<String> names) {
        switch (type.tag()) {
            case VARIANT: {
                VariantT variant = type.resolve().toVariant();
                String qname = variant.getName();
                String sname = variant.getSimpleName();
                List<TupleT> tuples = variant.getTuples();
                if (null == qname) {
                    for (TupleT t : tuples) {
                        this.fillIn(t, meta, names);
                    }
                } else {
                    if (meta.reachable.contains(qname)) break;
                    meta.reachable.add(qname);
                    if (names.contains(sname)) {
                        meta.modularize = true;
                    } else {
                        names.add(sname);
                    }
                    for (TupleT t : tuples) {
                        this.fillIn(t, meta, names);
                    }
                }
                break;
            }
            case TUPLE: {
                List<Type> types = type.resolve().toTuple().getTypes();
                if (null == types) break;
                for (Type t : types) {
                    this.fillIn(t, meta, names);
                }
                break;
            }
            case INTERNAL: {
                String name = type.resolve().toInternal().getName();
                if (!"list".equals(name) && !"action".equals(name) || !type.hasInstantiated()) break;
                this.fillIn(AST.getArgument(type), meta, names);
                break;
            }
        }
    }

    public static Type listOf(Type element) {
        return new InstantiatedT(element, LIST);
    }

    public static Type actionOf(Type element) {
        return new InstantiatedT(element, ACTION);
    }

    public Type unify(Type t1, Type t2, boolean strict) {
        if (t1 == t2) {
            return t1;
        }
        if (t1.hasError() || t2.hasError()) {
            return ErrorT.TYPE;
        }
        if (t1.resolve().isParameter()) {
            return t2;
        }
        if (t2.resolve().isParameter()) {
            return t1;
        }
        Type result = this.unify1(t1, t2, strict);
        if (result.isError() && !strict) {
            result = ANY;
        }
        if (!result.isError()) {
            if (AST.isVariable(t1) || AST.isVariable(t2)) {
                result = AST.markVariable(result);
            } else if (AST.isOptional(t1) || AST.isOptional(t2)) {
                result = AST.markOptional(result);
            }
        }
        return result;
    }

    private Type unify1(Type t1, Type t2, boolean strict) {
        Type r1 = t1.resolve();
        Type r2 = t2.resolve();
        if (t1.hasInstantiated() && t2.hasInstantiated()) {
            InstantiatedT i1 = t1.toInstantiated();
            InstantiatedT i2 = t2.toInstantiated();
            List<Type> a1 = i1.getArguments();
            List<Type> a2 = i2.getArguments();
            if (a1.size() != a2.size()) {
                return ErrorT.TYPE;
            }
            Type base = this.unify(i1.getType(), i2.getType(), true);
            if (base.isError()) {
                return ErrorT.TYPE;
            }
            ArrayList<Type> args = new ArrayList<Type>(a1.size());
            for (int i = 0; i < a1.size(); ++i) {
                Type t = this.unify(a1.get(i), a2.get(i), true);
                if (t.isError()) {
                    return ErrorT.TYPE;
                }
                args.add(t);
            }
            return new InstantiatedT(args, base);
        }
        if (t1.hasInstantiated() || t2.hasInstantiated()) {
            return ErrorT.TYPE;
        }
        if (AST.isUser(t1) && AST.isUser(t2)) {
            return this.unifyUser(t1, t2, strict);
        }
        if (AST.isNode(t1) && AST.isNode(t2)) {
            if (AST.isNullNode(t1)) {
                return r2;
            }
            if (AST.isNullNode(t2)) {
                return r1;
            }
            if (AST.isToken(t1) && AST.isToken(t2)) {
                return TOKEN;
            }
            if ((AST.isToken(t1) || AST.isDynamicNode(t1) || AST.isFormatting(t1)) && (AST.isToken(t2) || AST.isDynamicNode(t2) || AST.isFormatting(t2))) {
                return NODE;
            }
            if (r1.isVariant() && r2.isVariant()) {
                return this.unify(r1.toVariant(), r2.toVariant());
            }
            if (strict) {
                return ErrorT.TYPE;
            }
            return NODE;
        }
        if (r1.isVoid() && r2.isVoid()) {
            return VoidT.TYPE;
        }
        if (r1.isUnit() && r2.isUnit()) {
            return UnitT.TYPE;
        }
        if (AST.isChar(t1) && AST.isChar(t2)) {
            return CHAR;
        }
        if (AST.isString(t1) && AST.isString(t2)) {
            return STRING;
        }
        if (AST.isList(t1) && AST.isList(t2)) {
            return LIST;
        }
        if (AST.isAction(t1) && AST.isAction(t2)) {
            return ACTION;
        }
        return ErrorT.TYPE;
    }

    protected Type unify(VariantT v1, VariantT v2) {
        if (null != v1.getName() && v1.getName().equals(v2.getName())) {
            return v1;
        }
        ArrayList<TupleT> tuples = new ArrayList<TupleT>();
        VariantT result = new VariantT(null, true, tuples);
        result.addAttribute(Constants.ATT_NODE);
        if (v1.isPolymorphic()) {
            tuples.addAll(v1.getTuples());
            if (v2.isPolymorphic()) {
                for (TupleT tuple : v2.getTuples()) {
                    if (tuples.contains(tuple)) continue;
                    VariantT v3 = tuple.getTypes().get(0).toVariant();
                    if (this.overlap(v1, v3)) {
                        return ErrorT.TYPE;
                    }
                    tuples.add(tuple);
                }
            } else {
                TupleT tuple = this.toTuple(v2);
                if (!tuples.contains(tuple)) {
                    if (this.overlap(v1, v2)) {
                        return ErrorT.TYPE;
                    }
                    tuples.add(tuple);
                }
            }
        } else if (v2.isPolymorphic()) {
            tuples.addAll(v2.getTuples());
            TupleT tuple = this.toTuple(v1);
            if (!tuples.contains(tuple)) {
                if (this.overlap(v1, v2)) {
                    return ErrorT.TYPE;
                }
                tuples.add(tuple);
            }
        } else {
            if (this.overlap(v1, v2)) {
                return ErrorT.TYPE;
            }
            tuples.add(this.toTuple(v1));
            tuples.add(this.toTuple(v2));
        }
        return result;
    }

    protected abstract Type unifyUser(Type var1, Type var2, boolean var3);

    public Type flatten(TupleT tuple, boolean strict) {
        List<Type> types = tuple.getTypes();
        int size = types.size();
        int index = -1;
        Type element = null;
        boolean optional = false;
        for (int i = 0; i < size; ++i) {
            Type t = types.get(i);
            if (-1 == index) {
                if (!AST.isList(t)) continue;
                index = i;
                if (AST.isOptional(t = AST.getArgument(t))) {
                    optional = true;
                }
                element = t = t.deannotate();
                continue;
            }
            if (AST.isList(t)) {
                t = AST.getArgument(t);
            }
            if (AST.isOptional(t)) {
                optional = true;
            }
            if (!(element = this.unify(element, t = t.deannotate(), strict)).isError()) continue;
            return ErrorT.TYPE;
        }
        if (-1 != index) {
            if (optional) {
                element = AST.markOptional(element);
            }
            Type list = AST.listOf(element);
            if (AST.isVariable(types.get(index))) {
                list = AST.markVariable(list);
            }
            types.subList(index, size).clear();
            types.add(list);
        }
        return tuple;
    }

    public Type combine(TupleT tuple1, TupleT tuple2, boolean flatten, boolean strict) {
        assert (tuple1.getName().equals(tuple2.getName()));
        if (tuple1 == tuple2 || tuple1.equals(tuple2)) {
            return tuple1;
        }
        List<Type> types1 = tuple1.getTypes();
        List<Type> types2 = tuple2.getTypes();
        int size1 = types1.size();
        int size2 = types2.size();
        int listIdx = Integer.MAX_VALUE;
        Type elemT = Wildcard.TYPE;
        boolean variable = false;
        boolean optional = false;
        if (flatten) {
            Type t;
            int i;
            for (i = 0; i < size1; ++i) {
                t = types1.get(i);
                if (!AST.isList(t)) continue;
                listIdx = i;
                variable = AST.isVariable(t);
                break;
            }
            for (i = 0; i < size2; ++i) {
                t = types2.get(i);
                if (!AST.isList(t)) continue;
                if (i >= listIdx) break;
                listIdx = i;
                variable = AST.isVariable(t);
                break;
            }
            if (Integer.MAX_VALUE != listIdx) {
                for (i = listIdx; i < size1; ++i) {
                    t = types1.get(i);
                    if (AST.isList(t)) {
                        t = AST.getArgument(t);
                    }
                    if (AST.isOptional(t)) {
                        optional = true;
                    }
                    if (!(elemT = this.unify(elemT, t = t.deannotate(), strict)).isError()) continue;
                    return ErrorT.TYPE;
                }
                for (i = listIdx; i < size2; ++i) {
                    t = types2.get(i);
                    if (AST.isList(t)) {
                        t = AST.getArgument(t);
                    }
                    if (AST.isOptional(t)) {
                        optional = true;
                    }
                    if (!(elemT = this.unify(elemT, t = t.deannotate(), strict)).isError()) continue;
                    return ErrorT.TYPE;
                }
            }
        }
        ArrayList<Type> types3 = new ArrayList<Type>(Math.max(size1, size2));
        int size3 = Math.min(Math.max(size1, size2), listIdx);
        for (int i = 0; i < size3; ++i) {
            Type t3;
            Type t2;
            Type t1 = i < size1 ? types1.get(i) : null;
            Type type = t2 = i < size2 ? types2.get(i) : null;
            if (null == t1) {
                t3 = AST.markVariable(t2.deannotate());
            } else if (null == t2) {
                t3 = AST.markVariable(t1.deannotate());
            } else {
                t3 = this.unify(t1.deannotate(), t2.deannotate(), strict);
                if (t3.isError()) {
                    return ErrorT.TYPE;
                }
                if (AST.isVariable(t1) || AST.isVariable(t2)) {
                    t3 = AST.markVariable(t3);
                } else if (AST.isOptional(t1) || AST.isOptional(t2)) {
                    t3 = AST.markOptional(t3);
                } else if ((t1.resolve().isWildcard() || t2.resolve().isWildcard()) && !t3.resolve().isWildcard()) {
                    t3 = AST.markOptional(t3);
                }
            }
            types3.add(t3);
        }
        if (Integer.MAX_VALUE != listIdx) {
            if (optional) {
                elemT = AST.markOptional(elemT);
            }
            Type list = AST.listOf(elemT);
            if (variable || listIdx > size1 || listIdx > size2) {
                list = AST.markVariable(list);
            }
            types3.add(list);
        }
        return new TupleT(tuple1.getName(), types3);
    }

    public Type concretize(Type type, Type concrete) {
        Type el;
        Type resolved = type.resolve();
        Type result = null;
        if (resolved.isWildcard()) {
            result = concrete;
        } else if (resolved.isTuple()) {
            TupleT tuple = resolved.toTuple();
            List<Type> elements = tuple.getTypes();
            boolean isCopy = false;
            for (int i = 0; i < elements.size(); ++i) {
                Type element = this.concretize(elements.get(i), concrete);
                if (elements.get(i) == element) continue;
                if (!isCopy) {
                    elements = new ArrayList<Type>(elements);
                    isCopy = true;
                }
                elements.set(i, element);
            }
            if (isCopy) {
                result = new TupleT(tuple.getName(), elements);
            }
        } else if (AST.isList(type)) {
            Type el2 = this.concretize(AST.getArgument(type), concrete);
            if (el2 != AST.getArgument(type)) {
                result = AST.listOf(el2);
            }
        } else if (AST.isAction(type) && (el = this.concretize(AST.getArgument(type), concrete)) != AST.getArgument(type)) {
            result = AST.actionOf(el);
        }
        if (null == result) {
            return type;
        }
        if (AST.isVariable(type)) {
            result = AST.markVariable(result);
        } else if (AST.isOptional(type)) {
            result = AST.markOptional(result);
        }
        return result;
    }

    public void concretizeTuples(VariantT variant, Type concrete) {
        List<TupleT> tuples = variant.getTuples();
        if (null != tuples) {
            for (int i = 0; i < tuples.size(); ++i) {
                tuples.set(i, this.concretize(tuples.get(i), concrete).toTuple());
            }
        }
    }

    public void print(Type type, Printer printer, boolean refIsDecl, boolean qualified, String module) {
        switch (type.tag()) {
            case VARIANT: {
                VariantT variant = type.resolve().toVariant();
                boolean poly = variant.isPolymorphic();
                List<TupleT> tuples = variant.getTuples();
                String name = !qualified || null != module && module.equals(variant.getQualifier()) ? variant.getSimpleName() : variant.getName();
                if (null == name) {
                    printer.pln('[').incr().incr();
                    for (TupleT tuple : tuples) {
                        printer.indent().p("| `");
                        this.print(tuple, true, printer, qualified, module);
                        printer.pln();
                    }
                    printer.decr().decr().indentMore().p(']');
                    break;
                }
                if (!refIsDecl) {
                    printer.p(name);
                    break;
                }
                if (poly) {
                    printer.indent().p("mltype ").p(name).pln(" = [").incr();
                    for (TupleT tuple : tuples) {
                        printer.indent().p("| `");
                        this.print(tuple, true, printer, qualified, module);
                        printer.pln();
                    }
                    printer.decr().indent().pln("];");
                    break;
                }
                if (1 == tuples.size()) {
                    printer.indent().p("mltype ").p(name).p(" = ");
                    this.print(tuples.get(0), false, printer, qualified, module);
                    printer.pln(" ;");
                    break;
                }
                printer.indent().p("mltype ").p(name).pln(" =").incr();
                Iterator<TupleT> iter = tuples.iterator();
                while (iter.hasNext()) {
                    printer.indent().p("| ");
                    this.print(iter.next(), false, printer, qualified, module);
                    if (!iter.hasNext()) continue;
                    printer.pln();
                }
                printer.pln(" ;").decr();
                break;
            }
            case TUPLE: {
                this.print(type.resolve().toTuple(), false, printer, qualified, module);
                break;
            }
            case INTERNAL: {
                String name = type.resolve().toInternal().getName();
                if ("list".equals(name) || "action".equals(name)) {
                    if (type.hasInstantiated()) {
                        this.print(type.toInstantiated().getArguments().get(0), printer, false, qualified, module);
                    } else {
                        this.print(type.toParameterized().getParameters().get(0), printer, false, qualified, module);
                    }
                    printer.p(' ');
                }
                printer.p(name);
                break;
            }
            case UNIT: 
            case VOID: {
                printer.p("bottom");
                break;
            }
            case WILDCARD: 
            case NAMED_PARAMETER: 
            case INTERNAL_PARAMETER: {
                printer.p("'").p(type.resolve().toString());
                break;
            }
            case ERROR: {
                printer.p("<error>");
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid type " + type));
            }
        }
        if (!refIsDecl) {
            if (type.hasAttribute(Constants.ATT_VARIABLE)) {
                printer.p(" var");
            } else if (type.hasAttribute(Constants.ATT_OPTIONAL)) {
                printer.p(" opt");
            }
        }
    }

    private void print(TupleT tuple, boolean poly, Printer printer, boolean qualified, String module) {
        String name = tuple.getName();
        if (!qualified || !poly || null != module && module.equals(Utilities.getQualifier(name))) {
            name = tuple.getSimpleName();
        }
        printer.p(name);
        List<Type> types = tuple.getTypes();
        if (null != types && !types.isEmpty()) {
            printer.p(" of ");
            Iterator<Type> iter = types.iterator();
            while (iter.hasNext()) {
                Type t = iter.next();
                if (t.resolve().isVariant() && null == t.resolve().toVariant().getName()) {
                    this.print(t, printer, false, qualified, module);
                    if (!iter.hasNext()) continue;
                    printer.p(" * ");
                    continue;
                }
                printer.buffer();
                this.print(t, printer, false, qualified, module);
                if (iter.hasNext()) {
                    printer.p(" * ");
                }
                printer.fitMore();
            }
        }
    }

    static {
        VOID = VoidT.TYPE;
        HashSet<String> internal = new HashSet<String>();
        internal.add("any");
        internal.add("char");
        internal.add("string");
        internal.add("token");
        internal.add("node");
        internal.add("formatting");
        internal.add("list");
        internal.add("action");
        INTERNAL = Collections.unmodifiableSet(internal);
        ANY = new InternalT("any");
        CHAR = new InternalT("char");
        STRING = new InternalT("string");
        TOKEN = new InternalT("token");
        TOKEN.addAttribute(Constants.ATT_NODE);
        NODE = new InternalT("node");
        NODE.addAttribute(Constants.ATT_NODE);
        NULL_NODE = new UnitT();
        NULL_NODE.addAttribute(Constants.ATT_NODE);
        GENERIC = new InternalT("node");
        GENERIC.addAttribute(Constants.ATT_NODE);
        GENERIC.addAttribute(Constants.ATT_GENERIC);
        FORMATTING = new InternalT("formatting");
        FORMATTING.addAttribute(Constants.ATT_NODE);
        LIST = new ParameterizedT(new NamedParameter("element"), (Type)new InternalT("list"));
        WILD_LIST = new InstantiatedT(Wildcard.TYPE, LIST);
        ACTION = new ParameterizedT(new NamedParameter("element"), (Type)new InternalT("action"));
        WILD_ACTION = new InstantiatedT(Wildcard.TYPE, ACTION);
        ANY.seal();
        CHAR.seal();
        STRING.seal();
        TOKEN.seal();
        NULL_NODE.seal();
        NODE.seal();
        GENERIC.seal();
        FORMATTING.seal();
        LIST.seal();
        WILD_LIST.seal();
        ACTION.seal();
        WILD_ACTION.seal();
    }

    public static class MetaData {
        public Set<String> reachable = new HashSet<String>();
        public boolean modularize = false;
    }
}

