/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import xtc.tree.Annotation;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.VisitingException;
import xtc.tree.VisitorException;
import xtc.util.Pair;

public abstract class Visitor {
    private static final int CACHE_SIZE = 300;
    private static final int CACHE_CAPACITY = 400;
    private static final float CACHE_LOAD = 0.75f;
    private static final LinkedHashMap<CacheKey, Method> cache = new LinkedHashMap<CacheKey, Method>(400, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry e) {
            return this.size() > 300;
        }
    };
    private static final CacheKey key = new CacheKey(null, null);
    private static final Object[] arguments = new Object[]{null};
    private static final Class<?>[] types = new Class[]{null};

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public Object visit(Annotation a) {
        return this.dispatch(a.node);
    }

    public final Object dispatch(Node n) {
        if (null == n) {
            return null;
        }
        Visitor.key.visitor = this;
        Visitor.key.node = n.isGeneric() ? n.getName() : n.getClass();
        Method method = cache.get(key);
        if (null == method) {
            method = this.findMethod(n);
            cache.put(new CacheKey(this, Visitor.key.node), method);
        }
        Visitor.arguments[0] = n;
        try {
            return method.invoke((Object)this, arguments);
        }
        catch (IllegalAccessException x) {
            throw new VisitorException("Unable to invoke " + method + " on " + arguments[0]);
        }
        catch (IllegalArgumentException x) {
            throw new VisitorException("Internal error while visiting node " + n + " with visitor " + this);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof VisitingException) {
                throw (VisitingException)cause;
            }
            if (cause instanceof VisitorException) {
                throw (VisitorException)cause;
            }
            throw new VisitingException("Error visiting node " + n + " with " + "visitor " + this, cause);
        }
        catch (NullPointerException x) {
            throw new VisitorException("Internal error while visiting node " + n + " with visitor " + this);
        }
    }

    private Method findMethod(Node n) {
        Class<?> visitorT = this.getClass();
        Method method = null;
        if (n.isGeneric()) {
            Visitor.types[0] = GNode.class;
            try {
                method = visitorT.getMethod("visit" + n.getName(), types);
            }
            catch (NoSuchMethodException x) {
                try {
                    method = visitorT.getMethod("visit", types);
                }
                catch (NoSuchMethodException xx) {
                    Visitor.types[0] = Node.class;
                    try {
                        method = visitorT.getMethod("visit", types);
                    }
                    catch (NoSuchMethodException xxx) {}
                }
            }
        } else {
            method = Visitor.findMethod(visitorT, "visit", n.getClass());
        }
        if (null == method) {
            Visitor.types[0] = Node.class;
            try {
                method = visitorT.getMethod("unableToVisit", types);
            }
            catch (NoSuchMethodException x) {
                throw new AssertionError((Object)"Unable to find unableToVisit(Node)");
            }
        }
        method.setAccessible(true);
        return method;
    }

    private static Method findMethod(Class<?> k, String name, Class paramT) {
        Method method = null;
        do {
            Visitor.types[0] = paramT;
            try {
                method = k.getMethod(name, types);
            }
            catch (NoSuchMethodException x) {
                Class<?>[] interfaces = paramT.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Visitor.types[0] = interfaces[i];
                    try {
                        method = k.getMethod(name, types);
                        break;
                    }
                    catch (NoSuchMethodException xx) {
                        continue;
                    }
                }
                paramT = paramT.getSuperclass();
            }
        } while (null == method && Object.class != paramT);
        return method;
    }

    public Object unableToVisit(Node node) {
        if (node.isGeneric()) {
            throw new VisitorException("No method to visit generic node " + node.getName() + " with visitor " + this);
        }
        throw new VisitorException("No method to visit node type " + node.getClass() + " with visitor " + this);
    }

    public void iterate(Pair<? extends Node> list) {
        while (Pair.EMPTY != list) {
            this.dispatch(list.head());
            list = list.tail();
        }
    }

    public <T> Pair<T> map(Pair<? extends Node> list) {
        Pair<Object> result;
        if (Pair.EMPTY == list) {
            return Pair.empty();
        }
        Object v1 = this.dispatch(list.head());
        Pair<Object> cursor = result = new Pair<Object>(v1);
        while (Pair.EMPTY != list.tail()) {
            list = list.tail();
            Object v2 = this.dispatch(list.head());
            cursor.setTail(new Pair<Object>(v2));
            cursor = cursor.tail();
        }
        return result;
    }

    public <T extends Node> Pair<T> mapInPlace(Pair<T> list) {
        for (Pair<Node> p = list; Pair.EMPTY != p; p = p.tail()) {
            Node v = (Node)this.dispatch((Node)p.head());
            p.setHead(v);
        }
        return list;
    }

    static final class CacheKey {
        public Visitor visitor;
        public Object node;

        public CacheKey(Visitor visitor, Object node) {
            this.visitor = visitor;
            this.node = node;
        }

        public int hashCode() {
            return 37 * this.visitor.hashCode() + this.node.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!this.visitor.equals(other.visitor)) {
                return false;
            }
            return this.node.equals(other.node);
        }
    }
}

