/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TraversalException
extends RuntimeException {
    public TraversalException(String message) {
        super(message);
    }

    public TraversalException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public Throwable getCause() {
        Throwable t = super.getCause();
        return null == t ? t : TraversalException.clean(t);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        TraversalException.clean(this);
        super.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        TraversalException.clean(this);
        super.printStackTrace(s);
    }

    private static <T extends Throwable> T clean(T t) {
        StackTraceElement[] oldTrace = t.getStackTrace();
        int size = 0;
        for (StackTraceElement e : oldTrace) {
            if (!TraversalException.isClean(e)) continue;
            ++size;
        }
        if (oldTrace.length == size) {
            if (null != t.getCause()) {
                TraversalException.clean(t.getCause());
            }
            return t;
        }
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>(size);
        for (StackTraceElement e : oldTrace) {
            if (!TraversalException.isClean(e)) continue;
            newTrace.add(e);
        }
        t.setStackTrace(newTrace.toArray(new StackTraceElement[newTrace.size()]));
        if (null != t.getCause()) {
            TraversalException.clean(t.getCause());
        }
        return t;
    }

    private static boolean isClean(StackTraceElement e) {
        String klass = e.getClassName();
        String method = e.getMethodName();
        return (!method.equals("dispatch") || !klass.equals("xtc.tree.Visitor")) && (!method.startsWith("invoke") || !klass.equals("java.lang.reflect.Method") && !klass.startsWith("sun.reflect."));
    }
}

