/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Token;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class Transducer
extends Visitor {
    protected final Printer printer;
    protected final Map<String, String> variables;
    protected int varcount;

    public Transducer(Printer printer) {
        this(printer, new HashMap<String, String>());
    }

    public Transducer(Printer printer, Map<String, String> variables) {
        this.printer = printer;
        this.variables = variables;
    }

    public boolean isPatternVariable(Node n) {
        return null == (n = n.strip()) ? false : n.isGeneric() && this.variables.containsKey(n.getName());
    }

    public GNode toPatternVariable(Node n) {
        if (null == (n = n.strip()) || !n.isGeneric() || !this.variables.containsKey(n.getName())) {
            throw new IllegalArgumentException("Not a pattern variable: " + n);
        }
        if (1 != n.size() || !Token.test(n.get(0))) {
            throw new IllegalArgumentException("Malformed pattern variable: " + n);
        }
        return (GNode)n;
    }

    public String getVariableName(Node n) {
        return Token.cast(this.toPatternVariable(n).get(0));
    }

    public String getVariableType(Node n) {
        return this.variables.get(this.toPatternVariable(n).getName());
    }

    public boolean isListType(String t) {
        return t.equals("List") || t.startsWith("List<");
    }

    public String toLiteral(Object o, String var) {
        if (null == o) {
            return "null";
        }
        if (Token.test(o)) {
            return '\"' + Utilities.escape(Token.cast(o), 8) + '\"';
        }
        if (o instanceof Node) {
            return null == var ? this.getVariableName((Node)o) : var;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "true" : "false";
        }
        if (o instanceof Double) {
            return (Double)o + "D";
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() + "F";
        }
        if (o instanceof Long) {
            return (Long)o + "L";
        }
        if (o instanceof Integer) {
            return o.toString();
        }
        if (o instanceof Short) {
            return "Short.valueOf(" + (Short)o + ')';
        }
        if (o instanceof Byte) {
            return "Byte.valueOf(" + (Byte)o + ')';
        }
        if (o instanceof Character) {
            return "'" + ((Character)o).charValue() + "'";
        }
        throw new IllegalArgumentException("Unrecognized value: " + o);
    }

    public void process(String method, Node n) {
        if (null == method) {
            throw new NullPointerException("Null method name");
        }
        if (null == n) {
            throw new NullPointerException("Null node");
        }
        if (!GNode.test(n = n.strip())) {
            throw new IllegalArgumentException("Not an (annotated) generic node: " + n);
        }
        if (this.isPatternVariable(n)) {
            throw new IllegalArgumentException("Pattern variable: " + n);
        }
        this.varcount = 0;
        final ArrayList holes = new ArrayList();
        final ArrayList types = new ArrayList();
        new Visitor(){

            public void visit(GNode n) {
                block3: {
                    block1: {
                        int idx;
                        String type;
                        block2: {
                            if (!Transducer.this.isPatternVariable(n)) break block1;
                            String name = Transducer.this.getVariableName(n);
                            type = Transducer.this.getVariableType(n);
                            idx = holes.indexOf(name);
                            if (-1 != idx) break block2;
                            holes.add(name);
                            types.add(type);
                            break block3;
                        }
                        if (((String)types.get(idx)).equals(type)) break block3;
                        types.set(idx, "Object");
                        break block3;
                    }
                    for (Object o : n) {
                        if (!(o instanceof Node)) continue;
                        this.dispatch((Node)o);
                    }
                }
            }
        }.dispatch(n);
        String desc = Utilities.split(n.getName(), ' ');
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Create ").p(Utilities.toArticle(desc)).p(' ').p(desc).pln('.');
        this.printer.indent().pln(" *");
        for (String h : holes) {
            this.printer.indent().p(" * @param ").p(h).p(" The ").p(h).pln('.');
        }
        this.printer.indent().pln(" * @return The generic node.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public Node ").p(method).p('(');
        int align = this.printer.column();
        boolean first = true;
        Iterator iterH = holes.iterator();
        Iterator iterT = types.iterator();
        while (iterH.hasNext()) {
            if (!first) {
                this.printer.buffer();
            }
            this.printer.p((String)iterT.next()).p(' ').p((String)iterH.next());
            if (iterH.hasNext()) {
                this.printer.p(", ");
            }
            if (first) {
                first = false;
                continue;
            }
            this.printer.fit(align);
        }
        this.printer.pln(") {").incr();
        String result = (String)this.dispatch(n);
        if (null == result) {
            result = this.getVariableName(n);
        }
        this.printer.indent().p("return ").p(result).pln(';');
        this.printer.decr().indent().pln('}');
    }

    public String visit(GNode n) {
        if (this.isPatternVariable(n)) {
            return null;
        }
        int size = n.size();
        ArrayList<String> vars = null;
        boolean hasList = false;
        if (0 < size) {
            vars = new ArrayList<String>(size);
        }
        for (Object o : n) {
            if (o instanceof Node) {
                Node child = (Node)o;
                if (this.isPatternVariable(child)) {
                    vars.add(null);
                    if (!this.isListType(this.getVariableType(child))) continue;
                    hasList = true;
                    continue;
                }
                vars.add((String)this.dispatch(child));
                continue;
            }
            vars.add(null);
        }
        String result = "v$" + ++this.varcount;
        this.printer.indent().p("Node ").p(result).p(" = GNode.create(\"").p(n.getName()).p("\"");
        if (0 == size) {
            this.printer.pln(", false);");
        } else if (hasList) {
            Node child;
            Object o;
            int i;
            this.printer.p(", ");
            int scount = 0;
            boolean seenList = false;
            for (i = 0; i < size; ++i) {
                o = n.get(i);
                if (o instanceof Node) {
                    child = (Node)o;
                    if (this.isPatternVariable(child) && this.isListType(this.getVariableType(child))) {
                        if (seenList) {
                            this.printer.p(" + ");
                        } else {
                            seenList = true;
                        }
                        this.printer.p(this.getVariableName(child)).p(".size()");
                        continue;
                    }
                    ++scount;
                    continue;
                }
                ++scount;
            }
            if (0 < scount) {
                this.printer.p(" + ").p(scount);
            }
            this.printer.pln(").").indentMore();
            for (i = 0; i < size; ++i) {
                o = n.get(i);
                this.printer.buffer();
                if (o instanceof Node) {
                    child = (Node)o;
                    if (this.isPatternVariable(child) && this.isListType(this.getVariableType(child))) {
                        this.printer.p("addAll(");
                    } else {
                        this.printer.p("add(");
                    }
                } else {
                    this.printer.p("add(");
                }
                this.printer.p(this.toLiteral(o, (String)vars.get(i))).p(')');
                if (i < size - 1) {
                    this.printer.p('.');
                } else {
                    this.printer.p(';');
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        } else {
            this.printer.p(", ");
            if (8 < size) {
                this.printer.p(size).pln(").").indentMore();
            }
            for (int i = 0; i < size; ++i) {
                this.printer.buffer();
                if (8 < size) {
                    this.printer.p("add(");
                }
                this.printer.p(this.toLiteral(n.get(i), (String)vars.get(i)));
                if (8 < size) {
                    this.printer.p(')');
                }
                if (i < size - 1) {
                    if (8 < size) {
                        this.printer.p('.');
                    } else {
                        this.printer.p(", ");
                    }
                } else if (8 < size) {
                    this.printer.p(';');
                } else {
                    this.printer.p(");");
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        }
        return result;
    }
}

