/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import xtc.tree.Annotation;
import xtc.tree.LineMarker;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class Relocator
extends Visitor {
    protected String markedFile = null;
    protected int markedLine = -1;
    protected int baseLine = -1;

    protected void relocate(Node n) {
        if (null == this.markedFile || null == n.location) {
            return;
        }
        int line = n.location.line - this.baseLine - 1 + this.markedLine;
        if (line != n.location.line || !n.location.file.equals(this.markedFile)) {
            n.location = new Location(this.markedFile, line, n.location.column);
        }
    }

    public Node visit(Node n) {
        this.relocate(n);
        for (int i = 0; i < n.size(); ++i) {
            Object o = n.get(i);
            if (!(o instanceof Node)) continue;
            n.set(i, this.dispatch((Node)o));
        }
        return n;
    }

    @Override
    public Annotation visit(Annotation a) {
        this.relocate(a);
        a.node = (Node)this.dispatch(a.node);
        return a;
    }

    public Node visit(LineMarker m) {
        if (null == m.location) {
            throw new IllegalArgumentException("Line marker without location");
        }
        this.markedFile = m.file;
        this.markedLine = m.line;
        this.baseLine = m.location.line;
        return (Node)this.dispatch(m.node);
    }
}

