/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Utility;
import xtc.util.Pair;
import xtc.util.Utilities;

public class Printer
extends Utility {
    protected BreakIterator breaks;
    protected PrintWriter out;
    protected PrintWriter directOut;
    protected StringWriter bufferedOut = null;
    protected int buffering = 0;
    protected int indent = 0;
    protected int column = 1;
    protected long line = 1L;
    private String formatFile;

    public Printer(OutputStream out) {
        this(new PrintWriter(out, false));
    }

    public Printer(Writer out) {
        this(new PrintWriter(out, false));
    }

    public Printer(PrintWriter out) {
        this.out = out;
        this.directOut = out;
    }

    public Printer reset() {
        this.stopBuffering();
        this.indent = 0;
        this.column = 1;
        this.line = 1L;
        return this;
    }

    public int column() {
        return this.column;
    }

    public Printer column(int column) {
        this.column = column;
        return this;
    }

    public long line() {
        return this.line;
    }

    public Printer line(long line) {
        this.line = line;
        return this;
    }

    public Printer buffer() {
        if (0 == this.buffering) {
            this.bufferedOut = new StringWriter();
            this.out = new PrintWriter((Writer)this.bufferedOut, false);
        }
        ++this.buffering;
        return this;
    }

    protected String stopBuffering() {
        if (null != this.bufferedOut) {
            this.out.flush();
            String s = this.bufferedOut.toString();
            this.out = this.directOut;
            this.bufferedOut = null;
            this.buffering = 0;
            return s;
        }
        return "";
    }

    public Printer fit() {
        if (1 == this.buffering) {
            String s = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.indent().p(s);
            } else {
                this.out.print(s);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fit(int align) {
        if (1 == this.buffering) {
            String s = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.align(align).p(s);
            } else {
                this.out.print(s);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fit(String prefix) {
        if (1 == this.buffering) {
            String s = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.indent().p(prefix).p(s);
            } else {
                this.out.print(s);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fitMore() {
        if (1 == this.buffering) {
            String s = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.indentMore().p(s);
            } else {
                this.out.print(s);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer unbuffer() {
        if (0 < this.buffering) {
            String s = this.stopBuffering();
            this.out.write(s);
        }
        return this;
    }

    public Printer align(int alignment) {
        int toPrint = alignment - this.column;
        if (0 >= toPrint) {
            toPrint = 1;
        }
        for (int i = 0; i < toPrint; ++i) {
            this.out.write(32);
        }
        this.column += toPrint;
        return this;
    }

    public int level() {
        return this.indent / 2;
    }

    public Printer setLevel(int level) {
        if (0 > level) {
            throw new IllegalArgumentException("Negative indentation level");
        }
        this.indent = level * 2;
        return this;
    }

    public Printer incr() {
        this.indent += 2;
        return this;
    }

    public Printer decr() {
        this.indent -= 2;
        return this;
    }

    public Printer indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(' ');
        }
        this.column += this.indent;
        return this;
    }

    public Printer indentLess() {
        int w = this.indent - 2;
        if (0 > w) {
            w = 0;
        }
        for (int i = 0; i < w; ++i) {
            this.out.print(' ');
        }
        this.column += w;
        return this;
    }

    public Printer indentMore() {
        int w = this.indent + 2;
        for (int i = 0; i < w; ++i) {
            this.out.print(' ');
        }
        this.column += w;
        return this;
    }

    public Printer p(char c) {
        this.out.print(c);
        ++this.column;
        return this;
    }

    public Printer p(int i) {
        return this.p(Integer.toString(i));
    }

    public Printer p(long l) {
        return this.p(Long.toString(l));
    }

    public Printer p(double d) {
        return this.p(Double.toString(d));
    }

    public Printer p(String s) {
        this.out.print(s);
        this.column += s.length();
        return this;
    }

    public Printer pln(char c) {
        this.unbuffer();
        this.out.println(c);
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer pln(int i) {
        return this.pln(Integer.toString(i));
    }

    public Printer pln(long l) {
        return this.pln(Long.toString(l));
    }

    public Printer pln(double d) {
        return this.pln(Double.toString(d));
    }

    public Printer pln(String s) {
        this.unbuffer();
        this.out.println(s);
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer pln() {
        this.unbuffer();
        this.out.println();
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer escape(char c) {
        return this.p(Utilities.escape(c, 9));
    }

    public Printer escape(char c, int flags) {
        return this.p(Utilities.escape(c, flags));
    }

    public Printer escape(String s) {
        return this.p(Utilities.escape(s, 9));
    }

    public Printer escape(String s, int flags) {
        return this.p(Utilities.escape(s, flags));
    }

    public Printer pad(long l, int width) {
        String text = Long.toString(l);
        int padding = width - text.length();
        for (int i = 0; i < padding; ++i) {
            this.p(' ');
        }
        this.p(text);
        return this;
    }

    public Printer sep() {
        this.unbuffer();
        this.indent().p("// ");
        int n = 78 - this.indent - 3;
        for (int i = 0; i < n; ++i) {
            this.out.print('=');
        }
        this.out.println();
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer wrap(int alignment, String text) {
        if (null == this.breaks) {
            this.breaks = BreakIterator.getLineInstance(Locale.ENGLISH);
        }
        this.breaks.setText(text);
        int start = this.breaks.first();
        int end = this.breaks.next();
        boolean first = true;
        while (-1 != end) {
            String word = text.substring(start, end);
            if (!first && 79 < this.column + word.length()) {
                this.pln();
                if (1 != alignment) {
                    this.align(alignment);
                }
            }
            this.p(word);
            start = end;
            end = this.breaks.next();
            first = false;
        }
        return this;
    }

    public Printer p(Node node) {
        this.visitor.dispatch(node);
        return this;
    }

    public Printer p(Attribute attribute) {
        this.p(attribute.name);
        if (null != attribute.value) {
            this.p('(');
            if (attribute.value instanceof List || attribute.value instanceof Pair) {
                boolean first = true;
                for (Object o : (Iterable)attribute.value) {
                    if (first) {
                        first = false;
                    } else {
                        this.p(", ");
                    }
                    this.p(o.toString());
                }
            } else {
                this.p(attribute.value.toString());
            }
            this.p(')');
        }
        return this;
    }

    public Printer p(Comment comment) {
        if (0 == comment.text.size()) {
            return this;
        }
        if (Comment.Kind.SINGLE_LINE == comment.kind) {
            this.p("// ").pln(comment.text.get(0));
        } else {
            if (Comment.Kind.MULTIPLE_LINES == comment.kind) {
                this.p("/*");
            } else {
                this.p("/**");
            }
            if (1 == comment.text.size()) {
                this.p(' ').p(comment.text.get(0)).pln(" */");
            } else {
                this.pln();
                for (String line : comment.text) {
                    this.indent().p(" * ").pln(line);
                }
                this.indent().pln(" */");
            }
        }
        return this;
    }

    public Printer format(Node n) {
        return this.format1(n, false);
    }

    public Printer format(Node n, boolean locate) {
        this.formatFile = null;
        return this.format1(n, locate);
    }

    private Printer format1(Object o, boolean locate) {
        this.indent();
        if (null == o) {
            this.p("null");
        } else if (o instanceof Node) {
            Node n = (Node)o;
            this.p(n.getName());
            if (locate && n.hasLocation()) {
                Location loc = n.getLocation();
                this.p('@');
                if (!loc.file.equals(this.formatFile)) {
                    this.p(loc.file).p(':');
                    this.formatFile = loc.file;
                }
                this.p(loc.line).p(':').p(loc.column);
            }
            this.p('(');
            if (n.isEmpty()) {
                this.p(')');
            } else {
                this.pln().incr().formatElements(n, locate).decr().indent().p(')');
            }
        } else if (o instanceof Pair) {
            Pair p = (Pair)o;
            if (p.isEmpty()) {
                this.p("[]");
            } else {
                this.pln('[').incr().formatElements(p, locate).decr().indent().p(']');
            }
        } else if (o instanceof String) {
            this.p('\"').escape(o.toString(), 9).p('\"');
        } else {
            this.p(o.toString());
        }
        return this;
    }

    private Printer formatElements(Iterable<?> composite, boolean locate) {
        Iterator<?> iter = composite.iterator();
        while (iter.hasNext()) {
            this.format1(iter.next(), locate);
            if (iter.hasNext()) {
                this.p(',');
            }
            this.pln();
        }
        return this;
    }

    public Printer loc(Locatable locatable) {
        Node node;
        if (locatable instanceof Node && (node = (Node)locatable).hasProperty("xtc.Constants.Original")) {
            locatable = (Locatable)node.getProperty("xtc.Constants.Original");
        }
        if (locatable.hasLocation()) {
            Location loc = locatable.getLocation();
            this.p(loc.file).p(':').p(loc.line).p(':').p(loc.column);
        }
        return this;
    }

    public Printer lineUp(Locatable locatable) {
        return this.lineUp(locatable, 0);
    }

    public Printer lineUp(Locatable locatable, int before) {
        if (!locatable.hasLocation()) {
            throw new IllegalArgumentException("Locatable without location " + locatable);
        }
        Location loc = locatable.getLocation();
        if (0 > loc.column - before) {
            throw new IllegalArgumentException("Invalid character distance " + before);
        }
        if ((long)loc.line > this.line) {
            int i = 0;
            while ((long)i < (long)loc.line - this.line) {
                this.pln();
                ++i;
            }
            for (i = 0; i < loc.column - before; ++i) {
                this.p(' ');
            }
        } else if ((long)loc.line == this.line && loc.column - before >= this.column) {
            for (int i = 0; i < loc.column - before - this.column; ++i) {
                this.p(' ');
            }
        } else {
            this.p(' ');
        }
        return this;
    }

    public Printer flush() {
        this.out.flush();
        return this;
    }

    public void close() {
        this.stopBuffering();
        this.out.close();
    }
}

