/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.List;
import xtc.tree.Annotation;
import xtc.tree.Node;
import xtc.util.Utilities;

public class Comment
extends Annotation {
    public Kind kind;
    public List<String> text;

    public Comment(Kind kind, List<String> text) {
        this(kind, text, null);
    }

    public Comment(Kind kind, List<String> text, Node node) {
        super(node);
        this.kind = kind;
        this.text = text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)o;
        if (this.kind != other.kind) {
            return false;
        }
        if (!this.text.equals(other.text)) {
            return false;
        }
        if (null == this.node) {
            return null == other.node;
        }
        return this.node.equals(other.node);
    }

    public static Comment documentation(String s) {
        int i;
        if (null == s) {
            return null;
        }
        if (4 > s.length()) {
            throw new IllegalArgumentException("Invalid documentation comment");
        }
        String[] ss = Utilities.COMMENT_NEWLINE.split(s = s.substring(3, s.length() - 2));
        if (0 < ss.length) {
            ss[0] = ss[0].trim();
            if (1 != ss.length) {
                ss[ss.length - 1] = ss[ss.length - 1].trim();
            }
        }
        int start = ss.length;
        int end = ss.length - 1;
        for (i = 0; i < ss.length; ++i) {
            if ("".equals(ss[i])) continue;
            start = i;
            break;
        }
        for (i = ss.length - 1; i >= 0; --i) {
            if ("".equals(ss[i])) continue;
            end = i;
            break;
        }
        ArrayList<String> l = new ArrayList<String>(end - start + 1);
        for (int i2 = start; i2 <= end; ++i2) {
            l.add(ss[i2]);
        }
        return new Comment(Kind.DOCUMENTATION, l);
    }

    public static enum Kind {
        SINGLE_LINE,
        MULTIPLE_LINES,
        DOCUMENTATION;

    }
}

