/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.IOException;
import java.util.List;
import xtc.tree.Node;
import xtc.util.Pair;

public class Attribute
extends Node {
    final String name;
    final Object value;

    public Attribute(String name) {
        this(name, null);
    }

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public boolean hasTraversal() {
        return true;
    }

    @Override
    public int size() {
        return null == this.value ? 1 : 2;
    }

    @Override
    public Object get(int index) {
        if (0 == index) {
            return this.name;
        }
        if (null != this.value && 1 == index) {
            return this.value;
        }
        throw new IndexOutOfBoundsException("Index : " + index + ", Size: " + (null == this.value ? 1 : 2));
    }

    @Override
    public Object set(int index, Object value) {
        throw new IllegalStateException("Attributes are immutable");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (null == this.value) {
            return null == other.value;
        }
        return this.value.equals(other.value);
    }

    @Override
    public void write(Appendable out) throws IOException {
        out.append(this.name);
        if (null != this.value) {
            out.append('(');
            if (this.value instanceof List || this.value instanceof Pair) {
                boolean first = true;
                for (Object o : (Iterable)this.value) {
                    if (first) {
                        first = false;
                    } else {
                        out.append(", ");
                    }
                    if (o instanceof Node) {
                        ((Node)o).write(out);
                        continue;
                    }
                    out.append(o.toString());
                }
            } else if (this.value instanceof Node) {
                ((Node)this.value).write(out);
            } else {
                out.append(this.value.toString());
            }
            out.append(')');
        }
    }

    public static Attribute get(String name, List<Attribute> list) {
        if (null == list) {
            return null;
        }
        for (Attribute att : list) {
            if (!name.equals(att.name)) continue;
            return att;
        }
        return null;
    }

    public static boolean areEquivalent(List<Attribute> l1, List<Attribute> l2) {
        if (null == l1) {
            return null == l2 || 0 == l2.size();
        }
        if (null == l2) {
            return 0 == l1.size();
        }
        return l1.containsAll(l2) && l2.containsAll(l1);
    }
}

