/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.ErrorT;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.VariantT;
import xtc.type.Wildcard;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class VariantSorter
extends Visitor {
    private static final int DEBUG = 0;
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected final Typer gtyper;
    protected Map<Node, Node> malformed;
    protected boolean isPushMode;
    protected List<Production> productions;
    protected boolean hasChanged;
    protected List<Type> types;
    protected FullProduction production;
    protected boolean isGeneric;
    protected List<Element> elements;

    public VariantSorter(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
        this.gtyper = new Typer();
        this.malformed = new IdentityHashMap<Node, Node>();
        this.productions = new ArrayList<Production>();
        this.types = new ArrayList<Type>();
        this.elements = new ArrayList<Element>();
    }

    protected Type merge(VariantT v1, VariantT v2, Production p) {
        assert (v1.isPolymorphic());
        if (this.ast.unify(v1, v2, true).isError()) {
            this.runtime.error("production's alternatives have distinct variants", p);
            this.runtime.errConsole().loc(p).pln(": error: but include same generic node");
            this.runtime.errConsole().loc(p).p(": error: 1st type is '");
            this.ast.print(v1, this.runtime.errConsole(), false, true, null);
            this.runtime.errConsole().pln("'");
            this.runtime.errConsole().loc(p).p(": error: 2nd type is '");
            this.ast.print(v2, this.runtime.errConsole(), false, true, null);
            this.runtime.errConsole().pln("'").flush();
            return ErrorT.TYPE;
        }
        VariantT result = v1;
        if (v2.isPolymorphic()) {
            for (TupleT tuple : v2.getTuples()) {
                this.ast.add(tuple, v1);
            }
        } else {
            this.ast.add(this.ast.toTuple(v2), v1);
        }
        return result;
    }

    protected void setType(Production p, Type t) {
        p.type = t.isError() ? t : (AST.isGenericNode(p.type) ? t.annotate().attribute(Constants.ATT_GENERIC) : t);
    }

    protected void pushPull(Module m) {
        boolean first = true;
        do {
            this.isPushMode = true;
            this.hasChanged = first;
            if (first) {
                first = false;
            }
            while (!this.productions.isEmpty()) {
                Production p = this.productions.remove(0);
                this.types.clear();
                this.types.add(p.type.resolve());
                this.analyzer.process(p);
            }
            if (!this.hasChanged) continue;
            for (Production p : m.productions) {
                Type t;
                if (!AST.isDynamicNode(p.type) || !AST.isGenericNode(p.type)) continue;
                if (Analyzer.setsValue(p.choice, false) || (t = this.gtyper.type(p, false)).isError()) continue;
                this.setType(p, t);
            }
            this.isPushMode = false;
            this.hasChanged = false;
            for (Production p : m.productions) {
                if (!AST.isDynamicNode(p.type)) continue;
                this.analyzer.process(p);
            }
        } while (!this.productions.isEmpty());
    }

    public void visit(Module m) {
        new Registrar().dispatch(m);
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.malformed.clear();
        this.productions.clear();
        this.elements.clear();
        if (!m.hasProperty("root")) {
            this.runtime.error("grammar without distinct root", m);
            return;
        }
        FullProduction p = this.analyzer.lookup((NonTerminal)m.getProperty("root"));
        if (!AST.isNode(p.type)) {
            this.runtime.error("grammar's root production does not return a node", p);
            return;
        }
        p.attributes.remove(Constants.ATT_VARIANT);
        this.setType(p, this.ast.toVariant(p.qName.name, false));
        this.productions.add(p);
        for (Production p2 : m.productions) {
            if (!p2.hasAttribute(Constants.ATT_VARIANT)) continue;
            this.setType(p2, this.ast.toVariant(p2.qName.name, false));
            this.productions.add(p2);
        }
        this.pushPull(m);
        for (Production p2 : m.productions) {
            Type t;
            if (!AST.isDynamicNode(p2.type) || !AST.isGenericNode(p2.type) || (t = this.gtyper.type(p2, true)).isError()) continue;
            this.setType(p2, t);
            this.productions.add(p2);
        }
        this.pushPull(m);
        for (Production p2 : m.productions) {
            if (!AST.isDynamicNode(p2.type)) continue;
            this.analyzer.notWorkingOnAny();
            if (!this.analyzer.consumesInput(p2.qName)) {
                p2.type = AST.NULL_NODE;
                continue;
            }
            this.runtime.error("unable to determine static type", p2);
        }
    }

    public void visit(FullProduction p) {
        this.production = p;
        this.isGeneric = AST.isGenericNode(p.type);
        if (this.isPushMode) {
            if (AST.isDynamicNode(p.type)) {
                this.hasChanged = true;
                this.setType(p, this.types.get(0));
            }
        } else {
            this.types.clear();
        }
        this.analyzer.workingOn(p.qName);
        if (this.isGeneric && DirectLeftRecurser.isTransformable(p)) {
            for (Sequence s : p.choice.alternatives) {
                Binding b;
                if (DirectLeftRecurser.isRecursive(s, p) || null == (b = this.analyzer.bind(s.elements))) continue;
                b.name = "yyValue";
            }
        }
        this.dispatch(p.choice);
        if (!this.isPushMode) {
            Type result = Wildcard.TYPE;
            boolean seenWild = false;
            boolean seenPoly = false;
            block6: for (Type t : this.types) {
                switch (t.tag()) {
                    case ERROR: {
                        result = ErrorT.TYPE;
                        break block6;
                    }
                    case WILDCARD: {
                        seenWild = true;
                        if (!seenPoly) continue block6;
                        this.runtime.error("production requires polymorphic variant", p);
                        this.runtime.errConsole().loc(p).pln(": error: but has alternatives without static type").flush();
                        result = ErrorT.TYPE;
                        break block6;
                    }
                    case VARIANT: {
                        if (seenPoly) {
                            if (!(result = this.merge(result.toVariant(), t.toVariant(), p)).isError()) continue block6;
                            break block6;
                        }
                        if (result.isWildcard()) {
                            result = t;
                            break;
                        }
                        if (result.equals(t)) continue block6;
                        if (this.isGeneric) {
                            this.runtime.error("variant '" + result.toVariant().getName() + "' " + "overlaps with '" + t.toVariant().getName() + "'", p);
                            result = ErrorT.TYPE;
                            break block6;
                        }
                        if (seenWild) {
                            this.runtime.error("production requires polymorphic variant", p);
                            this.runtime.errConsole().loc(p).pln(": error: but has alternatives without static type").flush();
                            result = ErrorT.TYPE;
                            break block6;
                        }
                        VariantT v = result.toVariant();
                        result = this.merge(this.ast.toVariant(p.qName.name, true), v, p);
                        if (result.isError() || (result = this.merge(result.toVariant(), t.toVariant(), p)).isError()) break block6;
                        seenPoly = true;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unrecognized type " + t));
                    }
                }
            }
            if (!result.isWildcard()) {
                this.setType(p, result);
                Type r = result.resolve();
                if (r.isVariant() && !r.toVariant().isPolymorphic()) {
                    this.productions.add(p);
                }
            }
        }
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
        }
    }

    public void visit(Sequence s) {
        int base = this.elements.size();
        Iterator<Element> iter = s.elements.iterator();
        while (iter.hasNext()) {
            Element e = iter.next();
            if (!iter.hasNext() && e instanceof OrderedChoice) {
                this.dispatch(e);
                continue;
            }
            this.elements.add(e);
        }
        if (!s.hasTrailingChoice()) {
            if (this.isGeneric) {
                Element pass = null;
                NodeMarker mark = null;
                block5: for (Element e : this.elements) {
                    switch (e.tag()) {
                        case BINDING: {
                            Binding b = (Binding)e;
                            if (!"yyValue".equals(b.name)) continue block5;
                            pass = b.element;
                            break;
                        }
                        case NODE_MARKER: {
                            mark = (NodeMarker)e;
                        }
                    }
                }
                if (null != pass) {
                    this.recurse(pass);
                } else if (this.isPushMode) {
                    String name = this.production.qName.name;
                    if (null != mark) {
                        name = Utilities.qualify(Utilities.getQualifier(name), mark.name);
                    }
                    boolean hasTuple = this.ast.hasTuple(name);
                    TupleT tuple = this.ast.toTuple(name);
                    List<VariantT> variants = this.ast.toVariants(tuple);
                    if (!hasTuple || variants.isEmpty()) {
                        this.ast.add(tuple, this.types.get(0).toVariant());
                    } else if (!variants.contains(this.types.get(0))) {
                        this.runtime.error("tuple '" + name + "' should appear in variant '" + this.types.get(0).toVariant().getName() + "'", this.production);
                        this.runtime.errConsole().loc(this.production).p(": error: but already ").p("appears in variant '").p(variants.get(0).getName()).pln("'").flush();
                        variants.add(this.types.get(0).toVariant());
                    }
                }
            } else {
                Element value = this.analyzer.getValue(this.elements, true);
                if (null != value) {
                    this.recurse(value);
                }
            }
        }
        if (0 == base) {
            this.elements.clear();
        } else {
            this.elements.subList(base, this.elements.size()).clear();
        }
    }

    protected void recurse(Element e) {
        Element start;
        e = Analyzer.strip(e);
        do {
            start = e;
            if (e instanceof Binding) {
                e = Analyzer.strip(((Binding)e).element);
            }
            if (!(e instanceof Option)) continue;
            e = Analyzer.strip(((Option)e).element);
        } while (start != e);
        List<Type> savedTypes = this.types;
        FullProduction savedProduction = this.production;
        boolean savedIsGeneric = this.isGeneric;
        List<Element> savedElements = this.elements;
        switch (e.tag()) {
            case NONTERMINAL: {
                FullProduction p = this.analyzer.lookup((NonTerminal)e);
                if (this.analyzer.isBeingWorkedOn(p.qName)) {
                    if (!this.isPushMode) {
                        this.types.add(Wildcard.TYPE);
                    }
                    return;
                }
                if (p.type.isError()) {
                    if (!this.isPushMode) {
                        this.types.add(ErrorT.TYPE);
                    }
                    return;
                }
                if (AST.isStaticNode(p.type)) {
                    if (this.isPushMode && !this.types.get(0).equals(p.type.resolve())) {
                        if (!this.malformed.containsKey(p)) {
                            this.runtime.error("variant '" + this.types.get(0).toVariant().getName() + "' overlaps with '" + p.type.resolve().toVariant().getName() + "'", p);
                            this.malformed.put(p, p);
                        }
                        return;
                    }
                    if (!this.isPushMode) {
                        this.types.add(p.type.resolve());
                    }
                    return;
                }
                assert (!AST.isVoid(p.type));
                if (AST.isString(p.type)) {
                    if (!this.malformed.containsKey(p)) {
                        this.runtime.error("variant type for production with string value", p);
                        this.malformed.put(p, p);
                    }
                    if (!this.isPushMode) {
                        this.types.add(ErrorT.TYPE);
                    }
                    return;
                }
                if (AST.isToken(p.type)) {
                    if (!this.malformed.containsKey(p)) {
                        this.runtime.error("variant type for production with token value", p);
                        this.malformed.put(p, p);
                    }
                    if (!this.isPushMode) {
                        this.types.add(ErrorT.TYPE);
                    }
                    return;
                }
                if (!this.isPushMode) {
                    this.types = new ArrayList<Type>();
                }
                this.elements = new ArrayList<Element>();
                this.dispatch(p);
                if (this.isPushMode || AST.isDynamicNode(p.type)) break;
                savedTypes.add(p.type.resolve());
                break;
            }
            case SEQUENCE: 
            case CHOICE: {
                this.isGeneric = false;
                this.elements = new ArrayList<Element>();
                this.dispatch(e);
                break;
            }
            case NULL: {
                if (!this.isPushMode) {
                    this.types.add(Wildcard.TYPE);
                }
                return;
            }
            default: {
                if (!this.malformed.containsKey(e)) {
                    this.runtime.error("variant type for invalid element", e);
                    this.malformed.put(e, e);
                }
                if (!this.isPushMode) {
                    this.types.add(ErrorT.TYPE);
                }
                return;
            }
        }
        this.types = savedTypes;
        this.production = savedProduction;
        this.isGeneric = savedIsGeneric;
        this.elements = savedElements;
    }

    public class Typer
    extends Visitor {
        protected boolean create;
        protected FullProduction production;
        protected List<Element> elements = new ArrayList<Element>();
        protected Set<String> names = new HashSet<String>();
        protected Type type;

        public Type type(Production p, boolean create) {
            assert (AST.isDynamicNode(p.type));
            assert (AST.isGenericNode(p.type));
            this.create = create;
            return (Type)this.dispatch(p);
        }

        public Type visit(FullProduction p) {
            String name;
            FullProduction p2;
            this.production = p;
            this.elements.clear();
            this.names.clear();
            this.dispatch(p.choice);
            if (this.names.isEmpty()) {
                return ErrorT.TYPE;
            }
            VariantT variant = null;
            boolean isValid = false;
            for (String name2 : this.names) {
                List<VariantT> variants;
                if (VariantSorter.this.ast.hasTuple(name2) && 1 == (variants = VariantSorter.this.ast.toVariants(VariantSorter.this.ast.toTuple(name2))).size()) {
                    if (null == variant) {
                        variant = variants.get(0);
                        isValid = true;
                        continue;
                    }
                    if (variant == variants.get(0)) continue;
                }
                isValid = false;
                break;
            }
            if (isValid) {
                return variant;
            }
            if (1 == this.names.size() && null != (p2 = VariantSorter.this.analyzer.lookup(new NonTerminal(name = this.names.iterator().next()))) && AST.isGenericNode(p2.type) && AST.isStaticNode(p2.type)) {
                return p2.type;
            }
            return this.create ? VariantSorter.this.ast.toVariant(p.qName.name, false) : ErrorT.TYPE;
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void visit(Sequence s) {
            int base = this.elements.size();
            Iterator<Element> iter = s.elements.iterator();
            while (iter.hasNext()) {
                Element e = iter.next();
                if (!iter.hasNext() && e instanceof OrderedChoice) {
                    this.dispatch(e);
                    continue;
                }
                this.elements.add(e);
            }
            if (!s.hasTrailingChoice()) {
                boolean pass = false;
                NodeMarker mark = null;
                block5: for (Element e : this.elements) {
                    switch (e.tag()) {
                        case BINDING: {
                            Binding b = (Binding)e;
                            if (!"yyValue".equals(b.name)) break;
                            pass = true;
                            break block5;
                        }
                        case NODE_MARKER: {
                            mark = (NodeMarker)e;
                        }
                    }
                }
                if (!pass) {
                    String name = this.production.qName.name;
                    if (null != mark) {
                        name = Utilities.qualify(Utilities.getQualifier(name), mark.name);
                    }
                    if (!this.names.contains(name)) {
                        this.names.add(name);
                    }
                }
            }
            if (0 == base) {
                this.elements.clear();
                return;
            }
            this.elements.subList(base, this.elements.size()).clear();
        }
    }

    public class Registrar
    extends Visitor {
        protected List<Element> elements = new ArrayList<Element>();

        public void visit(Module m) {
            VariantSorter.this.analyzer.register(this);
            VariantSorter.this.analyzer.init(m);
            this.elements.clear();
            for (Production p : m.productions) {
                if (!AST.isGenericNode(p.type)) continue;
                VariantSorter.this.analyzer.process(p);
            }
        }

        public void visit(FullProduction p) {
            this.dispatch(p.choice);
        }

        public void visit(OrderedChoice c) {
            for (Sequence alt : c.alternatives) {
                this.dispatch(alt);
            }
        }

        public void visit(Sequence s) {
            int base = this.elements.size();
            Iterator<Element> iter = s.elements.iterator();
            while (iter.hasNext()) {
                Element e = iter.next();
                if (!iter.hasNext() && e instanceof OrderedChoice) {
                    this.dispatch(e);
                    continue;
                }
                this.elements.add(e);
            }
            if (!s.hasTrailingChoice()) {
                NodeMarker mark = null;
                for (Element e : this.elements) {
                    if (!(e instanceof NodeMarker)) continue;
                    mark = (NodeMarker)e;
                }
                String name = VariantSorter.this.analyzer.current().qName.name;
                if (null != mark) {
                    name = Utilities.qualify(Utilities.getQualifier(name), mark.name);
                }
                VariantSorter.this.ast.toTuple(name);
            }
            if (0 == base) {
                this.elements.clear();
            } else {
                this.elements.subList(base, this.elements.size()).clear();
            }
        }
    }
}

