/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public class ValueChecker
extends Visitor {
    protected Runtime runtime;
    protected Analyzer analyzer;
    protected List<Element> elements;

    public ValueChecker(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.elements = new ArrayList<Element>();
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.elements.clear();
        for (Production p : m.productions) {
            this.dispatch(p);
        }
    }

    public void visit(FullProduction p) {
        this.dispatch(p.choice);
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
        }
    }

    public void visit(Sequence s) {
        int base = this.elements.size();
        Iterator<Element> iter = s.elements.iterator();
        while (iter.hasNext()) {
            Element e = iter.next();
            if (!iter.hasNext() && e instanceof OrderedChoice) {
                this.dispatch(e);
                continue;
            }
            this.elements.add(e);
        }
        if (!s.hasTrailingChoice() && !Analyzer.setsValue(this.elements, false)) {
            int size = this.elements.size();
            if (0 == size) {
                this.runtime.error("empty alternative without semantic value", s);
            } else if (this.elements.get(size - 1).hasLocation()) {
                this.runtime.error("last element in alternative without semantic value", this.elements.get(size - 1));
            } else {
                this.runtime.error("alternative without semantic value", s);
            }
        }
        if (0 == base) {
            this.elements.clear();
        } else {
            this.elements.subList(base, this.elements.size()).clear();
        }
    }
}

