/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.UnitT;
import xtc.type.VariantT;
import xtc.util.Runtime;

public class TreeTyper
extends Visitor {
    private static final boolean DEBUG = false;
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean strict;
    protected boolean flatten;
    protected Sequence sequence;

    public TreeTyper(Runtime runtime, Analyzer analyzer, AST ast) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = ast;
    }

    public void visit(Module m) {
        this.analyzer.register(this);
        this.analyzer.init(m);
        this.strict = this.runtime.test("optionVariant");
        this.flatten = m.hasAttribute(Constants.ATT_FLATTEN);
        for (Production p : m.productions) {
            this.analyzer.process(p);
        }
        Printer printer = this.runtime.console();
        printer.sep();
        printer.indent().p("// Generated by Rats!, version ").p("1.15.0").p(", ").p("(C) 2004-2009 Robert Grimm").pln('.');
        printer.sep();
        printer.pln();
        printer.indent().p("/** AST structure for grammar ").p(m.name.name).pln(". */");
        if (!this.runtime.test("optionVariant")) {
            VariantT node = this.ast.toVariant("Node", false);
            this.ast.concretizeTuples(node, UnitT.TYPE);
            printer.indent().p("module ").p(m.name.name).p("Tree").pln(';');
            printer.pln();
            this.ast.print(node, printer, true, false, null);
            printer.pln();
        } else {
            VariantT variant;
            String name;
            VariantT root = this.analyzer.lookup((NonTerminal)((NonTerminal)m.getProperty((String)"root"))).type.resolve().toVariant();
            AST.MetaData meta = this.ast.getMetaData(root);
            HashSet<String> processed = new HashSet<String>();
            for (Production p : m.productions) {
                if (!AST.isStaticNode(p.type) || !meta.reachable.contains(name = (variant = p.type.resolve().toVariant()).getName()) || processed.contains(name)) continue;
                processed.add(name);
                this.ast.concretizeTuples(variant, UnitT.TYPE);
            }
            processed.clear();
            if (!meta.modularize) {
                printer.indent().p("module ").p(m.name.name).p("Tree").pln(';');
                printer.pln();
                for (Production p : m.productions) {
                    if (!AST.isStaticNode(p.type) || !meta.reachable.contains(name = (variant = p.type.resolve().toVariant()).getName()) || processed.contains(name)) continue;
                    processed.add(name);
                    this.ast.print(variant, printer, true, false, null);
                    printer.pln();
                }
            } else {
                String module;
                boolean first = true;
                do {
                    module = null;
                    for (Production p : m.productions) {
                        VariantT variant2;
                        String name2;
                        if (!AST.isStaticNode(p.type) || !meta.reachable.contains(name2 = (variant2 = p.type.resolve().toVariant()).getName()) || processed.contains(name2)) continue;
                        String qualifier = variant2.getQualifier();
                        if (null == module) {
                            module = qualifier;
                            if (first) {
                                first = false;
                            } else {
                                printer.sep().pln();
                            }
                            printer.indent().p("module ").p(module).pln(';');
                            printer.pln();
                        } else if (!module.equals(qualifier)) continue;
                        processed.add(name2);
                        this.ast.print(variant2, printer, true, true, module);
                        printer.pln();
                    }
                } while (null != module);
            }
        }
        printer.sep().flush();
    }

    public void visit(Production p) {
        this.dispatch(p.choice);
    }

    public void visit(OrderedChoice c) {
        for (Sequence alt : c.alternatives) {
            this.dispatch(alt);
        }
    }

    public void visit(Sequence s) {
        Sequence old = this.sequence;
        this.sequence = s;
        for (Element e : s.elements) {
            this.dispatch(e);
        }
        this.sequence = old;
    }

    public void visit(UnaryOperator op) {
        this.dispatch(op.element);
    }

    public void visit(Element e) {
    }

    public void visit(GenericNodeValue v) {
        this.process(v.name, false, v.children);
    }

    public void visit(GenericActionValue v) {
        this.process(v.name, true, v.children);
    }

    protected void process(String name, boolean isAction, List<Binding> children) {
        Type result;
        boolean fresh;
        if (this.flatten) {
            boolean isCopy = false;
            block4: for (int i = 0; i < children.size() - 1; ++i) {
                Binding b1 = children.get(i);
                if (!(b1.element instanceof NonTerminal)) continue;
                NonTerminal nt1 = (NonTerminal)b1.element;
                Binding b2 = children.get(i + 1);
                switch (b2.element.tag()) {
                    case REPETITION: {
                        Repetition rep = (Repetition)b2.element;
                        Binding bdg = Analyzer.getBinding(((Sequence)rep.element).elements);
                        if (null == bdg) {
                            throw new IllegalStateException("Malformed repetition " + rep);
                        }
                        if (nt1.equals(bdg.element)) break;
                        continue block4;
                    }
                    case NONTERMINAL: {
                        NonTerminal non = (NonTerminal)b2.element;
                        FullProduction prod = this.analyzer.lookup(non);
                        if (nt1.equals(prod.getProperty("repeated"))) break;
                        continue block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                if (!isCopy) {
                    children = new ArrayList<Binding>(children);
                    isCopy = true;
                }
                children.remove(i);
                if (-1 <= (i -= 2)) continue;
                i = -1;
            }
        }
        int size = isAction ? children.size() + 1 : children.size();
        ArrayList<Type> types = new ArrayList<Type>(size);
        if (isAction) {
            if (this.runtime.test("optionVariant")) {
                Type t = this.analyzer.current().type;
                if (AST.isList(t)) {
                    t = AST.getArgument(t);
                }
                if (AST.isAction(t)) {
                    t = AST.getArgument(t);
                }
                types.add(t);
            } else {
                types.add(AST.NODE);
            }
        }
        for (Binding b : children) {
            types.add(this.analyzer.type(b.element));
        }
        TupleT t1 = this.ast.toTuple(name);
        TupleT t2 = new TupleT(name, types);
        boolean bl = fresh = null == t1.getTypes();
        if (fresh && !this.runtime.test("optionVariant")) {
            this.ast.add(t1, this.ast.toVariant("Node", false));
        }
        if (!fresh) {
            result = this.ast.combine(t1, t2, this.flatten, this.strict);
            if (result.isError()) {
                this.runtime.error("unable to consistently type tuple '" + name + "'", this.sequence);
                this.runtime.errConsole().loc(this.sequence).p(": error: 1st type is '");
                this.ast.print((Type)t1, this.runtime.errConsole(), false, true, null);
                this.runtime.errConsole().pln("'");
                this.runtime.errConsole().loc(this.sequence).p(": error: 2nd type is '");
                this.ast.print((Type)t2, this.runtime.errConsole(), false, true, null);
                this.runtime.errConsole().pln("'").flush();
            } else {
                t1.setTypes(result.toTuple().getTypes());
            }
        } else if (this.flatten) {
            result = this.ast.flatten(t2, this.strict);
            if (result.isError()) {
                this.runtime.error("unable to flatten tuple '" + name + "'", this.sequence);
                this.runtime.errConsole().loc(this.sequence).p(": error: type is '");
                this.ast.print((Type)t2, this.runtime.errConsole(), false, true, null);
                this.runtime.errConsole().pln("'").flush();
            } else {
                t1.setTypes(result.toTuple().getTypes());
            }
        } else {
            t1.setTypes(types);
        }
    }
}

